package com.aote.util.image;

import com.aote.weixin.Config;
import okhttp3.*;
import org.json.JSONObject;

import java.io.IOException;

/**
 * @description:
 * @author: 唐梓烨
 * @time: 2024/5/15 19:06
 */
public class AliTextRecognition {
    static final OkHttpClient HTTP_CLIENT = new OkHttpClient().newBuilder().build();
    public JSONObject textRecognition(String value) throws IOException {
        JSONObject param = new JSONObject();
        param.put("image",value);
        MediaType mediaType = MediaType.parse("application/json; charset=UTF-8");
        RequestBody body = RequestBody.create(mediaType, param.toString());
        Request request = new Request.Builder()
                .url("https://gas.market.alicloudapi.com/api/predict/gas_meter_end2end")
                .method("POST", body)
                .addHeader("Content-Type", "application/json; charset=UTF-8")
                .addHeader("Accept", "application/json")
                .addHeader("Authorization", "APPCODE " + Config.wechatConfig.getString("AliAPPCODE"))
                .build();
        Response response = HTTP_CLIENT.newCall(request).execute();
        return new JSONObject(response.body().string());
    }
}
