package com.aote.rs.scanpay;

import java.math.BigDecimal;
import java.util.SortedMap;
import java.util.TreeMap;

import com.aote.entity.WxPayReturnData;
import com.aote.entity.WxPaySendData;
import com.aote.util.WechatUrl;
import com.aote.util.WxSign;
import com.aote.util.XmlUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;

/**
 * 预付费处理
 * money 扫码支付的钱数
 * jsonobject 写到的商家数据包，支付 成功后可在attach内原样返回
 * str 商品描述，或缴费说明，必填
 */
@Component
public class WxcodePrepay {

	static Logger log = Logger.getLogger(WxcodePrepay.class);

	public JSONObject codeprePay(String appId, String key, String mchId,String money,JSONObject jsonobject,String str, String codeNotifyUrl, String ip) {
		JSONObject result = new JSONObject();
		try
		{
			WxPaySendData sendData = getPaySendEntity(appId, mchId, money, jsonobject, str, codeNotifyUrl, ip);
			String returnXml = unifiedOrder(sendData, key);
			log.debug("returnXml=" + returnXml);
			WxPayReturnData reData = (WxPayReturnData)XmlUtils.formatXml(returnXml, WxPayReturnData.class);
			String return_code = reData.getReturn_code();
			if (return_code.equals("SUCCESS"))
			{
				if (!reData.getResult_code().equals("SUCCESS"))
				{
					result.put("code", 500);
					result.put("msg", reData.getErr_code_des());
					return result;
				}
			}
			else
			{
				result.put("code", 500);
				result.put("msg", reData.getReturn_msg());
				return result;
			}
			result.put("code", 200);
			result.put("url", reData.getCode_url());
			result.put("out_trade_no", sendData.getOut_trade_no());
		}
		catch (Exception e)
		{
			throw new RuntimeException(e);
		}
		log.debug("result=" + result);
		return result;
	}

	public WxPaySendData getPaySendEntity(String appId, String mchId,String money,JSONObject jsonobject,String str, String codeNotifyUrl, String ip) {
		WxPaySendData result = new WxPaySendData();
		result.setAppid(appId);// appid
		result.setMch_id(mchId);//商户id
		result.setNonce_str(WxSign.getNonceStr());
		result.setBody(str);
		result.setAttach(jsonobject.toString());
		result.setOut_trade_no(WxSign.getNonceStr()); // 随机数
		BigDecimal v1 = new BigDecimal(money);
		Double b = v1.doubleValue();
		int fee1 = b.intValue();
        result.setTotal_fee(fee1);
		result.setSpbill_create_ip(ip); //订单生成的机器IP，指用户浏览器端IP 
		result.setNotify_url(codeNotifyUrl);//支付完回调地址
		result.setTrade_type("NATIVE"); 
		return result;
	}

	public static String unifiedOrder(WxPaySendData data, String key) {
		// 统一下单支付
		String returnXml = null;
		try {
			// 生成sign签名
			SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
			parameters.put("appid", data.getAppid());
			parameters.put("mch_id", data.getMch_id());
			parameters.put("nonce_str",data.getNonce_str());
			parameters.put("body",data.getBody());
			parameters.put("detail", data.getDetail());
			parameters.put("attach", data.getAttach());
			parameters.put("out_trade_no",data.getOut_trade_no());
			parameters.put("total_fee",(Integer)data.getTotal_fee());
			parameters.put("spbill_create_ip",data.getSpbill_create_ip());
			parameters.put("notify_url",data.getNotify_url());
			parameters.put("trade_type",data.getTrade_type());// setTrade_type 交易类型 JSAPI--公众号支付、NATIVE--原生扫码支付、APP--app支付
			parameters.put("scene_info", data.getScene_info());
			parameters.put("sign", WxSign.createSign(parameters, key));
			data.setSign(WxSign.createSign(parameters, key));
			XStream xs = new XStream(new DomDriver("UTF-8",
					new XmlFriendlyNameCoder("-_", "_")));
			xs.alias("xml", WxPaySendData.class);
			String xml = xs.toXML(data);
			log.debug("sendXml======> " + xml);
			HttpClient httpClient = HttpClients.createDefault();
			HttpPost postRequest = new HttpPost(WechatUrl.DOWN_PAY_API);
			StringEntity postEntity = new StringEntity(xml, "UTF-8");
			postRequest.addHeader("Content-Type", "text/xml");
			postRequest.setEntity(postEntity);
			HttpResponse httpResponse = httpClient.execute(postRequest);
			HttpEntity entity = httpResponse.getEntity();
			if (entity != null) {
				returnXml = EntityUtils.toString(entity, "UTF-8");
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return returnXml;
	}

}
