package com.aote.rs.scanpay;


import cn.hutool.http.HttpUtil;
import com.af.plugins.DateTools;
import com.aote.entity.WxNofityReturnData;
import com.aote.logic.LogicServer;
import com.aote.rs.wechatpay.PayFee;
import com.aote.util.PropertiesUtil;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Hashtable;
import java.util.Map;

@Component
public class CodeNotify {
    static Logger log = Logger.getLogger(CodeNotify.class);

    @Autowired
    private LogicServer logicServer;

    private Map<String, Object> map = new Hashtable<>();

    public CodeNotify() {
    }

    public String CodeNotifypay(WxNofityReturnData reData) throws Exception {
        JSONObject data = PayFee.xml(reData);

        log.debug("解析好的数据result:" + data.toString());
        // 先查询本笔订单是否存在
        String f_out_trade_no = data.getString("f_out_trade_no");
        // 该订单正在处理
        if (map.containsKey(f_out_trade_no)) {
            log.debug("该订单正在处理中:" + f_out_trade_no);
            return "";
        }
        // 添加商户订单号
        map.put(f_out_trade_no, f_out_trade_no);
        // 通过商户订单号查询订单
        JSONObject outTradeJson = new JSONObject();
        outTradeJson.put("f_out_trade_no", f_out_trade_no);
        Object result = logicServer.run("SearchWechatOrderByOutTradeNo", outTradeJson.toString());
        log.debug("查询是否保存微信缴费回调记录 =======》" + result);
        if (!result.toString().isEmpty()) {
            JSONObject orderJson = new JSONObject(result.toString());
            log.debug("orderJson >>> " + orderJson);
            // 判断该订单是否支付成功,如果成功则不在进行收费操作
            if ("支付成功".equals(orderJson.getString("state"))) {
                log.debug("该订单已支付成功,本次操作取消");
                return "SUCCESS";
            }
            // 判断该订单是否超时,超时调用退款接口
            if (DateTools.compareDate(DateTools.getNow2(), orderJson.getString("f_time_out"))) {
                log.debug("订单超时,发起退款");
                JSONObject refund = new JSONObject();
                refund.put("transaction_id", data.getString("f_transaction_id"));
                refund.put("money", data.get("f_total_fee"));
                refund.put("filiale", new JSONObject(data.get("f_attach").toString()).getString("filiale"));
                // 发起退款
                HttpUtil.post(PropertiesUtil.getProperties("server") + "rs/weixin/refund", refund.toString(), 60000);
                return "SUCCESS";
            }
            String attachStr = orderJson.get("f_attach").toString();
            log.debug("attachStr >>> " + attachStr);
            JSONObject attachInfo = new JSONObject(attachStr);
            attachInfo.put("f_money", data.get("f_total_fee"));
            attachInfo.put("f_out_trade_no", data.get("f_out_trade_no"));
            log.debug("attachInfo ======> " + attachInfo);
            data.put("f_attach", attachInfo);
            data.put("id", orderJson.get("id"));
            data.put("state", "支付成功");
            log.debug("最终的需要修改的订单数据======>" + data.toString());
            logicServer.run("savewxreturnxml", data.toString());
            log.debug("调用其他收费订单======>" + attachInfo.toString());
            logicServer.run("otherFeeSelect", attachInfo.toString());
        }
        map.remove(f_out_trade_no);
        return "SUCCESS";
    }

}
