package com.aote.pay.yuantiao;


import cn.hutool.core.date.DateTime;
import cn.hutool.http.HttpUtil;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.sql.SqlServer;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.security.*;

/**
 * @author tzy
 */
@Slf4j
@Component
public class JsApiYuanTiao implements PaySuper, RefundSuper {
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");


        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            String publicKeyStr = wxConfig.getString("publicKey");
            // 渠道商代号，由开放式缴费平台分配
            String channelId = wxConfig.getString("channelId");
            // 支付商户号
            String merchantNo = wxConfig.getString("merchantNo");
            // 交易金额,单位为分
            String txnAmt = money;
            String orderNo = PayUtil.getOrderNoByNumber();
            String notifyUrl = wxConfig.getString("wechatNotify");
            /**
             * 开放式缴费平台地址
             */
            String PayUrl = wxConfig.getString("PayUrl");
            /**
             * 消息体
             */
            JSONObject body = new JSONObject();
            /**
             * 收费单位生成的订单号，需
             * 保证永久唯一。
             * 必填
             * 系统生成
             */
            body.put("machinePayNumber", orderNo);
            /**
             * 交易金额 单位分
             */
            body.put("transAccount", String.valueOf(new BigDecimal(txnAmt).setScale(2, BigDecimal.ROUND_HALF_UP)));
            /**
             * 后台通知收费单位支付结果
             * 必填
             */
            body.put("backUrl", notifyUrl);
            body.put("payWay", 15);
            body.put("merchantNo", merchantNo);
            body.put("channelId", channelId);
            /**
             * 收费单位发送交易时间，时
             * 间格式为
             * yyyy-MM-dd HH:mm:ss。
             */
            String orderDate = new DateTime().toString("yyyy-MM-dd HH:mm:ss");
            body.put("machineTime", orderDate);
            String pfxPath = wxConfig.getString("pfxPath");
            String pfxPassWord = wxConfig.getString("pfxPassWord");
            // 原文信息转json字符串-》使用RSA公钥进行加密-》进行base64编码-》获得密文encryptData。
            String encryptedData = RsaEncryptUtil.pubEncrypt(body.toString(), publicKeyStr);
            // 获取签名
            String signRSA = SignUtil.sign(pfxPath, pfxPassWord, encryptedData) ;
            JSONObject param = new JSONObject();
            param.put("merchantNo", merchantNo);
            param.put("channelId", channelId);
            param.put("encryptData", encryptedData);
            param.put("signData", signRSA);
            log.debug("开放式缴费平台地址:{}",PayUrl);
            log.debug("开放式缴费平台下单参数:{}",param);
            String response = HttpUtil.post(PayUrl,param.toString());
            log.info("接口返回报文为：{}", response);
            JSONObject responseData = new JSONObject(response);
            String decodeData = RsaEncryptUtil.pubDecrypt(responseData.getString("encryptData"), publicKeyStr);
            log.debug("接口数据解密后：{}", decodeData);
            JSONObject data = new JSONObject(decodeData);
            if (data.getInt("code") == 200) {
                JSONObject dataContent = new JSONObject(data.getString("data"));
                result.put("status", "success");
                result.put("cashierHtml",dataContent.getString("html"));
                JSONObject saveOrder = new JSONObject();
                saveOrder.put("f_out_trade_no", orderNo);
                saveOrder.put("f_attach", attach);
                saveOrder.put("f_openid", openid);
                saveOrder.put("flag", "JsApiYuanTiao");
                saveOrder.put("f_order_state", "已下单");
                saveOrder.put("f_send_time", orderDate);
                saveOrder.put("f_order_type", "燃气收费");
                saveOrder.put("f_trade_type", "JSAPI");
                saveOrder.put("f_filiale", filiale);
                saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
                // 保存分公司id
                JSONObject clientConfig = Config.getClientConfig(filiale);
                saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                logicServer.run("savewxreturnxml", saveOrder);
            } else {
                result.put("status", "fail");
                result.put("respMsg", data.getString("message"));
            }
        } catch (Exception e) {
            result.put("status", "fail");
            result.put("respMsg", e);
            log.debug("远眺科技平台下单异常错误", e);
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            String orderNo = jsonObject.getString("out_trade_no");
            String orderDate = jsonObject.getString("f_send_time");
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String channelId = wxConfig.getString("channelId");
            String merchantNo = wxConfig.getString("merchantNo");
            JSONObject body = new JSONObject();
            body.put("channelId", channelId);
            body.put("machinePayNumber", orderNo);
            body.put("machineTime", orderDate);
            String publicKeyStr = wxConfig.getString("publicKey");
            String pfxPath = wxConfig.getString("pfxPath");
            String pfxPassWord = wxConfig.getString("pfxPassWord");
            // 原文信息转json字符串-》使用RSA公钥进行加密-》进行base64编码-》获得密文encryptData。
            String encryptedData = RsaEncryptUtil.pubEncrypt(body.toString(), publicKeyStr);
            // 获取签名
            String signRSA = SignUtil.sign(pfxPath, pfxPassWord, encryptedData) ;
            JSONObject param = new JSONObject();
            param.put("merchantNo", merchantNo);
            param.put("channelId", channelId);
            param.put("encryptData", encryptedData);
            param.put("signData", signRSA);
            String QueryUrl = wxConfig.getString("QueryUrl");
            log.debug("开放平台查询地址:{}",QueryUrl);
            log.debug("开放平台查询参数:{}",param);
            String response = HttpUtil.post(QueryUrl,param.toString());
            log.debug("开放平台查询返回报文:{}",response);
            JSONObject responseData = new JSONObject(response);
            String decodeData = RsaEncryptUtil.pubDecrypt(responseData.getString("encryptData"), publicKeyStr);
            log.debug("接口数据解密后：{}", decodeData);
            JSONObject data = new JSONObject(decodeData);
            if (data.getInt("code") == 200) {
                JSONObject dataContent = new JSONObject(data.getString("data"));
                if (dataContent.getInt("orderStatus") == 0) {
                    result.put("result_code", "SUCCESS");
                    result.put("trade_state", "SUCCESS");
                    // 订单号
                    result.put("transaction_id",dataContent.getString("serverOrderNumber"));
                    // 交易金额
                    result.put("total_fee",PayUtil.yuan2FenInt(dataContent.get("transAccount")));
                    // 交易日期
                    result.put("time_end", new DateTime().toString("yyyyMMddHHmmss"));
                } else {
                    result.put("status", "fail");
                    result.put("trade_state", "fail");
                }
            } else {
                result.put("status", "fail");
                result.put("trade_state", "fail");
            }

        } catch (Exception e) {
            log.debug("查询订单出错:" + e);
            result.put("status", "fail");
            result.put("trade_state", "fail");
        }
        return result.toString();
    }

    @Override
    public JSONObject getRecordFile(JSONObject json) {
        return null;
    }

    @Override
    public String refund(JSONObject json) {
        String filiale = json.getString("f_filiale");
        Integer id = json.getInt("id");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            JSONObject refundParam = new JSONObject();
            // 商户号
            String merchantNo = wxConfig.getString("merchantNo");
            // 渠道id
            String channelId = wxConfig.getString("channelId");
            // 商户订单号，商户端保证唯一
            String outTradeNo = json.getString("out_trade_no");
            String orderDate = json.getString("f_send_time");
            String transactionId = json.optString("transaction_id","");
            String refundAmount = json.getString("f_total_fee");

            JSONObject body = new JSONObject();
            body.put("channelId",channelId);
            body.put("merchantNo",merchantNo);
            body.put("machinePayNumber",outTradeNo);
            body.put("payCentreOrderNumber",transactionId);
            body.put("originalMachinePayNumber",outTradeNo);
            body.put("originalMachineTime",orderDate);
            body.put("machineTime",orderDate);
            body.put("transAccount",refundAmount);

            String pfxPath = wxConfig.getString("pfxPath");
            String pfxPassWord = wxConfig.getString("pfxPassWord");
            String publicKeyStr = wxConfig.getString("publicKey");
            // 原文信息转json字符串-》使用RSA公钥进行加密-》进行base64编码-》获得密文encryptData。
            String encryptedData = RsaEncryptUtil.pubEncrypt(body.toString(), publicKeyStr);
            // 获取签名
            String signRSA = SignUtil.sign(pfxPath, pfxPassWord, encryptedData) ;
            JSONObject param = new JSONObject();
            param.put("merchantNo", merchantNo);
            param.put("channelId", channelId);
            param.put("encryptData", encryptedData);
            param.put("signData", signRSA);
            String refundUrl = wxConfig.getString("RefundUrl");
            log.debug("远眺科技退款地址: {},退款参数: {}", refundUrl, refundParam);
            String response = HttpUtil.post(refundUrl,param.toString());
            log.debug("远眺科技退款返回加密数据: {}", response);
            JSONObject responseData = new JSONObject(response);
            String decodeData = RsaEncryptUtil.pubDecrypt(responseData.getString("encryptData"), publicKeyStr);
            log.debug("接口数据解密后：{}", decodeData);
            JSONObject data = new JSONObject(decodeData);
            try {
                log.debug("远眺科技退款返回解密数据: {}", data);
                if (data.getInt("code") != 200) {
                    result.put("result_msg", "退款失败");
                    result.put("trade_state", "FAIL");
                } else  {
                    result.put("result_msg", "退款中");
                    result.put("trade_state", "SUCCESS");
                    this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='退款中' where id = '" + id + "'");
                }
            } catch (Exception var9) {
                var9.printStackTrace();
            }
        } catch (Exception e) {
            log.debug("潜能中行退款异常错误", e);
        }
        return result.toString();
    }

    @Override
    public String refundOrderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            String orderNo = jsonObject.getString("out_trade_no");
            String orderDate = jsonObject.getString("f_send_time");
            Integer id = jsonObject.getInt("id");
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String channelId = wxConfig.getString("channelId");
            String merchantNo = wxConfig.getString("merchantNo");
            JSONObject body = new JSONObject();
            body.put("channelId", channelId);
            body.put("machinePayNumber", orderNo);
            body.put("machineTime", orderDate);
            String publicKeyStr = wxConfig.getString("publicKey");
            String pfxPath = wxConfig.getString("pfxPath");
            String pfxPassWord = wxConfig.getString("pfxPassWord");
            // 原文信息转json字符串-》使用RSA公钥进行加密-》进行base64编码-》获得密文encryptData。
            String encryptedData = RsaEncryptUtil.pubEncrypt(body.toString(), publicKeyStr);
            // 获取签名
            String signRSA = SignUtil.sign(pfxPath, pfxPassWord, encryptedData) ;
            JSONObject param = new JSONObject();
            param.put("merchantNo", merchantNo);
            param.put("channelId", channelId);
            param.put("encryptData", encryptedData);
            param.put("signData", signRSA);
            String QueryUrl = wxConfig.getString("QueryUrl");
            log.debug("开放平台退款状态查询地址:{}",QueryUrl);
            log.debug("开放平台退款状态查询参数:{}",param);
            String response = HttpUtil.post(QueryUrl,param.toString());
            log.debug("开放平台退款状态查询返回报文:{}",response);
            JSONObject responseData = new JSONObject(response);
            String decodeData = RsaEncryptUtil.pubDecrypt(responseData.getString("encryptData"), publicKeyStr);
            log.debug("接口数据解密后：{}", decodeData);
            JSONObject data = new JSONObject(decodeData);
            if (data.getInt("code") == 200) {
                JSONObject dataContent = new JSONObject(data.getString("data"));
                if (dataContent.getInt("orderStatus") != 0) {
                    this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已退款' where id = '" + id + "'");
                    this.sqlServer.runSQL("update t_bank_payment set f_state ='无效' where f_trade_number = '"+ orderNo +"'");
                    result.put("result_msg", "退款成功");
                    result.put("trade_state", "FAIL");
                } else {
                    result.put("return_msg", "退款处理中");
                    result.put("trade_state", "FAIL");
                    log.debug("订单状态等于已支付：" + dataContent.getString("orderStatus"));
                }
            } else {
                result.put("return_msg", "退款处理中");
                result.put("trade_state", "FAIL");
                log.debug("查询失败：" + data.getInt("code"));
            }

        } catch (Exception e) {
            log.debug("查询订单出错:" + e);
            result.put("status", "fail");
            result.put("trade_state", "fail");
        }
        return result.toString();
    }
}
