package com.aote.entity;

import java.util.List;

public class WebPayBodyEntity {
    //消息ID
    String msgId;
    //报文请求时间，格式yyyy-MM-ddHH:mm:ss
    String requestTimestamp;
    //报文系统预留字段
    String srcReserve;
    //商户订单号
    String merOrderId;
    //商户号
    String mid;
    //终端号
    String tid;
    //业务类型
    String instMid;
    //要退货的金额
    String refundAmount;
    //要退款的订单号
    String refundOrderId;
    //平台商户退款分账金额
    String platformAmount;
    //子订单信息
    List<SubOrderItem> subOrders;
    //退货说明
    String refundDesc;


    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getRequestTimestamp() {
        return requestTimestamp;
    }

    public void setRequestTimestamp(String requestTimestamp) {
        this.requestTimestamp = requestTimestamp;
    }

    public String getSrcReserve() {
        return srcReserve;
    }

    public void setSrcReserve(String srcReserve) {
        this.srcReserve = srcReserve;
    }

    public String getMerOrderId() {
        return merOrderId;
    }

    public void setMerOrderId(String merOrderId) {
        this.merOrderId = merOrderId;
    }

    public String getMid() {
        return mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public String getTid() {
        return tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getInstMid() {
        return instMid;
    }

    public void setInstMid(String instMid) {
        this.instMid = instMid;
    }

    public String getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(String refundAmount) {
        this.refundAmount = refundAmount;
    }

    public String getRefundOrderId() {
        return refundOrderId;
    }

    public void setRefundOrderId(String refundOrderId) {
        this.refundOrderId = refundOrderId;
    }

    public String getPlatformAmount() {
        return platformAmount;
    }

    public void setPlatformAmount(String platformAmount) {
        this.platformAmount = platformAmount;
    }

    public List<SubOrderItem> getSubOrders() {
        return subOrders;
    }

    public void setSubOrders(List<SubOrderItem> subOrders) {
        this.subOrders = subOrders;
    }

    public String getRefundDesc() {
        return refundDesc;
    }

    public void setRefundDesc(String refundDesc) {
        this.refundDesc = refundDesc;
    }

    String toJson(){
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.msgId != null) sb.append("\"msgId\":\"" + this.msgId + "\",");
        if (this.requestTimestamp != null) sb.append("\"requestTimestamp\":\"" + this.requestTimestamp + "\",");
        if (this.merOrderId != null) sb.append("\"merOrderId\":\"" + this.merOrderId + "\",");
        if (this.srcReserve != null) sb.append("\"srcReserve\":\"" + this.srcReserve + "\",");
        if (this.mid != null) sb.append("\"mid\":\"" + this.mid + "\",");
        if (this.tid != null) sb.append("\"tid\":\"" + this.tid + "\",");
        if (this.instMid != null) sb.append("\"instMid\":\"" + this.instMid + "\",");
        if (this.refundAmount != null) sb.append("\"refundAmount\":\"" + this.refundAmount + "\",");
        if (this.refundOrderId != null) sb.append("\"refundOrderId\":\"" + this.refundOrderId + "\",");
        if (this.platformAmount != null) sb.append("\"platformAmount\":\"" + this.platformAmount + "\",");
        if (this.subOrders != null && this.subOrders.size()>0) {
            sb.append("\"subOrders\":[");
            for(int i=0;i<subOrders.size();i++){
                sb.append(subOrders.get(i));
                sb.append(",");
            }
            if (sb.charAt(sb.length() - 1) == ',')
                sb.deleteCharAt(sb.length() - 1);
            sb.append("],");
        }
        if (this.refundDesc != null) sb.append("\"refundDesc\":\"" + this.refundDesc + "\",");
        if (sb.charAt(sb.length() - 1) == ',')
            sb.deleteCharAt(sb.length() - 1);
        sb.append("}");
        return sb.toString();
    }

    public String toString(){
        return this.toJson();
    }
    static class SubOrderItem{
        //子商户号
        String mid;
        //子商户分账金额
        int totalAmount;
        String toJson() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            if (this.mid != null) {
                sb.append("\"mid\":\"" + this.mid + "\",");
            }
            if (this.totalAmount != 0) {
                sb.append("\"totalAmount\":\"" + this.totalAmount + "\",");
            }
            if (sb.charAt(sb.length() - 1) == ',')
                sb.deleteCharAt(sb.length() - 1);
            sb.append("}");
            return sb.toString();
        }

        public String toString(){
            return this.toJson();
        }
    }
}
