select * from (
	select
		c.*,
		// 跟踪
		proj_trace=(
			select count(*)
			from t_projectinfomation p
			where p.f_custom=c.id and p.f_projectstatus in
			('1.跟踪', '2.咨询', '3.立项', '4.招标', '5.签单')
		),
		// 实施
		proj_do=(
			select count(*)
			from t_projectinfomation p
			where p.f_custom=c.id and p.f_projectstatus in
			('7.实施', '8.欠首款', '9.欠中款', '10.欠尾款')
		),
		// 完成
		proj_over=(
			select count(*)
			from t_projectinfomation p
			where p.f_custom=c.id and p.f_projectstatus in
			('11.售后')
		),
		// 丢单
		proj_lost=(
			select count(*)
			from t_projectinfomation p
			where p.f_custom=c.id and p.f_projectstatus in
			('6.丢单', '取消')
		),
		// 作废
		proj_nouse=(
			select count(*)
			from t_projectinfomation p
			where p.f_custom=c.id and p.f_projectstatus in
			('作废')
		),
		// 联系时间
		link_time=(
			select max(f_txdate)
			from t_kflink k
			where k.parentid=c.id
		),
		// 合同额
		m.f_contractmoney,
		// 欠款
		m.f_should,
		// 追款
		m.urgemoney
	from
		t_effectiveinfo c left join (
			select custom_id,
			 SUM(CAST(F_CONTRACTMANOY as numeric(10,2))/10000) f_contractmoney,
			 sum(f_should/10000) f_should,
			 SUM(CAST((case  when urgemoney = '' then null else urgemoney end) as numeric(10,2))) urgemoney
			from fun_催款信息()
			group by custom_id

		) m on m.custom_id = c.id
) cust
where
	{condition}
order by
	{order}
