/**查询用户气表信息**/
SELECT * FROM (
    SELECT
           uf.f_userfiles_id,
           uf.f_user_type,
           f_user_id,
           uf.f_userinfo_id,
           f_meternumber,
           f_meter_classify,
           f_balance_amount,
           f_balance_gas,
           f_meter_base,
           f_card_id,
           f_times,
           f_whether_hairpin,
           f_collection_type, -- 缴费方式
           f_total_gas, -- 表累购气量
           uf.f_card_password, -- 卡密码
           gb.f_alias,  --别名
           gb.f_police_gas, -- 报警气量
           gb.f_topup_ceil, --充值上限
           gb.f_overdr_lines, -- 透支额度
           gb.f_meter_brand, -- 气表品牌
           up.f_state,
           f_table_state,
		   isnull(lg.f_limit_times,0) f_limit_times,
		   isnull(lg.f_limit_type,'') f_limit_type,
		   case when  isnull(lg.f_limit_type,'') = '金额' then isnull(lg.f_limit_amount,0) else isnull(lg.f_limit_value,0) end f_limit_value
    FROM
         t_userfiles uf LEFT JOIN t_gasbrand gb on uf.f_gasbrand_id = gb.id
               LEFT JOIN  (select * from t_userproperties where id in ( select MAX(id) from t_userproperties group by f_userinfo_id )  ) up on uf.f_userinfo_id = up.f_userinfo_id
			   left join t_limit_gas lg on uf.f_userinfo_id = lg.f_userinfo_id
    ) t
WHERE
    {condition} AND f_table_state = '正常'
ORDER BY
    f_user_id
