package com.aote.weixin.timer.msgpush;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.aote.rs.WeiXinService;
import com.aote.sql.SqlServer;
import com.aote.util.WxSign;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Component
@EnableScheduling
@Lazy(false)
@Slf4j
@Transactional
public class MessagePush {

    @Autowired
    private SqlServer sqlServer;

    @Autowired
    private WeiXinService weiXinService;


    /**
     * 余额提醒定时器
     * 格式: cron = [秒] [分] [小时] [日] [月] [周] [年]
     */
       @Scheduled(cron = "0 0 20 * * ?")
    public void balanceRemind () {
        log.debug("余额不足推送");
        try {
            JSONArray templateInfo = sqlServer.query("select * from t_template where f_title = '余额不足提醒'");
            if (templateInfo.length() == 0) {
                log.debug("模板信息数量不正确: {}, 推送结束!!!", templateInfo.length());
                return;
            }
            for(Object item : templateInfo) {
                JSONObject template = (JSONObject) item;
                JSONObject sqlParams = new JSONObject();
                sqlParams.put("condition", "f_orgid = '" + template.get("f_orgid") + "'");
                String templateId = String.valueOf(template.get("f_template_id"));
                String filiale = String.valueOf(template.get("f_orgname"));
                JSONObject pushParams = new JSONObject();
                pushParams.put("sql", "getTemplatePush");
                pushParams.put("params", new JSONObject());
                pushParams.put("filiale", filiale);
                push(templateId, "balanceRemind", sqlParams, "余额提醒", pushParams);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 欠费提醒定时器
     * 运城
     */
    @Scheduled(cron = "0 0 18 10,16,19 * ?")
    public void ycOweUserMsgPush () {
        log.debug("运城欠费推送");
        try {
            JSONArray templateInfo = sqlServer.query("select * from t_template where f_title = '账单催缴提醒' and f_orgname = 'yuncheng'");
            if (templateInfo.length() == 0) {
                log.debug("模板信息数量不正确: {}, 推送结束!!!", templateInfo.length());
                return;
            }
            for(Object item : templateInfo) {
                JSONObject template = (JSONObject) item;
                JSONObject sqlParams = new JSONObject();
                sqlParams.put("condition", "f_orgid = '" + template.get("f_orgid") + "'");
                String templateId = String.valueOf(template.get("f_template_id"));
                String filiale = String.valueOf(template.get("f_orgname"));
                JSONObject pushParams = new JSONObject();
                pushParams.put("sql", "getTemplatePush");
                pushParams.put("params", new JSONObject());
                pushParams.put("filiale", filiale);
                push(templateId, "getOweUser", sqlParams, "账单催缴提醒", pushParams);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 欠费提醒定时器
     * 永济
     */
    @Scheduled(cron = "0 0 18 5,10,17,25 * ?")
    public void yjOweUserMsgPush () {
        log.debug("永济欠费推送");
        try {
            JSONArray templateInfo = sqlServer.query("select * from t_template where f_title = '账单催缴提醒' and f_orgname = 'yongji'");
            if (templateInfo.length() == 0) {
                log.debug("模板信息数量不正确: {}, 推送结束!!!", templateInfo.length());
                return;
            }
            for(Object item : templateInfo) {
                JSONObject template = (JSONObject) item;
                JSONObject sqlParams = new JSONObject();
                sqlParams.put("condition", "f_orgid = '" + template.get("f_orgid") + "'");
                String templateId = String.valueOf(template.get("f_template_id"));
                String filiale = String.valueOf(template.get("f_orgname"));
                JSONObject pushParams = new JSONObject();
                pushParams.put("sql", "getTemplatePush");
                pushParams.put("params", new JSONObject());
                pushParams.put("filiale", filiale);
                push(templateId, "getOweUser", sqlParams, "账单催缴提醒", pushParams);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 欠费提醒定时器
     * 永济
     */
    @Scheduled(cron = "0 0 18 28-31 * ?")
    public void oweUserMsgPush () {
        log.debug("月底欠费推送");
        try {
            final Calendar c = Calendar.getInstance();
            //如果是最后一天 则执行定时任务
            if (c.get(Calendar.DATE) == c.getActualMaximum(Calendar.DATE)) {
                log.debug("月末推送今天是月末, 推送执行!!!");
                JSONArray templateInfo = sqlServer.query("select * from t_template where f_title = '账单催缴提醒'");
                if (templateInfo.length() == 0) {
                    log.debug("模板信息数量不正确: {}, 推送结束!!!", templateInfo.length());
                    return;
                }
                for(Object item : templateInfo) {
                    JSONObject template = (JSONObject) item;
                    JSONObject sqlParams = new JSONObject();
                    sqlParams.put("condition", "f_orgid = '" + template.get("f_orgid") + "'");
                    String templateId = String.valueOf(template.get("f_template_id"));
                    String filiale = String.valueOf(template.get("f_orgname"));
                    JSONObject pushParams = new JSONObject();
                    pushParams.put("sql", "getTemplatePush");
                    pushParams.put("params", new JSONObject());
                    pushParams.put("filiale", filiale);
                    push(templateId, "getOweUser", sqlParams, "账单催缴提醒", pushParams);
                }
            } else {
                log.debug("月末推送今天不是月末, 推送结束!!!");
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 热力欠费提醒定时器
     */
    //@Scheduled(cron = "0 0 7 30 9 ?")
    public void heatOweUserMsgPush () {
        log.debug("欠费推送");
        try {
            JSONArray templateInfo = sqlServer.query("select * from t_template where f_title = '缴费提醒'");
            if (templateInfo.length() == 0) {
                log.debug("模板信息数量不正确: {}, 推送结束!!!", templateInfo.length());
                return;
            }
            for(Object item : templateInfo) {
                JSONObject template = (JSONObject) item;
                JSONObject sqlParams = new JSONObject();
                sqlParams.put("condition", "f_orgid = '" + template.get("f_orgid") + "'");
                String templateId = String.valueOf(template.get("f_template_id"));
                String filiale = String.valueOf(template.get("f_orgname"));
                JSONObject pushParams = new JSONObject();
                pushParams.put("sql", "getTemplatePush");
                pushParams.put("params", new JSONObject());
                pushParams.put("filiale", filiale);
                push(templateId, "getOweUser", sqlParams, "缴费提醒", pushParams);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * 保险到期提醒定时器
     */
    // @Scheduled(cron = "0 0 19 ? * 1")
    public void gasInsureExpire () {
        log.debug("保险到期推送");
        JSONObject pushParams = new JSONObject();
        pushParams.put("sql", "getTemplatePush");
        pushParams.put("params", new JSONObject());
        try {
            JSONArray templateInfo = sqlServer.query("select * from t_template where f_title = '燃气险到期提醒'");
            if (templateInfo.length() == 0) {
                log.debug("模板信息数量不正确: {}, 推送结束!!!", templateInfo.length());
                return;
            }
            for(Object item : templateInfo) {
                JSONObject template = (JSONObject) item;
                JSONObject sqlParams = new JSONObject();
                sqlParams.put("condition", "f_filialeids = '" + template.get("f_orgid") + "'");
                String templateId = String.valueOf(template.get("f_template_id"));
                String filiale = String.valueOf(template.get("f_orgname"));
                pushParams.put("filiale", Config.wechatConfig.getString(filiale));
                push(templateId, "gasInsureExpire", sqlParams, "保险到期提醒", pushParams);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 账单提醒定时器
     */
//    @Scheduled(cron = "0 0 19 5 * ?")
    public void billRemind () {
        JSONObject sqlParams = new JSONObject();
        // 当前月份的上个月
        DateTime dateTime = DateUtil.lastMonth();
        // 上个月第一天
        DateTime startDate = DateUtil.beginOfMonth(dateTime);
        // 上个月最后一天
        DateTime endDate = DateUtil.endOfMonth(dateTime);
        log.debug("账单提醒数据时间: {} ~ {}", startDate, endDate);
        sqlParams.put("startDate", startDate.toString());
        sqlParams.put("endDate", endDate.toString());
        JSONObject pushParams = new JSONObject();
        pushParams.put("sql", "getTemplatePush");
        pushParams.put("params", new JSONObject());
        pushParams.put("filiale", "xinkang");
        pushCreate("templateId2", "billRemind", sqlParams, "账单提醒", pushParams);
    }

    /**
     * 模板内容取解析(取key)
     *
     * @param content 模板内容
     * @return 解析的keys
     */
    public static ArrayList<String> getTemplateKeys(String content) {
        ArrayList<String> keys = new ArrayList<>();
        String reg = "(\\{\\{)(.*)(.DATA}})";
        //把正则封装成对象
        Pattern p = Pattern.compile(reg);
        //让正则与要作用的字符串进行匹配
        Matcher m = p.matcher(content);
        //按规则作用于字符串，并进行查找
        while (m.find()) {
            keys.add(m.group(2));
        }
        // 最后添加上url
        keys.add("url");
        return keys;
    }

    /**
     *  后台推送统一方法
     * @param templateId 模板id
     * @param sqlName 数据源sql名称
     * @param sqlParams 数据源sql参数
     * @param sendType 推送类型
     * @param pushParams 发起推送服务需要的参数
     */
    public void push(String templateId,String sqlName, JSONObject sqlParams, String sendType, JSONObject pushParams) {
        try {
            log.debug("后台推送任务开始: {}", sqlName);
            // 通过模板id查询对应的表达式
            JSONArray templateExpression = sqlServer.query("select * from t_template_expression where f_template_id = '" + templateId + "'");
            if (templateExpression.length() <= 0) {
                log.debug("没有查询到表达式信息, 推送结束!!!");
                return;
            }
            String url = "";
            for (int i = 0; i < templateExpression.length(); i++) {
                JSONObject row = templateExpression.getJSONObject(i);
                String value = row.optString("f_value");
                String key = row.getString("f_key");
                boolean nullValue = !"url".equals(key) && (value == null || "".equals(value));
                if (nullValue) {
                    log.debug("表达式{}的内容为空, 推送结束!!!", key);
                    return;
                }
                if ("url".equals(key)) {
                    url = value;
                }
            }
            String msgPushItem = weiXinService.getMsgPushItem(templateExpression.toString());
            log.debug("表达式组织完成: {}", msgPushItem);
            JSONObject params = new JSONObject();
            JSONObject tempInfo = new JSONObject();
            tempInfo.put("f_send_type", sendType);
            tempInfo.put("f_template_id", templateId);
            tempInfo.put("f_url", url);
            String pushNumber = WxSign.getNonceStr();
            tempInfo.put("f_push_number", pushNumber);
            params.put("sql", sqlName);
            params.put("dataStr", msgPushItem);
            params.put("params", sqlParams);
            params.put("tempInfo", tempInfo);
            log.debug("本次生成推送数据随机编号: {}", pushNumber);
            // 插入推送数据
            int num = Integer.parseInt(weiXinService.msgpushDate(params.toString()));
            log.debug("本次生成推送数据数量: {}", num);
            JSONObject params1 = pushParams.getJSONObject("params");
            // 加入推送表查询条件
            params1.put("condition", "f_push_number = '" + pushNumber + "'");
            // 调起推送
            weiXinService.msgPush(pushParams.toString());
        } catch (Exception e) {
            log.debug("{}=>定时器报错: {}", sendType, e);
        }
    }


    /**
     *  后台推送统一方法
     * @param templateId 模板id配置名称
     * @param sqlName 数据源sql名称
     * @param sqlParams 数据源sql参数
     * @param sendType 推送类型
     * @param pushParams 发起推送服务需要的参数
     */
    public void pushCreate(String templateId,String sqlName, JSONObject sqlParams, String sendType, JSONObject pushParams) {
        try {
            log.debug("后台推送任务开始: {}", sqlName);
            String templateId1 = Config.wechatConfig.getString(templateId);
            // 通过模板id查找对应的模板信息
            JSONArray templateInfo = sqlServer.query("select * from t_template where f_template_id = '" + templateId1 + "'");
            if (templateInfo.length() != 1) {
                log.debug("模板信息数量不正确: {}, 推送结束!!!", templateInfo.length());
                return;
            }
            // 通过模板id查询对应的表达式
            JSONArray templateExpression = sqlServer.query("select * from t_template_expression where f_template_id = '" + templateId1 + "'");
            if (templateExpression.length() <= 0) {
                log.debug("没有查询到表达式信息, 推送结束!!!");
                return;
            }
            ArrayList<String> keys = getTemplateKeys(templateInfo.getJSONObject(0).getString("f_data_content"));
            if (templateExpression.length() != keys.size()) {
                log.debug("表达式不完整: {}, {}", templateExpression.length(), keys.size());
                return;
            }
            String url = "";
            for (int i = 0; i < templateExpression.length(); i++) {
                JSONObject row = templateExpression.getJSONObject(i);
                String value = row.optString("f_value");
                String key = row.getString("f_key");
                boolean nullValue = !"url".equals(key) && (value == null || "".equals(value));
                if (nullValue) {
                    log.debug("表达式{}的内容为空, 推送结束!!!", key);
                    return;
                }
                if ("url".equals(key)) {
                    url = value;
                }
            }
            String msgPushItem = weiXinService.getMsgPushItem(templateExpression.toString());
            log.debug("表达式组织完成: {}", msgPushItem);
            JSONObject params = new JSONObject();
            JSONObject tempInfo = new JSONObject();
            tempInfo.put("f_send_type", sendType);
            tempInfo.put("f_template_id", templateId1);
            tempInfo.put("f_url", url);
            String pushNumber = WxSign.getNonceStr();
            tempInfo.put("f_push_number", pushNumber);
            params.put("sql", sqlName);
            params.put("dataStr", msgPushItem);
            params.put("params", sqlParams);
            params.put("tempInfo", tempInfo);
            log.debug("本次生成推送数据随机编号: {}", pushNumber);
            // 插入推送数据
            int num = Integer.parseInt(weiXinService.msgpushDate(params.toString()));
            log.debug("本次生成推送数据数量: {}", num);
            JSONObject params1 = pushParams.getJSONObject("params");
            // 加入推送表查询条件
            params1.put("condition", "f_push_number = '" + pushNumber + "'");
            // 调起推送
            weiXinService.msgPush(pushParams.toString());
        } catch (Exception e) {
            log.debug("{}=>定时器报错: {}", sendType, e);
        }
    }


}
