package com.aote.rs.scanpay;

import com.aote.logic.LogicServer;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.ServletException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

@Component
public class CreateQRcode {
	static Logger log = Logger.getLogger(CreateQRcode.class);

	@Autowired
	private LogicServer logicServer;

	public CreateQRcode() {
	}

	/**
	 * 微信扫码支付下单处理
	 * @param appId appId
	 * @param key API 秘钥
	 * @param codeNotifyUrl 微信扫码支付回调接口路径
	 * @param ip 请求ip
	 * @param value 请求数据
	 * @return
	 * @throws ServletException
	 * @throws IOException
	 */
	public JSONObject qrcode (String appId,String key, String mchId,String codeNotifyUrl,String ip, String value){
		log.debug("微信扫码支付下单客户端请求数据包：" + value);
		JSONObject jo = new JSONObject(value);
		int money = jo.getInt("money");
		JSONObject jsonobject = new JSONObject();
		jsonobject.put("filiale", jo.getString("filiale"));
		String str = jo.getString("str");
		JSONObject result = new WxcodePrepay().codeprePay(appId, key,mchId ,String.valueOf(money),jsonobject,str, codeNotifyUrl, ip);
		// 保存订单
		String out_trade_no = result.getString("out_trade_no");
		JSONObject orderData = new JSONObject();
		orderData.put("f_out_trade_no", out_trade_no);
		JSONObject attachJson = jo.getJSONObject("attach");
		String operator = attachJson.getString("f_terminal_num");
		orderData.put("f_attach", attachJson);
		orderData.put("f_operator", operator);
		orderData.put("f_trade_type", "NATIVE");
		orderData.put("state", "已下单");
		orderData.put("f_userfiles_id", attachJson.getInt("f_userfiles_id"));
		// 设置超时时间 (当前时间加100秒)
		Date afterDate = new Date(new Date().getTime() + 100000);
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String timeOut = formatter.format(afterDate);
		log.debug("超时时间"+timeOut);
		orderData.put("f_time_out", timeOut);
		try {
			if (result.has("url")){
				logicServer.run("savewxreturnxml", orderData);
			}
		} catch (Exception e) {
			result.put("code", 500);
			result.put("msg", "下单失败，保存订单信息失败！");
			if (result.has("url")) {
				result.remove("url");
			}
		}
		log.debug("微信扫码支付返回数据：" + result);
		return result;
	}


	/**
	 * 微信扫码支付下单处理
	 * @param appId appId
	 * @param key API 秘钥
	 * @param wechatNotify 微信扫码支付回调接口路径
	 * @param ip 请求ip
	 * @param value 请求数据
	 * @return
	 * @throws ServletException
	 * @throws IOException
	 */
	public JSONObject bzqrcode (String appId,String key, String mchId,String wechatNotify,String ip, String value){
		log.debug("微信扫码支付下单客户端请求数据包：" + value);
		JSONObject jo = new JSONObject(value);
		int money = jo.getInt("money");
		JSONObject jsonobject = new JSONObject();
		jsonobject.put("filiale", jo.getString("filiale"));
		String str = jo.getString("str");
		JSONObject result = new WxcodePrepay().codeprePay(appId, key, mchId, String.valueOf(money), jsonobject, str, wechatNotify, ip);
		log.debug("微信扫码支付返回数据：" + result);
		return result;
	}

}
