SELECT
    f_open_id,
    convert(varchar,f_balance) f_balance,
    f_userinfo_id,
    f_userfiles_id,
    f_user_name,
    f_meternumber,
    f_time,
    f_user_type,
    convert(varchar,f_value) f_value,
    f_userinfo_code,
    f_orgid,
    convert(varchar,f_meter_base) f_meter_base,
    SUBSTRING(f_address,1,20) f_address
FROM (
     SELECT
         b.f_open_id,
         b.f_band_state,
         f_user_state,
         f_table_state,
         convert(decimal(18,2), case when gb.f_collection_type = '按气量'  then isnull(uf.f_balance_gas,0)*f_price else isnull(f_balance_amount,0) end) f_balance,
         ui.f_userinfo_id,
         uf.f_user_id f_userfiles_id,
         ui.f_user_name,
         uf.f_meternumber,
         CONVERT(varchar,GETDATE(),120) f_time,
         ui.f_userinfo_code,
         ui.f_filiale f_orgid,
         ui.f_filiale,
         uf.f_user_type,
         uf.f_meter_base,
         ui.f_address,
         case when ui.f_filiale='泗阳荣浩天然气发展有限公司'
                  then case when uf.f_user_type='民用'
                                then (select value from t_singlevalue where name='泗阳民用余额提醒')
                            else (select value from t_singlevalue where name='泗阳非民用余额提醒') end
              when ui.f_filiale='天长市天然气有限公司'
                  then case when uf.f_user_type='民用'
                                then (select value from t_singlevalue where name='天长民用余额提醒')
                            else (select value from t_singlevalue where name='天长非民用余额提醒') end
              when ui.f_filiale='盱眙荣浩天然气发展有限公司'
                  then case when uf.f_user_type='民用'
                                then (select value from t_singlevalue where name='盱眙民用余额提醒')
                            else (select value from t_singlevalue where name='盱眙非民用余额提醒') end
              else 0 end f_value
     FROM
         t_banduser b with(nolock)
     LEFT JOIN t_userinfo ui with(nolock) on ui.f_userinfo_id = b.f_userinfo_id
         LEFT JOIN t_userfiles uf with(nolock) ON ui.f_userinfo_id = uf.f_userinfo_id
         LEFT JOIN t_gasbrand gb on uf.f_gasbrand_id = gb.id
         left join (
         select f_price_id,f_price from t_stairprice s left join t_detailprice d on s.id=d.f_stairprice_id
         where f_state='有效' and d.f_price_name='1'
         ) s on s.f_price_id=uf.f_price_id
     where uf.f_meter_classify = '物联网表' and f_band_state = '有效' and f_user_state = '正常' and f_table_state = '正常' and isnull(uf.f_balance_pushed,'') != '1' and gb.id != '79'
 ) c where   {condition} and f_balance < f_value
