package com.aote.rs;


import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ContextLoader;

import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;

/**
 * @Author: JoeCdy
 * @Description:
 * @Date: Created in 0:05 2020/8/29
 */
@Slf4j
@Component
@Path("pay")
@Singleton
@Transactional
public class PayServer {
    /**
     *  统一银行下单入口
     *
     * @param request
     * @param value   下单参数
     * @return 下单结果参数
     */
    @POST
    @Path("jsApiPay")
    public String jsApiPay(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("银行jsApi收到下单请求: {}", value);
            JSONObject json = new JSONObject(value);
            // 把request加入到下单参数中
            json.put("request", request);
            // 根据下单类型获取相应的对象
            String flag = json.getString("flag");
            // 首字母转小写, 因为bean的默认命名规则是首字符小写
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            log.debug("{} 处理下单", flag);
            // 获取到相应的银行处理实现类
            PaySuper paySuper = (PaySuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            // 调起下单程序
            result = paySuper.prePay(json);
        } catch (Exception e) {
            log.debug("银行jsApi下单异常", e);
        }
        return result;
    }


    /**
     *  统一银行下单入口
     *
     * @param request
     * @param value   下单参数
     * @return 下单结果参数
     */
    @POST
    @Path("jsApiRefund")
    public String jsApiRefund(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("银行jsApi收到退款请求: {}", value);
            JSONObject json = new JSONObject(value);
            // 把request加入到退款参数中
            json.put("request", request);
            // 根据下单类型获取相应的对象
            String flag = json.getString("flag");
            // 首字母转小写, 因为bean的默认命名规则是首字符小写
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            log.debug("{} 处理下单", flag);
            // 获取到相应的银行处理实现类
            RefundSuper refundSuper = (RefundSuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            // 调起下单程序
            result = refundSuper.refund( json);
        } catch (Exception e) {
            log.debug("银行jsApi退款异常", e);
        }
        return result;
    }



    /**
     * 统一扫码盒查询入口
     *
     * @param request
     * @param value   查询参数
     * @return 查询结果参数
     */
    @POST
    @Path("microPayOrderStatus")
    public String microPayOrderStatus(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("银行microPay收到查询请求: {}", value);
            JSONObject json = new JSONObject(value);
            // 把request加入到下单参数中
            json.put("request", request);
            // 根据下单类型获取相应的对象
            String flag = json.getString("flag");
            // 首字母转小写, 因为bean的默认命名规则是首字符小写
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            log.debug("{} 处理查询", flag);
            // 获取到相应的银行处理实现类
            PaySuper paySuper = (PaySuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            // 调起查询程序
            result = paySuper.orderStatus(value);
        } catch (Exception e) {
            log.debug("银行microPay查询异常", e);
        }
        return result;
    }

    @POST
    @Path("getRecordFile")
    public String getRecordFile(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("银行jsApi收到下单请求: {}", value);
            JSONObject json = new JSONObject(value);
            // 把request加入到下单参数中
            json.put("request", request);
            // 根据下单类型获取相应的对象
            String flag = json.getString("flag");
            // 首字母转小写, 因为bean的默认命名规则是首字符小写
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            // 获取到相应的银行处理实现类
            RefundSuper refundSuper = (RefundSuper) ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            // 调起下单程序
            result = refundSuper.getRecordFile(json).toString();
        } catch (Exception e) {
            log.debug("银行下载对账文件异常", e);
        }
        return result;
    }

    @POST
    @Path("notifySuccess")
    public String notifySuccess(@Context HttpServletRequest request, String value){
        return "{\"code\":\"000000\",\"msg\":\"成功\"}";
    }
}
