SELECT * FROM (
  SELECT
    CONVERT(varchar,GETDATE(),120) dbDate,
    b.f_open_id,
    -- 物联网取f_balance_amount,机表取f_balance,保留两位然后转字符串
    convert(decimal(18,2), uf.f_balance_amount) f_balance,
    ui.f_userinfo_id,
    uf.f_userfiles_id,
    ui.f_user_name,
    ui.f_userinfo_code,
    CONVERT(varchar,GETDATE(),120) f_time,
    ui.f_orgid,
    isnull(a.f_address, '') f_address
  FROM
    t_banduser b
    LEFT JOIN t_userinfo ui on ui.f_userinfo_id = b.f_userinfo_id
    LEFT JOIN t_userfiles uf ON ui.f_userinfo_id = uf.f_userinfo_id
    left join t_user_address a on ui.f_userinfo_id = a.f_userinfo_id
  where uf.f_meter_classify = '物联网表'
) c where {condition}
