package com.aote.rs;

import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.pay.boc.qianneng.JsApiQianNengBoc;
import com.aote.sql.SqlServer;
import com.aote.weixin.timer.OrderProcess;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.ContextLoader;

import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;

@Component
@Path("pay")
@Singleton
@Transactional
public class PayServer {
    private static final Logger log = LoggerFactory.getLogger(PayServer.class);

    @Autowired
    private JsApiQianNengBoc jsApiQianNengBoc;
    @Autowired
    private SqlServer sqlServer;

    public PayServer() {
    }

    @POST
    @Path("jsApiPay")
    public String jsApiPay(@Context HttpServletRequest request, String value) {
        String result = "";

        try {
            log.debug("银行jsApi收到下单请求: {}", value);
            JSONObject json = new JSONObject(value);
            json.put("request", request);
            String flag = json.getString("flag");
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            log.debug("{} 处理下单", flag);
            PaySuper paySuper = (PaySuper)ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            result = paySuper.prePay(json);
        } catch (Exception var7) {
            log.debug("银行jsApi下单异常", var7);
        }
        return result;
    }

    @POST
    @Path("microPay")
    public String microPay(@Context HttpServletRequest request, String value) {
        String result = "";
        try {
            log.debug("银行microPay收到下单请求: {}", value);
            JSONObject json = new JSONObject(value);
            json.put("request", request);
            result = this.jsApiQianNengBoc.microPay(json);
        } catch (Exception var5) {
            log.debug("银行microPay下单异常", var5);
        }
        return result;
    }

    @POST
    @Path("notifySuccess")
    public String notifySuccess(@Context HttpServletRequest request, String value) {
        try {
            log.debug("notifySuccess回调请求: {}", value);
            JSONObject json = new JSONObject(value);
            json.put("request", request);
            OrderProcess orderProcess = new OrderProcess();
            JSONArray query = this.sqlServer.query("select * from t_weixinreturnxml where f_out_trade_no = '" + json.getString("outTradeNo") + "'");
            if (query.length()>0){
                JSONObject jsonObject = query.getJSONObject(0);
                if ("已支付".equals(jsonObject.getString("f_order_state"))) {
                    return "success";
                } else {
                    JSONObject param = new JSONObject();
                    param.put("f_order_type",jsonObject.getString("f_order_type"));
                    param.put("f_attach",jsonObject.getString("f_attach"));
                    param.put("f_filiale",jsonObject.getString("f_filiale"));
                    param.put("id",jsonObject.get("id"));
                    param.put("f_judge_count",jsonObject.optInt("f_judge_count",0));
                    param.put("transaction_id",json.getString("transactionId"));
                    param.put("total_fee",json.opt("totalAmount"));
                    param.put("time_end",json.getString("tradeTime"));
                    param.put("f_mend_record","notify");
                    orderProcess.process(param);
                }
            }
        } catch (Exception var5) {
            log.debug("notifySuccess回调异常", var5);
        }
        return "success";
    }

    @POST
    @Path("codePay")
    public String codePay(@Context HttpServletRequest request, String value) {
        String result = "";

        try {
            log.debug("银行codePay收到下单请求: {}", value);
            JSONObject json = new JSONObject(value);
            json.put("request", request);
            result = this.jsApiQianNengBoc.codePay(json);
        } catch (Exception var5) {
            log.debug("银行codePay下单异常", var5);
        }

        return result;
    }

    @POST
    @Path("jsApiRefund")
    public String jsApiRefund(@Context HttpServletRequest request, String value) {
        String result = "";

        try {
            log.debug("银行jsApi收到退款请求: {}", value);
            JSONObject json = new JSONObject(value);
            json.put("request", request);
            String flag = json.getString("flag");
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            log.debug("{} 处理下单", flag);
            RefundSuper refundSuper = (RefundSuper)ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            result = refundSuper.refund(json);
        } catch (Exception var7) {
            log.debug("银行jsApi退款异常", var7);
        }

        return result;
    }

    @POST
    @Path("microPayOrderStatus")
    public String microPayOrderStatus(@Context HttpServletRequest request, String value) {
        String result = "";

        try {
            log.debug("银行microPay收到查询请求: {}", value);
            JSONObject json = new JSONObject(value);
            json.put("request", request);
            String flag = json.getString("flag");
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            log.debug("{} 处理查询", flag);
            PaySuper paySuper = (PaySuper)ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            result = paySuper.orderStatus(value);
        } catch (Exception var7) {
            log.debug("银行microPay查询异常", var7);
        }

        return result;
    }


    @POST
    @Path("getRecordFile")
    public String getRecordFile(@Context HttpServletRequest request, String value) {
        String result = "";

        try {
            log.debug("银行jsApi收到下单请求: {}", value);
            JSONObject json = new JSONObject(value);
            json.put("request", request);
            String flag = json.getString("flag");
            flag = Character.isLowerCase(flag.charAt(0)) ? flag : Character.toLowerCase(flag.charAt(0)) + flag.substring(1);
            RefundSuper refundSuper = (RefundSuper)ContextLoader.getCurrentWebApplicationContext().getBean(flag);
            result = refundSuper.getRecordFile(json).toString();
        } catch (Exception var7) {
            log.debug("银行下载对账文件异常", var7);
        }

        return result;
    }
}
