SELECT *
FROM (
	SELECT
		u.f_userinfo_id,
        u.f_open_date,
        RTRIM(LTRIM(uf.f_meternumber)) f_meternumber,
		uf.f_table_state,
        RTRIM(LTRIM(u.f_userinfo_code)) f_userinfo_code,
        RTRIM(LTRIM(u.f_olduserinfo_code)) f_olduserinfo_code,
        RTRIM(LTRIM(u.f_user_name)) f_user_name,
		u.f_user_state,
		u.f_user_phone,
		u.f_balance,
		u.f_orgname as f_filiale,
		u.f_filialeid,
		u.f_orgid,
		u.f_depname as f_outlets,
		a.f_address,
        uf.f_gasbrand_id,
        uf.f_meter_classify,
        g.f_meter_brand
	FROM t_userinfo u
	LEFT JOIN t_userfiles uf
	ON u.f_userinfo_id = uf.f_userinfo_id
	LEFT JOIN t_user_address a
	ON u.f_userinfo_id = a.f_userinfo_id
    LEFT JOIN t_gasbrand g ON uf.f_gasbrand_id = g.id
) t
WHERE { condition } and f_table_state = '正常' and f_user_state = '正常'
ORDER BY f_userinfo_id
