select
    f_input_date,
    max(f_tablebase) f_tablebase,
    min(f_last_tablebase) f_last_tablebase,
    sum(f_oughtfee) f_oughtfee,
    sum(f_oughtamount) f_oughtamount,
    max(f_price1) f_price1,
    sum(f_gas1) f_gas1,
    sum(f_money1) f_money1,
    max(f_price2) f_price2,
    sum(f_gas2) f_gas2,
    sum(f_money2) f_money2,
    max(f_price3) f_price3,
    sum(f_gas3) f_gas3,
    sum(f_money3) f_money3
from
    (
        select
               id,
               CONVERT(varchar,f_input_date,23) f_input_date,
               f_tablebase,
               f_last_tablebase,
               f_oughtfee,
               f_oughtamount
        from t_handplan
        where f_meter_state = '已抄表' and f_hand_state = '有效'
          AND f_user_id = '{f_user_id}'
          AND f_input_date > { entity.findDialect() == $SqlServer$: $'{startDate}'$, $to_date('{startDate}','yyyy-mm-dd HH24:mi:ss')$}
    ) h
        left join (
        select
            f_hand_id,
            isnull(sum(case when f_price_name='阶梯1' or f_price_name='固定气价' then f_price else 0 end),0) f_price1,
            isnull(sum(case when f_price_name='阶梯1' or f_price_name='固定气价' then f_gas else 0 end),0) f_gas1,
            isnull(sum(case when f_price_name='阶梯1' or f_price_name='固定气价' then f_money else 0 end),0) f_money1,
            isnull(sum(case when f_price_name='阶梯2' then f_price else 0 end),0) f_price2,
            isnull(sum(case when f_price_name='阶梯2' then f_gas else 0 end),0) f_gas2,
            isnull(sum(case when f_price_name='阶梯2' then f_money else 0 end),0) f_money2,
            isnull(sum(case when f_price_name='阶梯3' then f_price else 0 end),0) f_price3,
            isnull(sum(case when f_price_name='阶梯3' then f_gas else 0 end),0) f_gas3,
            isnull(sum(case when f_price_name='阶梯3' then f_money else 0 end),0) f_money3
        from t_chargeprice
        where f_state='有效' and f_gas > 0
        group by f_hand_id
    ) c on h.id = c.f_hand_id
group by f_input_date order by f_input_date desc
