/** 查询用户欠费信息 **/
SELECT
	h.f_mark,
	h.f_reduce_fee, --优惠金额
	h.f_amount, --总金额
	ISNULL(s.f_debt_money, 0) f_debt_money,  --清缴金额
	ISNULL(s.f_credit_amount, 0) f_credit_amount,  --减免金额
	h.f_oughtfee - ISNULL(s.f_debt_money, 0) - ISNULL(s.f_credit_amount, 0) f_oughtfee, --清缴减免后的应缴金额
	h.f_user_name,
	h.f_user_type,
	h.f_userinfo_id,
	h.f_address,
	h.f_hand_state,
	h.f_filiale,
	h.f_whether_pay,
	h.f_hand_date
FROM
	t_handplan h
LEFT JOIN (
	SELECT
		f_hand_id,
		SUM (f_debt_money) f_debt_money,
		SUM (f_credit_amount) f_credit_amount
	FROM
		t_sellinghand
	WHERE
		f_charge_state = '有效'
	GROUP BY
		f_hand_id
) s ON h.id = s.f_hand_id
WHERE
f_userinfo_id = '{f_userinfo_id}' and f_hand_state = '有效'
and f_hand_date > { entity.findDialect() == $SqlServer$: $'{startDate}'$, $to_date('{startDate}','yyyy-mm-dd HH24:mi:ss')$}
ORDER BY f_hand_date desc
