SELECT *
FROM (
     SELECT
         b.f_open_id,
         b.f_userinfo_id,
         RTRIM(LTRIM(uf.f_meternumber)) f_meternumber,
         RTRIM(LTRIM(u.f_userinfo_code)) f_userinfo_code,
         RTRIM(LTRIM(u.f_user_name)) f_user_name,
         u.f_user_phone,
         uf.f_userfiles_id,
         u.f_balance,
         u.f_orgname as f_filiale,
         u.f_filialeid,
         u.f_orgid,
         u.f_depname as f_outlets,
         a.f_address,
        CASE
		WHEN uf.f_meter_classify = '物联网表' THEN
            bm.f_balance_amount ELSE u.f_balance
	    END  f_balance_amount,
         uf.f_meter_classify,
         uf.f_user_type,
         uf.f_meter_book_num,
         uf.f_gasproperties,
         bk.f_inputtor f_book_inputtor,  --表册抄表员
         bk.f_book_name,
         sp.f_price_name,
         g.f_meter_brand
     FROM t_banduser b
     LEFT JOIN t_userinfo u
            ON b.f_userinfo_id = u.f_userinfo_id
     LEFT JOIN t_userfiles uf
            ON u.f_userinfo_id = uf.f_userinfo_id
     LEFT JOIN t_user_address a
            ON u.f_userinfo_id = a.f_userinfo_id
     LEFT JOIN t_gasbrand g ON uf.f_gasbrand_id = g.id
     LEFT JOIN t_meter_book bk
            ON bk.id = uf.f_meter_book_num
     LEFT JOIN (
         select s.id,s.f_price_id,s.f_price_type,s.f_price_name,
             { entity.findDialect() == $SqlServer$: $
             s.f_price_type + cast((select ' ' + d.f_price_name + '阶:' + '单价' + cast(f_price as varchar) + ',上限' + cast(f_gas as varchar)
             from t_detailprice d where d.f_stairprice_id=s.id for xml path('')) as varchar)
             $,$
             to_char(concat(concat(s.f_price_type, ' '), (select replace(WMSYS.WM_CONCAT(
             concat(d.f_price_name, concat(  '阶梯：', concat('单价',  concat(to_char(f_price), concat(',上限', to_char(f_gas))))))),',', ' ')
             from t_detailprice d  where d.f_stairprice_id = s.id)) )
             $} value
         from t_stairprice s where s.f_state='有效' and getdate()>=f_perform_date and getdate()<=f_end_date
         group by s.id,s.f_price_type,f_price_id,f_price_name
     ) sp on uf.f_price_id = sp.f_price_id
     LEFT JOIN (
         SELECT
             uf.f_userinfo_id,
             case when gb.id is null then cast(uf.f_balance_amount as varchar) else  cast(mr.f_jval as varchar) end f_balance_amount
         FROM
             t_userfiles uf
                 LEFT JOIN t_userinfo ui ON ui.f_userinfo_id= uf.f_userinfo_id
                 left join (select * from  t_gasbrand where f_calculation = '表端结算')	gb on uf.f_gasbrand_id = gb.id
                 left join (
                 select f_userfiles_id,max(id) max_id from t_meteread where f_hand_date > convert(varchar(10), getdate(), 120) and f_hand_date <= getdate() group by f_userfiles_id
             ) mr1 on mr1.f_userfiles_id = uf.f_userfiles_id
                 LEFT JOIN t_meteread mr ON mr.id= mr1.max_id
         WHERE
                 f_table_state = '正常'
           and ui.f_user_state = '正常'
           and ui.f_open_date is not null
           and ui.f_user_phone is not null
           and ui.f_user_name is not null
           and uf.f_meter_classify = '物联网表'
     ) bm on bm.f_userinfo_id = uf.f_userinfo_id
     where f_table_state = '正常' and f_user_state = '正常' and f_band_state='有效' and isnull(b.f_open_id,'') != ''
 ) t
WHERE { condition }
ORDER BY f_userinfo_id
