/**查询用户气表信息**/
SELECT
	f_user_id,
	f_userinfo_id,
	f_meternumber,
	f_meter_classify,
	f_balance_amount,
	f_meter_base,
	f_card_id,
	f_times,
	f_collection_type, -- 缴费方式
	f_total_gas, -- 表累购气量
    uf.f_card_password, -- 卡密码
	gb.f_alias,  --别名
	gb.f_police_gas, -- 报警气量
	gb.f_topup_ceil, --充值上限
	gb.f_overdr_lines, -- 透支额度
	uf.f_table_state,
	gb.f_settlement,--结算类型
	case when uf.f_table_state='停用' and d.f_reason is not null  then d.f_reason else '' end f_reason,
    s.id f_stairid
FROM
	t_userfiles uf LEFT JOIN t_gasbrand gb on uf.f_gasbrand_id = gb.id
    LEFT JOIN t_stairprice s on uf.f_price_id =  s.f_price_id and s.F_FILIALEID =  uf.f_orgid and f_perform_date <= getdate() and f_end_date >= getdate()
	LEFT JOIN (
   select f_userinfo_id userinfoid,f_reason
     from t_disable d
     where id in (select max(id) maxid from t_disable where f_userinfo_id=d.f_userinfo_id group by f_userinfo_id)
    ) d on uf.f_userinfo_id=d.userinfoid
WHERE
	{condition}
ORDER BY
	f_user_id
