package com.aote.weixin.timer;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import com.aote.entity.EntityServer;
import com.aote.exception.FileNotFoundException;
import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlMapper;
import com.aote.sql.SqlServer;
import com.aote.util.ExpressionHelper;
import com.aote.util.ResourceHelper;
import com.aote.util.WxSign;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Component
@EnableScheduling
@Lazy(false)
@Slf4j
@Transactional
public class MessagePush {

    @Autowired
    private SqlServer sqlServer;

    @Autowired
    private EntityServer entityServer;
    @Autowired
    private SqlServer sql;
    /**
     * 余额提醒定时器
     * 格式: cron = [秒] [分] [小时] [日] [月] [周] [年]
     */
    //   @Scheduled(cron = "0 0 19 * * ?")
    public void balanceRemind () {
        log.debug("余额不足推送");
        JSONObject sqlParams = new JSONObject();
        sqlParams.put("condition", "1=1");
        JSONObject pushParams = new JSONObject();
        pushParams.put("sql", "getTemplatePush");
        pushParams.put("params", new JSONObject());
        pushParams.put("filiale", Config.wechatConfig.getString("filiale"));
        pushCreate("templateId2", "balanceRemind", sqlParams, "余额提醒", pushParams);
    }




    /**
     * 电量提醒定时器
     * 格式: cron = [秒] [分] [小时] [日] [月] [周] [年]
     */
     @Scheduled(cron = "0 0 19 * * ?")
    public void electricityRemind () {
        log.debug("电量不足推送");
        JSONObject sqlParams = new JSONObject();
        sqlParams.put("condition", "1=1");
        JSONObject pushParams = new JSONObject();
        pushParams.put("sql", "getTemplatePush");
        pushParams.put("params", new JSONObject());
        pushParams.put("filiale", Config.wechatConfig.getString("filiale"));
        pushCreate("templateId3", "electricityRemind", sqlParams, "电量不足", pushParams);
    }

    /**
     * 账单提醒定时器
     */
//    @Scheduled(cron = "0 0 19 5 * ?")
    public void billRemind () {
        JSONObject sqlParams = new JSONObject();
        // 当前月份的上个月
        DateTime dateTime = DateUtil.lastMonth();
        // 上个月第一天
        DateTime startDate = DateUtil.beginOfMonth(dateTime);
        // 上个月最后一天
        DateTime endDate = DateUtil.endOfMonth(dateTime);
        log.debug("账单提醒数据时间: {} ~ {}", startDate, endDate);
        sqlParams.put("startDate", startDate.toString());
        sqlParams.put("endDate", endDate.toString());
        JSONObject pushParams = new JSONObject();
        pushParams.put("sql", "getTemplatePush");
        pushParams.put("params", new JSONObject());
        pushParams.put("filiale", "xinkang");
        pushCreate("templateId2", "billRemind", sqlParams, "账单提醒", pushParams);
    }

    /**
     * 模板内容取解析(取key)
     *
     * @param content 模板内容
     * @return 解析的keys
     */
    public static ArrayList<String> getTemplateKeys(String content) {
        ArrayList<String> keys = new ArrayList<>();
        String reg = "(\\{\\{)(.*)(.DATA}})";
        //把正则封装成对象
        Pattern p = Pattern.compile(reg);
        //让正则与要作用的字符串进行匹配
        Matcher m = p.matcher(content);
        //按规则作用于字符串，并进行查找
        while (m.find()) {
            keys.add(m.group(2));
        }
        // 最后添加上url
        keys.add("url");
        return keys;
    }

    /**
     *  后台推送统一方法
     * @param templateId 模板id配置名称
     * @param sqlName 数据源sql名称
     * @param sqlParams 数据源sql参数
     * @param sendType 推送类型
     * @param pushParams 发起推送服务需要的参数
     */
    public void pushCreate(String templateId,String sqlName, JSONObject sqlParams, String sendType, JSONObject pushParams) {
        try {
            log.debug("后台推送任务开始: {}", sqlName);
            String templateId1 = Config.wechatConfig.getString(templateId);
            // 通过模板id查找对应的模板信息
            JSONArray templateInfo = sqlServer.query("select * from t_template where f_template_id = '" + templateId1 + "'");
            if (templateInfo.length() != 1) {
                log.debug("模板信息数量不正确: {}, 推送结束!!!", templateInfo.length());
                return;
            }
            // 通过模板id查询对应的表达式
            JSONArray templateExpression = sqlServer.query("select * from t_template_expression where f_template_id = '" + templateId1 + "'");
            if (templateExpression.length() <= 0) {
                log.debug("没有查询到表达式信息, 推送结束!!!");
                return;
            }
            ArrayList<String> keys = getTemplateKeys(templateInfo.getJSONObject(0).getString("f_data_content"));
            if (templateExpression.length() != keys.size()) {
                log.debug("表达式不完整: {}, {}", templateExpression.length(), keys.size());
                return;
            }
            String url = "";
            for (int i = 0; i < templateExpression.length(); i++) {
                JSONObject row = templateExpression.getJSONObject(i);
                String value = row.optString("f_value");
                String key = row.getString("f_key");
                boolean nullValue = !"url".equals(key) && (value == null || "".equals(value));
                if (nullValue) {
                    log.debug("表达式{}的内容为空, 推送结束!!!", key);
                    return;
                }
                if ("url".equals(key)) {
                    url = value;
                }
            }
            String msgPushItem = getMsgPushItem(templateExpression.toString());
            log.debug("表达式组织完成: {}", msgPushItem);
            JSONObject params = new JSONObject();
            JSONObject tempInfo = new JSONObject();
            tempInfo.put("f_send_type", sendType);
            tempInfo.put("f_template_id", templateId1);
            tempInfo.put("f_url", url);
            String pushNumber = WxSign.getNonceStr();
            tempInfo.put("f_push_number", pushNumber);
            params.put("sql", sqlName);
            params.put("dataStr", msgPushItem);
            params.put("params", sqlParams);
            params.put("tempInfo", tempInfo);
            log.debug("本次生成推送数据随机编号: {}", pushNumber);
            // 插入推送数据
            int num = Integer.parseInt(msgpushDate(params.toString()));
            log.debug("本次生成推送数据数量: {}", num);
            JSONObject params1 = pushParams.getJSONObject("params");
            // 加入推送表查询条件
            params1.put("condition", "f_push_number = '" + pushNumber + "'");
            // 调起推送
            msgPush(pushParams.toString());
        } catch (Exception e) {
            log.debug("{}=>定时器报错: {}", sendType, e);
        }
    }

    public String getMsgPushItem(String expression) {
        JSONArray exp = new JSONArray(expression);
        String dataType = Config.wechatConfig.getString("dataType");
        String str = "'{";
        for (int i = 0; i < exp.length(); i++) {
            JSONObject row = exp.getJSONObject(i);
            if (!"url".equals(row.getString("f_key"))) {
                String temp = row.getString("f_value");
                if (temp.contains("<")) {
                    if ("oracle".equals(dataType)) {
                        temp = temp.replace("<", "'||");
                    } else {
                        temp = temp.replace("<", "'+");
                    }
                }
                if (temp.contains(">")) {
                    if ("oracle".equals(dataType)) {
                        temp = temp.replace(">", "||'");
                    } else {
                        temp = temp.replace(">", "+'");
                    }
                }
                if ("'{".equals(str)) {
                    str = str + "\"" + row.getString("f_key") + "\":{\"value\":\"" + temp + "\",\"color\":\"#173177\"}";
                } else {
                    str = str + ",\"" + row.getString("f_key") + "\":{\"value\":\"" + temp + "\",\"color\":\"#173177\"}";
                }
            }
        }
        str += "}'";
        return str;
    }
    public String msgpushDate(String temp) {
        int num = 0;
        try {
            JSONObject tempobj = new JSONObject(temp);
            JSONObject param = tempobj.getJSONObject("params");
            Map<String, Object> params = new HashMap<>();
            Iterator<String> iterator = param.keys();
            while (iterator.hasNext()) {
                String key = (String) iterator.next();
                Object value = param.get(key);
                params.put(key, value);
            }

            // 获取编译后的sql语句
            String sqlName = tempobj.getString("sql");
            String path = SqlMapper.getSql(sqlName);
            if (path == null) {
                throw new RuntimeException("sql语句未注册！" + sqlName);
            }
            String sql2 = null;
            try {
                sql2 = ResourceHelper.getString(path);
            } catch (FileNotFoundException e) {
                throw new RuntimeException(path + ".文件无配置");
            } catch (IOException io) {
                throw new RuntimeException(io);
            }
            String url = null;
            if (tempobj.getJSONObject("tempInfo").getString("f_url").equals("")) {
                url = "\'\'";
            } else {
                url = "'" + tempobj.getJSONObject("tempInfo").getString("f_url") + "'";
            }
            // 获取编译后的sql语句
            sql2 = sql2.replace("\r\n", "\n");
            String dataType = Config.wechatConfig.getString("dataType");
            if (!"oracle".equals(dataType)) {
                sql2 = sql2.replace("select * from", "select top 99999999 * from ");
            }
            sql2 = "$" + sql2;
            // 把自身注册到执行环境中
            params.put("sql", this);
            params.put("entity", entityServer);
            sql2 = ExpressionHelper.run(sql2, params).toString();

            String sql1 = "insert into t_template_push (f_open_id,f_user_name,f_userinfo_id,f_userfiles_id,f_template_id,f_url,f_data,f_send_state,f_fail_cause,f_send_date,f_send_type,f_push_number)\n " +
                    "select  f_open_id,f_user_name,f_userinfo_id,f_userfiles_id,\n'" +
                    tempobj.getJSONObject("tempInfo").getString("f_template_id") + "' f_template_id,\n" +
                    url + " f_url,\n" +
                    tempobj.getString("dataStr") + " f_data,\n" +
                    " '未推送' f_send_state,null f_fail_cause,null f_send_date,'" + tempobj.getJSONObject("tempInfo").getString("f_send_type") + "' f_send_type,'" +
                    tempobj.getJSONObject("tempInfo").optString("f_push_number") + "' f_push_number\n" +
                    "from (\n";
            sql1 = sql1 + sql2 + ")t";
            log.debug("插入推送数据sql: " + sql1);
            num = sql.runSQL(sql1);
        } catch (Exception e) {
            log.debug("生成推送数据失败", e);
            throw new RuntimeException();
        }
        return num + "";
    }
    public String msgPush(String temp) {
        try {
            JSONObject jsonObject = new JSONObject(temp);
            String sql = jsonObject.getString("sql");
            JSONObject params = jsonObject.getJSONObject("params");
            String filiale = jsonObject.getString("filiale");
            // 取分公司配置
            JSONObject config = Config.getConfig(filiale);
            String appId = config.getString("appId");
            String appSecret = config.getString("appSecret");
            JSONObject param = new JSONObject();
            param.put("sql", sql);
            param.put("params", params);
            param.put("appId", appId);
            param.put("appSecret", appSecret);
            if (jsonObject.has("isall")) {
                param.put("isAll", jsonObject.getBoolean("isall"));
            }
            // 推送服务地址
            String weixinPush = Config.wechatConfig.getString("weixinPush");
            log.debug("发送推送请求: " + param.toString());
            String encoding = System.getProperty("file.encoding");
            log.debug("Default System Encoding:" + encoding);
            HttpRequest.post(weixinPush + "rs/logic/weixin_temp_msg_push").body(param.toString()).executeAsync();
        } catch (Exception e)
        {
            log.debug("发送推送请求错误: ", e);
            throw new WebException(500, e.getMessage());
        }
        return "推送请求发送成功";
    }
}
