SELECT * FROM (
    SELECT
      b.f_open_id,
      cast(convert(decimal(18,2), uf.f_balance_amount) as varchar) f_oughtfee_new,
      cast(convert(decimal(18,2), uf.f_balance_amount) as varchar) f_oughtfee,
      cast(convert(decimal(18,2), uf.f_balance_amount) as varchar) f_oughtfee_all,
      '0.00' f_overdue,
      ui.f_userinfo_id,
      uf.f_userfiles_id,
      ui.f_user_name,
      ui.f_userinfo_code,
      CONVERT(varchar(7), GETDATE(), 23) f_hand_date,
      ua.f_address,
      ui.f_orgid
    FROM
      t_banduser b
          LEFT JOIN t_userinfo ui on ui.f_userinfo_id = b.f_userinfo_id
          LEFT JOIN t_userfiles uf ON ui.f_userinfo_id = uf.f_userinfo_id
          left join t_user_address ua on ui.f_userinfo_id = ua.f_userinfo_id
    where uf.f_meter_classify = '物联网表' and f_balance_amount <= 0 and f_table_state = '正常'
) c where {condition}
