package com.aote.util.image;

import com.af.plugins.ConvertTools;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

/**
 * 图像信息类
 */
public class ImageData {
    /**
     * 文件名
     */
    private String name;
    /**
     * 宽度
     */
    private int width;
    /**
     * 高度
     */
    private int height;
    /**
     * base64码
     */
    private String base64Str;
    /**
     * 图片类型
     */
    private String imageType;

    /**
     * 获取图片信息
     * @return 图片信息
     */
    public static ImageData getImageData(String name, String base64Str, int width, int height, String imageType) throws IOException {
        ImageData result = new ImageData();
        //文件名
        result.name = name;
        //图片类型
        result.imageType = imageType;
        //宽度
        result.width = width;
        //高度
        result.height = height;
        //base64串
        result.base64Str = base64Str;
        return result;
    }


    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getBase64Str() {
        return base64Str;
    }

    public void setBase64Str(String base64Str) {
        this.base64Str = base64Str;
    }

    public String getImageType() {
        return imageType;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
