package com.aote.util;

import cn.hutool.http.HttpUtil;
import com.af.plugins.RedisTools;
import com.aote.rs.WeiXinService;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import java.util.HashMap;
import java.util.Map;

/**
 * 全局AccessToken获取
 * 请将该类加入到监听器中
 */
@Slf4j
public class AccessToken implements ServletContextListener {
	private static String access_token;
	public static String url;
	public static String token_name;
	/*存储各个分公司access_token*/
	public static Map<String,String> accessTokenMap =  new HashMap<>();
	public static Map<String,String> urlMap =  new HashMap<>();
	private static Thread t  = new RefreshThread();

//	static {
//		log.debug("开启定时刷新access_token");
//		if (Config.wechatConfig.has("tokenRedisUrl")) {
//			String tokenRedisUrl = Config.wechatConfig.getString("tokenRedisUrl");
//			int tokenRedisProt = Config.wechatConfig.getInt("tokenRedisProt");
//			log.debug("开启自定义redis地址{}:{}", tokenRedisUrl, tokenRedisProt);
//			RedisTools.getJedisPool(tokenRedisUrl, tokenRedisProt);
//		}
//		// 开启定时刷新access_token线程
//		t.start();
//	}

	public static void refreshToken() {
		int n = 5;
		while (n > 0) {
			try {
				log.debug("刷新token链接:" + url );
				JSONObject jsonObject = new JSONObject(HttpUtil.get(url));
				if (jsonObject.has("access_token")) {
					if (Config.wechatConfig.getBoolean("tokenRedis")) {
						if (WeiXinService.hasMoreTokenFiliale) {
							// 多分公司将access_token加入redis
							log.debug("redis缓存access_token：" + token_name);
							RedisTools.setValue(token_name, jsonObject.getString("access_token"));
						} else {
							// 将access_token加入redis
							log.debug("redis缓存access_token");
							RedisTools.setValue("access_token", jsonObject.getString("access_token"));
						}
					}
					access_token = jsonObject.getString("access_token");
					log.debug("刷新access_token成功:" + access_token);
					n = 0;
				} else {
					n--;
					log.debug("刷新access_token失败:" + jsonObject);
				}
			} catch (Exception e) {
				log.debug("刷新access_token异常:", e);
				n--;
			}
		}
	}

	public static String getAccessToken() {
		return access_token;
	}


	public static String getAccessToken(String tokenName) {
		return accessTokenMap.get(tokenName);
	}

	public static void setAccess_token(String access_token) {
		AccessToken.access_token = access_token;
	}

	@Override
	public void contextInitialized(ServletContextEvent servletContextEvent) {
	}

	@Override
	public void contextDestroyed(ServletContextEvent servletContextEvent) {
		// 强制关闭
		t.stop();
		log.debug("AccessToken===>销毁线程");
	}

	private static class RefreshThread extends Thread {
		@Override
		public void run() {
			while (true) {
				try {
					// 一小时刷新一次
					Thread.sleep(1800000);
				} catch (InterruptedException e) {
					log.debug("线程休眠异常:", e);
				}
				if (WeiXinService.hasMoreTokenFiliale) {
					for (Map.Entry<String, String> entry : urlMap.entrySet()) {
						url = entry.getValue();
						token_name = entry.getKey();
						refreshToken();
						accessTokenMap.put(entry.getKey(), access_token);
						AccessToken.url = null;
						AccessToken.setAccess_token("");
						AccessToken.token_name = null;
					}

				} else{
					refreshToken();
				}
			}
		}
	}
}
