package com.aote.rs.swingcardpay;

import java.math.BigDecimal;
import java.util.SortedMap;
import java.util.TreeMap;

import com.aote.entity.WxNofityReturnData;
import com.aote.entity.WxPaySendData;
import com.aote.util.WechatUrl;
import com.aote.util.WxSign;
import com.aote.util.XmlUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.stereotype.Component;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
/**
 * 刷卡支付处理
 *  String money 扫码支付的钱数
 * JSONObject jsonobject 写到的商家数据包，支付 成功后可在attach内原样返回
 * String str 商品描述，或缴费说明，必填
 * String authcode 刷卡授权码 必填
 */
@Component
public class SwingcardPrepay {

	static Logger log = Logger.getLogger(SwingcardPrepay.class);
	private JSONObject result = new JSONObject();

	public JSONObject swingcardprePay(String appId, String mchId, String ip,String key, JSONObject jsonobject) {
		String returnXml = "";
		try {
			WxPaySendData sendData = getPaySendEntity(appId, mchId, ip,  jsonobject);
			log.debug("sendData=" + sendData);
			// 下单处理,返回数据为xml
			 returnXml = unifiedOrder(sendData, key);
			log.debug("returnXml=" + returnXml);
			WxNofityReturnData reData = (WxNofityReturnData) XmlUtils.formatXml(returnXml, WxNofityReturnData.class);
//			// 判断返回数据
			String return_code = reData.getReturn_code();
			if (return_code.equals("SUCCESS")) {
				if (reData.getResult_code().equals("SUCCESS")) {
					result.put("code", 200);
					result.put("f_return_code", reData.getResult_code());
					result.put("f_return_msg", reData.getReturn_msg());
					result.put("f_appid", reData.getAppid());
					result.put("f_mch_id", reData.getMch_id());
					result.put("f_device_info", reData.getDevice_info());
					result.put("f_nonce_str", reData.getNonce_str());
					result.put("f_sign", reData.getSign());
					result.put("f_result_code", reData.getResult_code());
					result.put("f_err_code", reData.getErr_code());
					result.put("f_err_code_des", reData.getErr_code_des());
					result.put("f_openid", reData.getOpenid());
					result.put("f_is_subscribe", reData.getIs_subscribe());
					result.put("f_trade_type", reData.getTrade_type());
					result.put("f_bank_type", reData.getBank_type());
					result.put("f_fee_type", reData.getFee_type());
					result.put("f_total_fee", reData.getTotal_fee());
					result.put("f_coupon_fee", reData.getCoupon_fee());
					result.put("f_cash_fee_type", reData.getCash_fee_type());
					result.put("f_cash_fee", reData.getCash_fee());
					result.put("f_transaction_id", reData.getTransaction_id());
					result.put("f_out_trade_no", reData.getOut_trade_no());
					result.put("f_attach", reData.getAttach());
					result.put("f_time_end", reData.getTime_end());
					
				} else {
					result.put("code", 500);//程序数据错误
					result.put("error", reData.getErr_code());
					result.put("Err_code", reData.getErr_code_des());
				}
			} else {
				result.put("code", 501);//系统错误
				result.put("error", reData.getReturn_msg());
			}
			
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		log.debug("result=" + result);
		return result;
	}

	public WxPaySendData getPaySendEntity(String appId, String mchId, String ip, JSONObject jsonobject) {
		WxPaySendData result = new WxPaySendData();
		result.setAppid(appId);// appid
		result.setMch_id(mchId);//商户id
		result.setNonce_str(WxSign.getNonceStr());
		result.setBody(jsonobject.getString("str"));
		result.setAttach(jsonobject.getJSONObject("js").toString());
		result.setOut_trade_no(WxSign.getNonceStr()); // 随机数
		BigDecimal v1 = new BigDecimal(jsonobject.getString("money"));
		Double b = v1.doubleValue();
		int fee1 = b.intValue();
        result.setTotal_fee(fee1);
		result.setSpbill_create_ip(ip); //订单生成的机器IP，指用户浏览器端IP 
		result.setAuth_code(jsonobject.getString("authcode"));//刷卡授权码
		return result;
	}

	public static String unifiedOrder(WxPaySendData data, String key) {
		// 刷卡支付
		String returnXml = null;
		try {
			// 生成sign签名
			SortedMap<Object, Object> parameters = new TreeMap<Object, Object>();
			parameters.put("appid", data.getAppid());
			parameters.put("mch_id", data.getMch_id());
			parameters.put("nonce_str",data.getNonce_str());
			parameters.put("body",data.getBody());
			parameters.put("attach", data.getAttach());
			parameters.put("out_trade_no",data.getOut_trade_no());
			
			parameters.put("total_fee",(Integer)data.getTotal_fee());
			parameters.put("spbill_create_ip",data.getSpbill_create_ip());
			parameters.put("auth_code",data.getAuth_code());
			parameters.put("sign", WxSign.createSign(parameters, key));
			data.setSign(WxSign.createSign(parameters, key));
			XStream xs = new XStream(new DomDriver("UTF-8",
					new XmlFriendlyNameCoder("-_", "_")));
			xs.alias("xml", WxPaySendData.class);
			String xml = xs.toXML(data);
			//支付发送的xml
			log.debug("sendXml=" + xml);
			HttpClient httpClient = HttpClients.createDefault();
			HttpPost postRequest = new HttpPost(WechatUrl.DOWN_PAY_API);
			StringEntity postEntity = new StringEntity(xml, "UTF-8");
			postRequest.addHeader("Content-Type", "text/xml");
			postRequest.setEntity(postEntity);
			HttpResponse httpResponse = httpClient.execute(postRequest);
			HttpEntity entity = httpResponse.getEntity();
			if (entity != null) {
				returnXml = EntityUtils.toString(entity, "UTF-8");
			}
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return returnXml;
	}

}
