package com.aote.pay.psbc.jiaocheng;

import cn.hutool.http.HttpUtil;
import com.af.plugins.DateTools;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.sql.SqlServer;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import static com.aote.pay.psbc.jiaocheng.SM2.hexStringToBytes;


@Slf4j
@Component
public class JsApiJiaoCheng implements PaySuper  {
    @Autowired
    private LogicServer logicServer;
    

    public static void main(String[] args) {
        String txnCodeBack = "8007";
        String platformIDBack = "300370100000013";
        String reqTraceIDBack = "202310102178229393938186245438";
        String reqDateBack = "20231010185818";
        String txnAMTBack = "0.01";
        String mchtNoBack = "100440100076683";
        String respCdBack = "0000";
        // 签名
        StringBuffer signatureSourceBack = new StringBuffer();
        signatureSourceBack.append(txnCodeBack)
                .append(" ").append(platformIDBack)
                .append(" ").append(reqTraceIDBack)
                .append(" ").append(reqDateBack)
                .append(" ").append(txnAMTBack)
                .append(" ").append(mchtNoBack)
                .append(" ").append(respCdBack);
        String signatureDataBack = signatureSourceBack.toString();
        SM2 clzBack = SM2.getInstance();
        byte [] sourceDataBack = signatureDataBack.getBytes();
        String xRandom = "D3B7F085CD0C8384546D1A81C31595D9F8E32D83CBE3BFE72E423625F5EF3347";
        String yRandom = "4DDBAA6E8F1ED96FDD505248E0D961FADFA86FED05161DAF2E2A7F376B12CEBB";
        String dRandom = "D3F24D61BB2816882B8474B778DD7C3166D665F9455DC9D551C989C161E76AB0";
        // 加签
        byte [] sign = clzBack.SM2Sign(hexStringToBytes(dRandom), sourceDataBack);
        System.out.println(new String(sourceDataBack,StandardCharsets.UTF_8));
        boolean verify = false;
        try {
            verify = clzBack.SM2Verify(hexStringToBytes(xRandom), hexStringToBytes(yRandom),sourceDataBack, sign);
        }catch (Exception e){
            log.debug("交城邮储银行下单验签异常错误", e);
        }
        System.out.println(verify);
    }
    @Override
    public String prePay(JSONObject json) {
        String money = json.getString("money");
        double doubleMoney = Double.parseDouble(money);
        DecimalFormat df = new DecimalFormat("0.00");
        money = df.format(doubleMoney);
        String openid = json.getString("openid");
        String newAttach = json.getJSONObject("attach").toString();
        JSONObject attach = json.getJSONObject("attach");
        JSONObject newAttachParam = new JSONObject();
        log.debug("下单attach=" + attach);
        if (attach.has("f_type")){
            if ("siteOtherFee".equals(attach.getString("f_type"))){
                newAttachParam.put("f_userfiles_id",attach.optString("f_userfiles_id", ""));
                newAttachParam.put("money",attach.optString("money", ""));
                newAttach = newAttachParam.toString();
            }
        }
        String filiale = json.getString("filiale");
        String userfilesid = json.optString("userfilesid","");
        String orderType = json.optString("orderType","燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            // 商户订单号  系统生成  这个是30位的要截取一下
            String outTradeNo = PayUtil.getOrderNoByNumber();
            // 商品描述
            String bodyWX = orderType+"-"+userfilesid;
            String notifyUrl = wxConfig.getString("wechatNotify");
            String mchtNo = wxConfig.getString("mchtNo");
            String platformID = wxConfig.getString("platformID");
            String subAppIDWX = wxConfig.getString("appId");
            String dRandom = wxConfig.getString("dRandom");
            String reqSysId = wxConfig.getString("reqSysId");
            String reqDate = DateTools.getNow("yyyyMMddHHmmss");
            // 组织signature签名 txnCode platformID reqTraceID reqDate txnAMT mchtNo respCd
            StringBuffer signatureSource = new StringBuffer();
            signatureSource.append("8007").append(" ").append(platformID).append(" ").append(outTradeNo).append(" ").append(reqDate).append(" ").append(money).append(" ").append(mchtNo);
            String signatureData = signatureSource.toString();
            log.info("交城邮储银行下单加签串为："+signatureData);
            SM2 clz = SM2.getInstance();
            byte [] sourceData = signatureData.getBytes();
            String signature = "";
            try {
                byte[] sign = clz.SM2Sign(hexStringToBytes(dRandom), sourceData);
                signature = new String(sign);
            }catch (Exception e){
                log.debug("交城邮储银行下单加签异常错误", e);
            }
            JSONObject orderData = new JSONObject();
            orderData.put("orderFlag","0");
            orderData.put("orderTitle",bodyWX);
            orderData.put("orderAMT",money);
            orderData.put("orderDctAMT",0);
            JSONObject termInfo = new JSONObject();
            termInfo.put("deviceType","11");
            termInfo.put("deviceId",wxConfig.opt("deviceId"));
            // 经度
            termInfo.put("longitude","120.521752");
            // 纬度
            termInfo.put("latitude","30.088325");

            JSONObject dataParam = new JSONObject();
            dataParam.put("version",wxConfig.opt("version"));
            dataParam.put("txnCode","8007");
            dataParam.put("platformID",platformID);
            dataParam.put("reqDate", reqDate);
            dataParam.put("signature",signature);
            dataParam.put("certNum",wxConfig.opt("certNum"));
            dataParam.put("reqSysId",wxConfig.opt("reqSysId"));
            dataParam.put("isSign","1");
            dataParam.put("mchtNo",mchtNo);
            dataParam.put("tradeTypeWX","JSAPI");
            dataParam.put("subAppIDWX",subAppIDWX);
            dataParam.put("bodyWX",bodyWX);
            dataParam.put("txnAMT",money);
            dataParam.put("currencyCode","156");
            dataParam.put("orderData",orderData.toString());
            dataParam.put("backUrl",notifyUrl);
            dataParam.put("subOpenIDWX",openid);
            dataParam.put("termID",wxConfig.opt("deviceId"));
            dataParam.put("termInfo",termInfo.toString());
            dataParam.put("isCredit","1");
            dataParam.put("whetherNotify","00");
            dataParam.put("channelID",wxConfig.opt("channelID"));
            dataParam.put("reqTraceID",outTradeNo);

            String PayUrl = wxConfig.getString("PayUrl");
            log.debug("交城邮储银行下单地址: {},下单bogy参数: {}", PayUrl, dataParam);

            String res ;
            try {
                res = HttpUtil.post(PayUrl,dataParam.toString());
                log.debug("请求结果：" + res);
                JSONObject responseJson = new JSONObject(res);
                // 业务代码
                // 验签-->
//                String txnCodeBack = responseJson.getString("txnCode");
//                String platformIDBack = responseJson.getString("platformID");
//                String reqTraceIDBack = responseJson.getString("reqTraceID");
//                String reqDateBack = responseJson.getString("reqDate");
//                String txnAMTBack = responseJson.getString("txnAMT");
//                String mchtNoBack = responseJson.getString("mchtNo");
//                String respCdBack = responseJson.getString("respCd");
//                // 签名
//                String signatureBack = responseJson.getString("signature");
//                StringBuffer signatureSourceBack = new StringBuffer();
//                signatureSourceBack.append(txnCodeBack)
//                        .append(" ").append(platformIDBack)
//                        .append(" ").append(reqTraceIDBack)
//                        .append(" ").append(reqDateBack)
//                        .append(" ").append(txnAMTBack)
//                        .append(" ").append(mchtNoBack)
//                        .append(" ").append(respCdBack);
//                String signatureDataBack = signatureSourceBack.toString();
//                SM2 clzBack = SM2.getInstance();
//                byte [] sourceDataBack = signatureDataBack.getBytes();
//                String xRandom = wxConfig.getString("xRandom");
//                String yRandom = wxConfig.getString("yRandom");
//                // 加签
//                sourceDataBack = clz.SM2Sign(hexStringToBytes(dRandom), sourceDataBack);
//                boolean verify = false;
//                try {
//                    verify = clzBack.SM2Verify(hexStringToBytes(xRandom), hexStringToBytes(yRandom), sourceDataBack, signatureBack.getBytes());
//                }catch (Exception e){
//                    log.debug("交城邮储银行下单验签异常错误", e);
//                }
//                if (verify) {
//                    // 验签通过
//                } else {
//                    // 验签不通过
//                    result.put("code", responseJson.getString("respCd"));
//                    result.put("msg", "下单失败，失败原因:验签失败");
//                }
                String respCd = responseJson.getString("respCd");
                String respDesc = responseJson.getString("respDesc");
                if ("0000".equals(respCd) && "交易成功".equals(respDesc)) {
                    JSONObject saveOrder = new JSONObject();
                    saveOrder.put("f_out_trade_no", outTradeNo);
                    saveOrder.put("f_attach", attach);
                    saveOrder.put("f_openid", openid);
                    saveOrder.put("f_order_state", "已下单");
                    saveOrder.put("f_order_type", orderType);
                    saveOrder.put("flag", "JsApiJiaoCheng");
                    saveOrder.put("f_trade_type", "JSAPI");
                    saveOrder.put("f_send_time", reqDate);
                    // 平台订单号
                    saveOrder.put("f_filiale", filiale);
                    saveOrder.put("f_total_fee", String.valueOf(PayUtil.yuan2FenInt(money)));
                    saveOrder.put("f_userfiles_id", userfilesid);
                    // 保存分公司id
                    JSONObject clientConfig = Config.getClientConfig(filiale);
                    saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                    logicServer.run("savewxreturnxml", saveOrder);
                    result.put("code", respCd);
                    result.put("msg", "SUCCESS");
                    result.put("out_trade_no", outTradeNo);
                    // 平台订单号
                    result.put("rspOrderData",responseJson.getJSONObject("rspOrderData"));
                    // 业务结果详情
                    result.put("respDesc",responseJson.getString("respDesc"));
                    // 付款信息
                    result.put("wcPayData",responseJson.getJSONObject("wcPayData"));
                }else {
                    result.put("code", respCd);
                    result.put("msg", "下单失败，失败原因:" + respDesc);
                }
            } catch (Exception e) {
                log.debug("请求响应错误");
                result.put("code", "501");
                result.put("msg", "请求响应错误");
                result.put("error", e.getMessage());
                throw new RuntimeException("下单请求交城邮储银行未正常响应");
            }
        }catch (Exception e) {
            log.debug("交城邮储银行下单异常错误", e);
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));

            String mchtNo = wxConfig.getString("mchtNo");
            String subAppIDWX = wxConfig.getString("appId");
            String platformID = wxConfig.getString("platformID");
            String dRandom = wxConfig.getString("dRandom");
            String reqDate = DateTools.getNow("yyyyMMddHHmmss");
            String reqTraceId = PayUtil.getOrderNoByNumber();
            // 组织signature签名 txnCode platformID reqTraceID reqDate txnAMT mchtNo respCd
            StringBuffer signatureSource = new StringBuffer();
            signatureSource.append("8006").append(" ").append(platformID).append(" ").append(reqTraceId).append(" ").append(reqDate).append(" ").append(mchtNo);
            String signatureData = signatureSource.toString();
            log.info("交城邮储银行下单加签串为："+signatureData);
            SM2 clz = SM2.getInstance();
            byte [] sourceData = signatureData.getBytes();
            String signature = "";
            try {
                byte[] sign = clz.SM2Sign(hexStringToBytes(dRandom), sourceData);
                signature = new String(sign);
            }catch (Exception e){
                log.debug("交城邮储银行下单加签异常错误", e);
            }
            // 商户订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            String orgReqDate = jsonObject.getString("f_send_time");
            JSONObject bodyParam = new JSONObject();
            bodyParam.put("version",wxConfig.opt("version"));
            bodyParam.put("txnCode","8006");
            bodyParam.put("platformID",platformID);
            bodyParam.put("reqDate", reqDate);
            bodyParam.put("signature",signature);
            bodyParam.put("certNum",wxConfig.opt("certNum"));
            bodyParam.put("reqSysId",wxConfig.opt("reqSysId"));
            bodyParam.put("channelID", wxConfig.getString("channelID"));
            bodyParam.put("reqReserved", wxConfig.optString("reqReserved"));
            bodyParam.put("isSign","1");
            bodyParam.put("orgReqTraceID",outTradeNo);
            bodyParam.put("orgReqDate",orgReqDate);
            bodyParam.put("reqTraceID",reqTraceId);
            bodyParam.put("mchtNo",mchtNo);
            bodyParam.put("subAppIDWX",subAppIDWX);
            // 查询订单结果接口
            String QueryUrl = wxConfig.getString("QueryUrl");

            log.debug("交城邮储银行查询地址: {},查询dataParam参数: {}", QueryUrl, bodyParam);
            String res ;

            res =  HttpUtil.post(QueryUrl,bodyParam.toString());
            log.debug("请求结果：" + res);
            JSONObject responseJson = new JSONObject(res);
            String respCd = responseJson.getString("respCd");
            String respDesc = responseJson.getString("respDesc");
            if ("0000".equals(respCd) && "交易成功".equals(respDesc)) {
                String txnSta = "";
                switch (responseJson.getString("txnSta")) {
                    case "01":
                        txnSta = "初始态";
                        break;
                    case "02":
                        txnSta = "待支付";
                        break;
                    case "03":
                        txnSta = "成功";
                        break;
                    case "04":
                        txnSta = "失败";
                        break;
                    case "05":
                        txnSta = "检查失败";
                        break;
                    case "99":
                        txnSta = "支付中/退款中";
                        break;
                    default:
                        txnSta = "查询错误，支付状态位置";
                }
                log.debug("当前订单交易状态：" + txnSta);
                if ( "03".equals(responseJson.getString("txnSta"))) {
                    // 用户付款成功了
                    result.put("result_code", "SUCCESS");
                    result.put("trade_state", "SUCCESS");
                    result.put("transaction_id", responseJson.getString("orderNo"));
                    // 交易时间
                    result.put("time_end", responseJson.getString("orderTime"));
                    result.put("total_fee", String.valueOf(PayUtil.yuan2FenInt(responseJson.opt("txnAMT"))));
                } else {
                    result.put("result_code", "FAIL");
                    result.put("trade_state", "FAIL");
                    result.put("result_msg",  txnSta);
                }
            } else {
                result.put("result_code", "FAIL");
                result.put("trade_state", "FAIL");
                result.put("result_msg",  responseJson.getString("respDesc"));
            }
            } catch (Exception e) {
                log.debug("交城邮储银行查询订单异常", e);
                result.put("result_code", "FAIL");
                result.put("trade_state", "FAIL");
                result.put("result_msg", e.getMessage());
            }
            log.debug("查询订单返回: {}", result.toString());
            return result.toString();
    }

    public JSONObject uploadDevice(JSONObject json) {
        String filiale = json.getString("f_filiale");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject config1 = Config.getConfig(filiale);
        JSONObject header = new JSONObject();
        String outTradeNo = PayUtil.getOrderNoByNumber();
        String subAppIDWX = config1.getString("appId");
        String dRandom = config1.getString("dRandom");
        String reqDate = DateTools.getNow("yyyyMMddHHmmss");
        // 版本号
        header.put("version", "v3.1");
        //
        header.put("txnCode", "8019");
        header.put("channelID", config1.getString("channelID"));
        header.put("platformID", config1.getString("platformID"));
        header.put("reqTraceID", outTradeNo);
        header.put("reqDate", reqDate);
        header.put("reqReserved", config1.optString("reqReserved"));
        header.put("certNum", config1.getString("certNum"));
        header.put("reqSysId", config1.getString("reqSysId"));
        header.put("isSign", config1.getString("isSign"));


        if (config1.getString("isSign").equals("1")) {
            String signData = "8019" + " " + config1.getString("platformID") + " "
                    + outTradeNo + " " + reqDate;
            SM2 clz = SM2.getInstance();
            byte [] sourceData = signData.getBytes();
            String signature = "";
            try {
                byte[] sign = clz.SM2Sign(hexStringToBytes(dRandom), sourceData);
                signature = new String(sign,StandardCharsets.UTF_8);
            }catch (Exception e){
                log.debug("交城邮储银行下单加签异常错误", e);
            }
            header.put("signature", signature);
        }

        header.put("externalType", "02");
        header.put("mchtId",config1.getString("mchtNo"));
        header.put("operationId","00");
        header.put("subAppid",subAppIDWX);
        header.put("deviceType","11");
        header.put("devicedId","12345678");
        header.put("deviceState","00");
        header.put("deviceAddress","测试地址");

        // 发送请求
        String PayUrl = config1.getString("uploadUrl");
        log.debug("交城邮储银行设备上报地址: {},上报参数: {}", PayUrl, header);

        String res ;

        res = HttpUtil.post(PayUrl,header.toString());
        log.debug("请求结果：" + res);
        JSONObject responseJson = new JSONObject(res);
        return responseJson;
    }
}
