package com.aote.pay.huatong;

import com.iflytek.sc.ssp.uc.client.context.UCCasServiceContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import com.iflytek.sc.ssp.uc.client.util.SignUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

@Component
public class UccpUserInfoClient {

    private static Logger logger = LoggerFactory.getLogger(UccpUserInfoClient.class);


    /**
     * 服务转发
     */
    public String paramSend(String appCode,String appSercert,String token,String userInfoUrl) throws Exception{
        if(StringUtils.isBlank(appCode) || StringUtils.isBlank(appSercert)){
             appCode = "test";
             appSercert = "1234567812345678";
        }
        String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        return getUserInfo(appCode,token,time,signDemo(appCode,appSercert,token,time),userInfoUrl);
    }


    /**
     *签名规则
     */
    public static String signDemo(String appCode,String appSercert,String token,String time){
        TreeMap<String, String> signParams = new TreeMap<String, String>();
        signParams.put("time", time);
        signParams.put("appCode", appCode);
        signParams.put("token", token);
        String signData = SignUtil.produceData(signParams);
        String sign = SignUtil.md5Encode(signData + appSercert);
        return sign;
    }

    /**
     * 调用接口信息
     * @param appCode
     * @param time
     * @param token
     * @param sign
     * @return
     * @throws Exception
     */
    public  String getUserInfo(String appCode, String token, String time, String sign,String userInfoUrl) throws Exception{
        String url = UCCasServiceContext.getUcConstant().getResturl() + userInfoUrl;
        // 请求体
        Map<String, Object> paramData = new HashMap<String, Object>();
        paramData.put("token", token);
        // 请求头
        Map<String, String> headers  = new HashMap<String, String>();
        headers.put("time", time);
        headers.put("appCode", appCode);
        headers.put("sign", sign);
        headers.put("cm","basic,legal,credent,phone");
        logger.info("请求地址：{}",url);
        logger.info("请求头：{}",headers.toString());
        // doPost请求
        String result = HttpUtil.doPost(url, paramData, headers);
        logger.info("返回结果：{}",result);
        return result;
    }





}
