package com.aote.pay.ceb.xinkang;

import com.aote.utils.SSLClient;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 请求测试类  .
 * @author
 * @serial  .
 */
public class HttpSendUtil {

	/**
	 * 连接后会话超时时间 .
	 */
	private static int SOCKET_TIMEOUT = 360000;
	/**
	 * 连接超时时间 .
	 */
	private static int CONNECT_TIMEOUT = 720000;

	/**
	 * 请求处理类.
	 * @param url .
	 * @param dataMap .
	 * @return CloseableHttpResponse .
	 */
	public static String sendToOtherServer2(String url,Map<String,String> dataMap) throws IOException {
		CloseableHttpResponse response = null;
		try {
			CloseableHttpClient client = new SSLClient();
			RequestConfig config = RequestConfig.custom()
					.setSocketTimeout(SOCKET_TIMEOUT)
					.setConnectTimeout(CONNECT_TIMEOUT)
					.setConnectionRequestTimeout(CONNECT_TIMEOUT)
					.setAuthenticationEnabled(false)
					.build();


			HttpPost post = new HttpPost(url);
			post.setProtocolVersion(org.apache.http.HttpVersion.HTTP_1_1);
			post.setConfig(config);

			HttpEntity entity;
			List<NameValuePair> formpair = new ArrayList<>();
			{
				for (String str : dataMap.keySet().toArray(new String[0])) {
					formpair.add(new BasicNameValuePair(str, dataMap.get(str)));
				}
			}

			entity = new UrlEncodedFormEntity(formpair, Consts.UTF_8);
			if (entity != null) {
				post.setEntity(entity);
			}
			try {
				response = client.execute(post);
				HttpEntity httpEntity = response.getEntity();
				return EntityUtils.toString(httpEntity, "UTF-8");
			} finally {
				if (client != null) {
					client.close();
				}
			}
		} catch (ClientProtocolException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
	    } finally {
			if (response != null) {
				response.close();
			}
		}
		return null;
	}
}
