package com.aote.pay.ccb_gongyi;

import COM.CCB.EnDecryptAlgorithm.MCipherEncryptor;
import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.sql.SqlServer;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static java.util.regex.Pattern.compile;

/**
 * @Author: JoeCdy
 * @Description: 巩义建行 付款码支付
 * @Date: Created in 0:16 2020/8/30
 */
@Slf4j
@Component
public class MicroPayGongYi implements PaySuper {

    @Autowired
    private LogicServer logicServer;

    @Autowired
    private SqlServer sqlServer;
    
    /**
     * 下单接口
     *
     * @param json
     * @return 下单结果参数
     */
    @Override
    public String prePay(JSONObject json) {
        JSONObject result = new JSONObject();
        try {
            String money = String.valueOf(json.get("money"));
            String auth_code = String.valueOf(json.get("auth_code"));
            String attach = String.valueOf(json.get("attach"));
            String filiale = String.valueOf(json.get("filiale"));
            // 取传入的柜台号
            String posidParam = json.optString("posid");

            if (filiale == null || filiale.length() == 0) {
                throw new RuntimeException("公司信息不能为空！");
            }
            // 金额正则,可以没有小数,小数最多不超过两位
            Pattern pattern = compile("\\d+(\\.\\d{1,2})?");
            Matcher matcher = pattern.matcher(money);
            if (!matcher.matches()) {
                throw new RuntimeException("金额格式不正确，无法进行交易");
            } else if (Double.parseDouble(money) <= 0) {
                throw new RuntimeException("支付金额必须大于0");
            }
            if ("".equals(auth_code)) {
                throw new RuntimeException("付款码不能为空!");
            }
            JSONObject wxConfig = Config.getConfig(filiale);
            // 商户类型 1:线上商户
            String merflag = "1";
            // 商户代码
            String merchantid = wxConfig.getString("MERCHANTID2");
            // 商户柜台代码
            String posid = "".equals(posidParam) ? wxConfig.getString("POSID2") : posidParam;
            // 分行代码
            String branchid = wxConfig.getString("BRANCHID");
            // 订单号
            String orderid = PayUtil.getOrderNoByNumber();
            // 付款码
            String qrcode = auth_code;
            // 付款金额 元
            String amount = money;
            // 交易码
            String txcode = "PAY100";
            // 验签字段
            LinkedHashMap<String, Object> linkMap = new LinkedHashMap<>();
            linkMap.put("MERFLAG", merflag);
            linkMap.put("MERCHANTID", merchantid);
            linkMap.put("POSID", posid);
            linkMap.put("TERMNO1", "");
            linkMap.put("TERMNO2", "");
            linkMap.put("BRANCHID", branchid);
            linkMap.put("ORDERID", orderid);
            linkMap.put("QRCODE", qrcode);
            linkMap.put("AMOUNT", amount);
            linkMap.put("TXCODE", txcode);
            // MAC串
            StringBuilder macString = new StringBuilder();
            for (Map.Entry<String, Object> entry : linkMap.entrySet()) {
                macString.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            // 商户公匙
            String pubkey = "".equals(posidParam) ? wxConfig.getString("PUBKEY2") : wxConfig.getString(posidParam);
            // PUB字段为对应柜台的公钥后30位
            String PUB = pubkey.substring(pubkey.length() - 30);
            // 创建加密对象，向构造函数传入密钥
            MCipherEncryptor ccbEncryptor = new MCipherEncryptor(PUB);
            // 执行加密
            String ccbParam = ccbEncryptor.doEncrypt(macString.toString());
            // 加入密文
            linkMap.put("ccbParam", ccbParam);
            // 下单地址
            String downPayApi = wxConfig.getString("ORDER_STATUS");
            log.debug("巩义建行付款码下单地址: {},下单参数: {}", downPayApi, new JSONObject(linkMap));
            // 发送下单请求
            String response = HttpUtil.post(downPayApi, linkMap);
            log.debug("巩义建行付款码下单返回数据: {}", response);
            JSONObject jo;
            try {
                jo = new JSONObject(response);
            } catch (Exception e) {
                throw new RuntimeException("付款码下单请求建行未正常响应");
            }
            // 保存中间表对象
            JSONObject saveOrder = new JSONObject();
            // 返回订单号
            result.put("f_out_trade_no", orderid);
            if (jo.isNull("RESULT") || "N".equals(jo.getString("RESULT"))) {
                throw new RuntimeException("付款码下单失败,银行返回信息:" + response);
            } else if ("Q".equals(jo.getString("RESULT")) || "U".equals(jo.getString("RESULT"))) {
                // 待查询
                saveOrder.put("f_order_state", "待查询");
                result.put("result_msg", "支付结果未知");
            } else if ("Y".equals(jo.getString("RESULT"))) {
                // 支付成功
                saveOrder.put("f_order_state", "已支付");
                result.put("result_msg", "支付确认成功");
            }
            // 二维码类型
            String qrcodetype = jo.getString("QRCODETYPE");
            String qrcodename = "";
            switch (qrcodetype) {
                case "1":
                    qrcodename = "龙支付";
                    break;
                case "2":
                    qrcodename = "微信";
                    break;
                case "3":
                    qrcodename = "支付宝";
                    break;
                case "4":
                    qrcodename = "银联";
                    break;
                default:
                    qrcodename = "未知";
            }
            result.put("qrcodetype", qrcodetype);
            // 返回商户柜台代码, 用以查询订单时确认柜台
            result.put("posid", posid);
            // 保存下单信息到中间表
            JSONObject param = new JSONObject(attach);
            String userFilesId = param.optString("f_userfiles_id", "");
            saveOrder.put("f_out_trade_no", orderid);
            saveOrder.put("f_transaction_id", orderid);
            saveOrder.put("f_attach", attach);
            saveOrder.put("f_order_type", "燃气收费");
            saveOrder.put("flag", "MicroPayGongYi");
            saveOrder.put("f_trade_type", "MICROPAY");
            saveOrder.put("f_bank_type", qrcodename);
            saveOrder.put("f_filiale", filiale);
            saveOrder.put("f_userfiles_id", userFilesId);
            saveOrder.put("f_total_fee", PayUtil.yuan2FenInt(money));
            // 付款码支付,下单时就把时间给存进去
            saveOrder.put("f_time_end", DateUtil.format(DateUtil.date(), DatePattern.PURE_DATETIME_PATTERN));
            // 保存分公司id
            JSONObject clientConfig = Config.getClientConfig(filiale);
            saveOrder.put("f_orgid", clientConfig.get("orgStr"));
            logicServer.run("savewxreturnxml", saveOrder);
        } catch (Exception e) {
            log.debug("巩义建行付款码下单异常错误", e);
            result.put("result_msg", "支付确认失败");
            result.put("err_msg", e.getMessage());
        }
        log.debug("巩义建行付款码下单返回: {}", result.toString());
        return result.toString();
    }

    /**
     * 查询
     *
     * @param value
     * @return 订单支付结果
     */
    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String orderStatus = wxConfig.getString("ORDER_STATUS");
            // 取传入的柜台号
            String posidParam = jsonObject.optString("posid");
            // 1-线上商户
            String MERFLAG = "1";
            // 商户代码
            String MERCHANTID = wxConfig.getString("MERCHANTID2");
            // 商户柜台代码
            String POSID = "".equals(posidParam) ? wxConfig.getString("POSID2") : posidParam;
            // 分行代码
            String BRANCHID = wxConfig.getString("BRANCHID");
            // 订单号
            String ORDERID = jsonObject.getString("out_trade_no");
            // 查询次数
            String QRYTIME = String.valueOf(jsonObject.optInt("f_judge_count", 0) + 1);
            // 二维码类型 2-微信 3-支付宝
            String QRCODETYPE = jsonObject.getString("qrcodetype");
            // 固定值PAY101
            String TXCODE = "PAY101";
            //验签字段
            StringBuffer tmp = new StringBuffer();
            tmp.append("&MERFLAG=");
            tmp.append(MERFLAG);
            tmp.append("&MERCHANTID=");
            tmp.append(MERCHANTID);
            tmp.append("&POSID=");
            tmp.append(POSID);
            tmp.append("&TERMNO1=");
            tmp.append("&TERMNO2=");
            tmp.append("&BRANCHID=");
            tmp.append(BRANCHID);
            tmp.append("&ORDERID=");
            tmp.append(ORDERID);
            tmp.append("&QRYTIME=");
            tmp.append(QRYTIME);
            tmp.append("&QRCODETYPE=");
            tmp.append(QRCODETYPE);
            tmp.append("&TXCODE=");
            tmp.append(TXCODE);
            // 商户公匙
            String pubkey = "".equals(posidParam) ? wxConfig.getString("PUBKEY2") : wxConfig.getString(posidParam);
            // PUB字段为对应柜台的公钥后30位
            String PUB = pubkey.substring(pubkey.length() - 30);
            // 创建加密对象，向构造函数传入密钥
            MCipherEncryptor ccbEncryptor = new MCipherEncryptor(PUB);
            // 执行加密
            String ccbParam = ccbEncryptor.doEncrypt(tmp.toString());

            Map map = new HashMap();
            map.put("MERFLAG", MERFLAG);
            map.put("TXCODE", TXCODE);
            map.put("TERMNO1", "");
            map.put("TERMNO2", "");
            map.put("ORDERID", ORDERID);
            map.put("QRYTIME", QRYTIME);
            map.put("QRCODETYPE", QRCODETYPE);
            map.put("QRCODE", "");
            map.put("REMARK1", "");
            map.put("REMARK2", "");
            map.put("SUB_APPID", "");
            map.put("RETURN_FIELD", "");
            map.put("ccbParam", ccbParam);
            String url = orderStatus + "?MERCHANTID=" + MERCHANTID + "&POSID=" + POSID + "&BRANCHID=" + BRANCHID + "&ccbParam=" + ccbParam;
            log.debug("即将发起查询请求，url:" + url + ",参数map:" + new JSONObject(map));
            String response = HttpUtil.post(url, map);
            log.debug("查询响应结果:" + response);
            JSONObject jo = null;
            try {
                jo = new JSONObject(response);
            } catch (Exception e) {
                throw new RuntimeException("获取支付结果建行未正常响应");
            }

            if (jo.isNull("RESULT") || "N".equals(jo.getString("RESULT"))) {
                throw new RuntimeException("付款码查询失败,银行返回信息:" + response);
            } else if ("Q".equals(jo.getString("RESULT")) || "U".equals(jo.getString("RESULT"))) {
                // 待查询
                result.put("result_msg", "支付结果未知");
            } else if ("Y".equals(jo.getString("RESULT"))) {
                // 支付成功
                result.put("f_out_trade_no",ORDERID);

                result.put("result_msg", "支付确认成功");
                // 更新中间表状态
                String f_time_end = DateUtil.format(DateUtil.date(), DatePattern.PURE_DATETIME_PATTERN);
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state = '已支付',f_time_end = '" + f_time_end + "' where f_out_trade_no = '" + ORDERID + "'");
            }
        } catch (Exception e) {
            log.debug("巩义建行付款码查询异常错误:", e);
            result.put("result_msg", "支付确认失败");
            result.put("err_msg", e.getMessage());
        }
        log.debug("巩义建行付款码查询返回: {}", result.toString());
        return result.toString();
    }
}
