package com.aote.pay.boc.yongzhou;

import cn.hutool.core.date.DateTime;
import com.af.plugins.CommonTools;
import com.aote.logic.LogicServer;
import com.aote.pay.PaySuper;
import com.aote.pay.RefundSuper;
import com.aote.sql.SqlServer;
import com.aote.util.PayUtil;
import com.aote.weixin.Config;
import com.bocom.api.DefaultBocomClient;
import com.aote.pay.boc.yongzhou.MPNG210005RequestV1.MPNG210005RequestV1Biz;
import com.aote.pay.boc.yongzhou.MPNG210005RequestV1.MPNG210005RequestV1Biz.ReqBody;
import com.aote.pay.boc.yongzhou.MPNG210005RequestV1.MPNG210005RequestV1Biz.ReqBody.RequireFields;
import com.aote.pay.boc.yongzhou.MPNG210005RequestV1.MPNG210005RequestV1Biz.ReqBody.RoyaltyInfo;
import com.aote.pay.boc.yongzhou.MPNG210005RequestV1.MPNG210005RequestV1Biz.ReqHead;
import lombok.extern.slf4j.Slf4j;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.*;

@Slf4j
@Component
public class JsApiYongZhou implements PaySuper , RefundSuper {
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;
    
    @Override
    public String prePay(JSONObject json) {
        HttpServletRequest req = (HttpServletRequest) json.get("request");
        String money = json.getString("money");
        String openid = json.getString("openid");
        String attach = json.getJSONObject("attach").toString();
        String filiale = json.getString("filiale");
        String userfilesid = json.getString("userfilesid");
        String orderType = json.optString("orderType", "燃气收费");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        // 商品描述
        String body = orderType + "-" + userfilesid;
        try {
            String APP_ID = wxConfig.getString("APP_ID");
            String appId = wxConfig.getString("appId");
            String MCH_ID = wxConfig.getString("MCH_ID");
            String partner_id = wxConfig.getString("partner_id");
            String MY_PRIVATE_KEY = wxConfig.getString("MY_PRIVATE_KEY");
            String notifyUrl = wxConfig.getString("wechatNotify");
            String APIGW_PUBLIC_KEY = wxConfig.getString("APIGW_PUBLIC_KEY");
            DefaultBocomClient client = new DefaultBocomClient(APP_ID, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
            client.ignoreSSLHostnameVerifier();
            String PayUrl = wxConfig.getString("payUrl");
            String txnOrderId = PayUtil.getOutTradeNo();
            /**
             * 测试环境可以忽略SSL证书告警，生产环境不可忽略
             */
            MPNG210005RequestV1 request = new MPNG210005RequestV1();
            request.setServiceUrl(PayUrl);

            MPNG210005RequestV1Biz bizContent = new MPNG210005RequestV1Biz();
            ReqHead reqHead = new ReqHead();
            bizContent.setReqHead(reqHead);
            reqHead.setTransTime(new DateTime().toString("yyyyMMddHHmmss"));
            reqHead.setVersion("1.0");
            ReqBody reqBody = new ReqBody();
            bizContent.setReqBody(reqBody);

            List<RoyaltyInfo> royaltyInfo = new ArrayList<RoyaltyInfo>();
            RoyaltyInfo royalty_info = new RoyaltyInfo();
            royaltyInfo.add(royalty_info);
            reqBody.setRoyaltyInfo(royaltyInfo);
            royalty_info.setAmount(money);
            royalty_info.setSerialNo("");
            reqBody.setValidPeriod("");
            reqBody.setTranScene("B2C-PREPAYJSAPI-WECHAT");
            reqBody.setIp(req.getRemoteAddr());
            // 商户号
            reqBody.setMerPtcId(MCH_ID);
            // 当前时间
            reqBody.setMerTradeTime(new SimpleDateFormat("HHmmss").format(new Date()));
            reqBody.setNotifyUrl(notifyUrl);
            String trDate = new SimpleDateFormat("yyyyMMdd").format(new Date());
            reqBody.setMerTradeDate(trDate);
            reqBody.setPartnerId(partner_id);
            reqBody.setPayMerTranNo(txnOrderId);
            reqBody.setMerMemo(attach);
            reqBody.setSubAppId(appId);
            reqBody.setTotalAmount(money);
            reqBody.setSubOpenId(openid);

            List<RequireFields> requireFields = new ArrayList<RequireFields>();
            RequireFields require_fields = new RequireFields();
            requireFields.add(require_fields);
            reqBody.setRequireFields(requireFields);
            require_fields.setRequireField("");
            reqBody.setLocation("ONLINE");
            reqBody.setCurrency("CNY");
            reqBody.setTranContent(body);
            reqBody.setNoDsctAmount("");
            reqBody.setDisablePayChannels("");
            reqBody.setJumpUrl("");
            reqBody.setShopId("");
            request.setBizContent(bizContent);
            log.debug("永州交行下单地址: {},下单bogy参数: {}", PayUrl, bizContent.toString());
            try {
                MPNG210005ResponseV1 response = client.execute(request, UUID.randomUUID().toString().replace("-", ""));
                log.debug("下单请求结果: {}", response.toString());
                if (response.isSuccess()) {
                    if ("S".equals(response.getRspHead().getResponseStatus()) || "P".equals(response.getRspHead().getResponseStatus())) {
                        JSONObject saveOrder = new JSONObject();
                        saveOrder.put("f_out_trade_no", txnOrderId);
                        saveOrder.put("f_attach", attach);
                        saveOrder.put("f_openid", openid);
                        saveOrder.put("f_order_state", "已下单");
                        saveOrder.put("f_order_type", orderType);
                        saveOrder.put("flag", "JsApiYongZhou");
                        saveOrder.put("f_trade_type", "JSAPI");
                        saveOrder.put("f_filiale", filiale);
                        saveOrder.put("f_total_fee", String.valueOf(PayUtil.yuan2FenInt(money)));
                        saveOrder.put("f_userfiles_id", userfilesid);
                        saveOrder.put("f_trdate", trDate);
                        // 保存分公司id
                        JSONObject clientConfig = Config.getClientConfig(filiale);
                        saveOrder.put("f_orgid", clientConfig.get("orgStr"));
                        logicServer.run("savewxreturnxml", saveOrder);
                        result.put("code", "200");
                        result.put("msg", "SUCCESS");
                        result.put("f_out_trade_no", txnOrderId);
                        result.put("appId", appId);
                        result.put("tranPackage", response.getRspBody().getTranPackage());
                    } else {
                        result.put("code", response.getRspHead().getResponseCode());
                        result.put("error", "请求成功，下单失败，失败原因:" + response.getRspHead().getResponseMsg());
                    }
                } else {
                    result.put("code", response.getRspCode());
                    result.put("error", "请求失败，下单失败，失败原因:" + response.getRspMsg());
                }
            } catch (Exception e) {
                log.debug("请求响应错误");
                result.put("code", "500");
                result.put("result_msg", "请求响应错误");
                result.put("err_msg", e.getMessage());
                throw new RuntimeException("下单请求永州交行未正常响应");
            }
        } catch (Exception e) {
            log.debug("永州交行下单异常错误:{}", e.getMessage());
        }
        return result.toString();
    }

    @Override
    public String orderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String APP_ID = wxConfig.getString("APP_ID");
            String MCH_ID = wxConfig.getString("MCH_ID");

            String MY_PRIVATE_KEY = wxConfig.getString("MY_PRIVATE_KEY");
            String APIGW_PUBLIC_KEY = wxConfig.getString("APIGW_PUBLIC_KEY");
            DefaultBocomClient client = new DefaultBocomClient(APP_ID, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
            client.ignoreSSLHostnameVerifier();
            String queryUrl = wxConfig.getString("queryUrl");
            MPNG020702RequestV1 request = new MPNG020702RequestV1();
            request.setServiceUrl(queryUrl);
            String outTradeNo = jsonObject.getString("out_trade_no");

            MPNG020702RequestV1.MPNG020702RequestV1Biz bizContent = new MPNG020702RequestV1.MPNG020702RequestV1Biz();
            MPNG020702RequestV1.MPNG020702RequestV1Biz.ReqHead reqHead = new MPNG020702RequestV1.MPNG020702RequestV1Biz.ReqHead();
            bizContent.setReqHead(reqHead);
            // 时间
            reqHead.setTransTime(new DateTime().toString("yyyyMMddHHmmss"));
            reqHead.setVersion("1.0");
            MPNG020702RequestV1.MPNG020702RequestV1Biz.ReqBody reqBody = new MPNG020702RequestV1.MPNG020702RequestV1Biz.ReqBody();
            bizContent.setReqBody(reqBody);
            reqBody.setMerTradeDate(new SimpleDateFormat("yyyyMMdd").format(new Date()));
            // todo
            reqBody.setPartnerId("");
            reqBody.setPayMerTranNo(outTradeNo);
            reqBody.setTranScene("B2C-API-SCANCODE");

            List<MPNG020702RequestV1.MPNG020702RequestV1Biz.ReqBody.RequireFields> require_fieldsList = new ArrayList<MPNG020702RequestV1.MPNG020702RequestV1Biz.ReqBody.RequireFields>();
            MPNG020702RequestV1.MPNG020702RequestV1Biz.ReqBody.RequireFields require_fields = new MPNG020702RequestV1.MPNG020702RequestV1Biz.ReqBody.RequireFields();
            require_fieldsList.add(require_fields);
            require_fields.setRequireField("");
            // 商户编号 从配置文件查询
            reqBody.setMerPtcId(MCH_ID);
            reqBody.setSysOrderNo("");
            request.setBizContent(bizContent);

            log.debug("永州交行查询地址: {},下单bogy参数: {}", queryUrl, bizContent.toString());

            MPNG020702ResponseV1 response = client.execute(request, UUID.randomUUID().toString().replace("-", ""));
            log.debug("查询请求结果：" + response.toString());
            if (response.isSuccess()) {
                // 支付成功了
                MPNG020702ResponseV1.RspBody rspBody = response.getRspBody();
                String orderStatus = rspBody.getOrderStatus();
                String tranStateMsg = rspBody.getTranStateMsg();
                if ("PAIED".equals(orderStatus)) {
                    result.put("result_code", "SUCCESS");
                    result.put("trade_state", "SUCCESS");
                    result.put("transaction_id", rspBody.getPayMerTranNo());
                    result.put("time_end", response.getRspHead().getResponseTime());
                    result.put("time_end", response.getRspHead().getResponseTime());
                } else {
                    result.put("result_code", "FAIL");
                    result.put("result_msg", tranStateMsg);
                }
            } else {
                result.put("result_code", "FAIL");
                result.put("result_msg", response.getRspMsg());
            }
        } catch (Exception e) {
            log.debug("永州交行订单异常", e);
            result.put("result_code", "FAIL");
            result.put("trade_state", "FAIL");
            result.put("result_msg", e.getMessage());
        }
        log.debug("查询订单返回: {}", result.toString());
        return result.toString();
    }
    /**
     * 退款
     * {
     *   "f_total_fee": "1",
     *   "f_filiale": "yongzhou",
     *   "id":2514,
     *   "f_trdate": "20230922",
     *   "out_trade_no": "20230922waly0r5u08iwa1xwdwhz0qzg",
     *   "flag": "JsApiYongZhou"
     * }
     * @param json
     * @return 退款
     */
    @Override
    public String refund(JSONObject json) {
        String filiale = json.getString("f_filiale");
        Integer id = json.getInt("id");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        String outTradeNo = json.getString("out_trade_no");
        String trDate = json.getString("f_trdate");
        String refundAmount = String.valueOf(CommonTools.div(json.getString("f_total_fee"), 100));
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            String APP_ID = wxConfig.getString("APP_ID");
            String MCH_ID = wxConfig.getString("MCH_ID");
            String MY_PRIVATE_KEY = wxConfig.getString("MY_PRIVATE_KEY");
            String APIGW_PUBLIC_KEY = wxConfig.getString("APIGW_PUBLIC_KEY");
            DefaultBocomClient client = new DefaultBocomClient(APP_ID, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
            // 退款需要新的退款单号
            String txnOrderId = PayUtil.getOutTradeNo();
            /**
             * 测试环境可以忽略SSL证书告警，生产环境不可忽略
             */
            client.ignoreSSLHostnameVerifier();
            String refundUrl = wxConfig.getString("refundUrl");
            MPNG020701RequestV1 request = new MPNG020701RequestV1();
            request.setServiceUrl(refundUrl);

            MPNG020701RequestV1.MPNG020701RequestV1Biz bizContent = new MPNG020701RequestV1.MPNG020701RequestV1Biz();
            MPNG020701RequestV1.MPNG020701RequestV1Biz.ReqHead reqHead = new MPNG020701RequestV1.MPNG020701RequestV1Biz.ReqHead();
            bizContent.setReqHead(reqHead);
            reqHead.setTransTime(new DateTime().toString("yyyyMMddHHmmss"));
            reqHead.setVersion("1.0");
            MPNG020701RequestV1.MPNG020701RequestV1Biz.ReqBody reqBody = new MPNG020701RequestV1.MPNG020701RequestV1Biz.ReqBody();
            bizContent.setReqBody(reqBody);
            reqBody.setAmount(refundAmount);
            reqBody.setTranScene("B2C-PREPAYJSAPI-WECHAT");
            reqBody.setMerPtcId(MCH_ID);
            reqBody.setNotifyUrl("");
            reqBody.setMerTradeDate(trDate);
            reqBody.setShopId("");
            reqBody.setPartnerId("");
            reqBody.setPayMerTranNo(outTradeNo);
            reqBody.setMerMemo("退款");
            reqBody.setRefundMerTranNo(txnOrderId);
            reqBody.setCurrency("CNY");
            reqBody.setMerRefundTime(new SimpleDateFormat("HHmmss").format(new Date()));
            reqBody.setMerRefundDate(new SimpleDateFormat("yyyyMMdd").format(new Date()));
            reqBody.setTranContent("");
            reqBody.setSysOrderNo("");
            request.setBizContent(bizContent);
            log.debug("永州交行退款地址: {},退款参数: {}", refundUrl, bizContent.toString());
            try {
                MPNG020701ResponseV1 response = client.execute(request,UUID.randomUUID().toString().replace("-", ""));
                log.debug("请求结果：" + response);
                if (response.isSuccess()) {
                    if ("S".equals(response.getRspHead().getResponseStatus()) || "P".equals(response.getRspHead().getResponseStatus())) {
                        result.put("result_msg", "退款中");
                        result.put("trade_state", "SUCCESS");
                        this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='退款中', f_refund_id = '"+ txnOrderId+"' where id = '" + id + "'");
                    } else {
                        result.put("fail_msg", response.getRspHead().getResponseMsg());
                        result.put("result_msg", "退款失败");
                        result.put("trade_state", "FAIL");
                    }
                } else {
                    result.put("fail_msg", response.getRspHead().getResponseMsg());
                    result.put("result_msg", "退款失败");
                    result.put("trade_state", "FAIL");
                }
            } catch (Exception var9) {
                var9.printStackTrace();
            }
        } catch (Exception e) {
            log.debug("永州交行退款异常错误", e);
        }
        return result.toString();
    }


    /**
     * 查询订单是否退款成功
     *
     * @param value
     * @return 订单退款结果
     */
    @Override
    public String refundOrderStatus(String value) {
        JSONObject result = new JSONObject();
        try {
            log.debug("主动查询退款订单 >>> " + value);
            JSONObject jsonObject = new JSONObject(value);
            JSONObject wxConfig = Config.getConfig(jsonObject.getString("f_filiale"));
            String APP_ID = wxConfig.getString("APP_ID");
            String MCH_ID = wxConfig.getString("MCH_ID");
            String MY_PRIVATE_KEY = wxConfig.getString("MY_PRIVATE_KEY");
            String APIGW_PUBLIC_KEY = wxConfig.getString("APIGW_PUBLIC_KEY");
            // 商户订单号
            String outTradeNo = jsonObject.getString("out_trade_no");
            String refundId = jsonObject.getString("f_refund_id");
            Integer id = jsonObject.getInt("id");

            // 下单地址
            String queryUrl = wxConfig.getString("queryRefundUrl");
            DefaultBocomClient client = new DefaultBocomClient(APP_ID, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
            /**
             * 测试环境可以忽略SSL证书告警，生产环境不可忽略
             */
            client.ignoreSSLHostnameVerifier();

            MPNG020703RequestV1 request = new MPNG020703RequestV1();
            request.setServiceUrl(queryUrl);

            MPNG020703RequestV1.MPNG020703RequestV1Biz bizContent = new MPNG020703RequestV1.MPNG020703RequestV1Biz();
            MPNG020703RequestV1.MPNG020703RequestV1Biz.ReqHead reqHead = new MPNG020703RequestV1.MPNG020703RequestV1Biz.ReqHead();
            bizContent.setReqHead(reqHead);
            reqHead.setTransTime(new DateTime().toString("yyyyMMddHHmmss"));
            reqHead.setVersion("1.0");
            MPNG020703RequestV1.MPNG020703RequestV1Biz.ReqBody reqBody = new MPNG020703RequestV1.MPNG020703RequestV1Biz.ReqBody();
            bizContent.setReqBody(reqBody);
            reqBody.setPartnerId("");
            reqBody.setTranScene("B2C-PREPAYJSAPI-WECHAT");
            reqBody.setRefundMerTranNo(refundId);
            reqBody.setMerPtcId(MCH_ID);
            reqBody.setMerRefundDate(new SimpleDateFormat("yyyyMMdd").format(new Date()));
            reqBody.setSysOrderNo("");
            request.setBizContent(bizContent);
            log.debug("永州交行退款结果查询地址: {},查询参数: {}", queryUrl, bizContent.toString());

            try {
                MPNG020703ResponseV1 response = client.execute(request,UUID.randomUUID().toString().replace("-", ""));
                log.debug("永州交行退款结果查询返回信息: {}", response.toString());
                if (response.isSuccess()) {
                    if ("S".equals(response.getRspHead().getResponseStatus()) || "P".equals(response.getRspHead().getResponseStatus())) {
                        MPNG020703ResponseV1.RspBody rspBody = response.getRspBody();
                        String orderStatus = rspBody.getOrderStatus();
                        String tranStateMsg = rspBody.getTranStateMsg();
                        if ("REFUNDALL".equals(orderStatus)) {
                            this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已退款' where id = '" + id + "'");
                            this.sqlServer.runSQL("update t_bank_payment set f_state ='无效' where f_trade_number = '"+ jsonObject.getString("out_trade_no") +"'");
                            result.put("result_msg", "退款成功");
                            // 订单号
                            result.put("out_trade_no", outTradeNo);
                            result.put("f_refund_id", refundId);
                            // 交易日期
                            result.put("time_end", response.getRspHead().getResponseTime());
                            log.debug(result.toString());
                        } else {
                            result.put("fail_msg", tranStateMsg);
                            result.put("return_msg", "退款处理中");
                            result.put("trade_state", "FAIL");
                            log.debug("订单状态不等于全部退款：" + orderStatus);
                        }
                    } else {
                        result.put("return_msg", response.getRspHead().getResponseMsg());
                        result.put("trade_state", "FAIL");
                        log.debug("查询失败", response.getRspHead().getResponseMsg());
                    }
                } else {
                    this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                    result.put("trade_state", "FAIL");
                    result.put("return_msg", "退款失败");
                }
            } catch (Exception var9) {
                this.sqlServer.runSQL("update t_weixinreturnxml set f_order_state ='已支付' where id = '" + id + "'");
                log.error("操作失败：原因" + var9.getMessage());
                result.put("return_msg", "系统异常");
                var9.printStackTrace();
            }
        } catch (Exception e) {
            result.put("return_msg", "查询失败");
            log.debug("永州交行退款查询订单异常：" + e);
        }
        return result.toString();
    }

    @Override
    public JSONObject getRecordFile(JSONObject json) {
        String filiale = json.getString("f_filiale");
        if (filiale == null || filiale.length() == 0) {
            throw new NullPointerException("公司信息不能为空！");
        }
        JSONObject wxConfig = Config.getConfig(filiale);
        JSONObject result = new JSONObject();
        try {
            String APP_ID = wxConfig.getString("APP_ID");
            String MY_PRIVATE_KEY = wxConfig.getString("MY_PRIVATE_KEY");
            String APIGW_PUBLIC_KEY = wxConfig.getString("APIGW_PUBLIC_KEY");
            String MCH_ID = wxConfig.getString("MCH_ID");
            String getFileUrl =  wxConfig.getString("getFileUrl");
            // 对账文件下载地址
            String mendRecordPath = Config.wechatConfig.getString("mendRecordPath");
            DefaultBocomClient client = new DefaultBocomClient(APP_ID, MY_PRIVATE_KEY, APIGW_PUBLIC_KEY);
            DownloadNewPosStmtRequestV1 request = new DownloadNewPosStmtRequestV1();
            request.setServiceUrl(getFileUrl);
            request.setDownloadPath(mendRecordPath);
            // 默认是查前一天
            Calendar cal = Calendar.getInstance();
            cal.add(Calendar.DATE,-1);
            String billdate = new SimpleDateFormat( "yyyy-MM-dd").format(cal.getTime());
            DownloadNewPosStmtRequestV1.DownloadNewPosStmtRequestV1Biz downloadNewPosStmtRequestV1Biz = new DownloadNewPosStmtRequestV1.DownloadNewPosStmtRequestV1Biz();
            downloadNewPosStmtRequestV1Biz.setTemplateNo("02");
            // 商户号
            downloadNewPosStmtRequestV1Biz.setMerchCode(MCH_ID);
            downloadNewPosStmtRequestV1Biz.setIsvNo("");
            downloadNewPosStmtRequestV1Biz.setStmtDate(billdate);
            request.setBizContent(downloadNewPosStmtRequestV1Biz);
            log.debug("永州交行下载对账文件地址: {},参数: {}", getFileUrl, downloadNewPosStmtRequestV1Biz.toString());
            try {
                DownloadNewPosStmtResponseV1 response = client.execute(request, UUID.randomUUID().toString().replace("-", ""));
                log.debug("永州交行对账文件下载返回信息: {}", response.toString());
                response.setFilePath(mendRecordPath);
                if (response.isSuccess()) {
                    result.put("status", "success");
                    result.put("respMsg", response.getRspMsg());
                    log.debug("永州交行下载对账文件成功：{}", response.getRspMsg());
                } else {
                    result.put("status", "fail");
                    result.put("respMsg", response.getRspMsg());
                    log.debug("永州交行下载对账文件失败：{}", response.getRspMsg());
                }

            } catch (Exception e) {
                result.put("status", "fail");
                result.put("respMsg", e.getMessage());
                log.debug("永州交行下载对账文件异常：" + e.getMessage());
            }
        } catch (Exception e) {
            result.put("status", "fail");
            result.put("respMsg", e);
            log.debug("永州交行下载对账文件", e);
        }
        return null;
    }
}
