package com.aote.webmeter.module.main.yintongtcp;

import com.af.plugins.DateTools;
import com.aote.webmeter.module.main.cangnansystem.Tool;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class Tools {
    private static final Logger log = Logger.getLogger(Tool.class);

    public static String getRequestConnect(){
        String version = WebMeterInfo.getString("versionStr");
        return EntontechGas.getRequestConnect(version,Models.createNonceString(), DateTools.getNow("yyMMddHHmmss"));
    }

    public static String getHeartbeatPacket(){
        String version = WebMeterInfo.getString("versionStr");
        return EntontechGas.getHeartbeatPacket(version,Models.createNonceString());
    }

    public static String getMeterReading(){
        String version = WebMeterInfo.getString("versionStr");
        return EntontechGas.getMeterReading(version, Models.createNonceString());
    }

    public static String getDepositedAmountCmd(JSONObject object){
        return EntontechGas.getDepositedAmountCmd(
                object.getString("hascode"),
                Models.createNonceString(),
                WebMeterInfo.getString("versionStr"),
                object.getInt("money")
        );
    }

    public static String getSyncBalance(JSONObject object){
        return EntontechGas.getBindPermission(
                object.getString("hascode"),
                object.getInt("money"),
                Models.createNonceString(),
                object.getInt("price")
        );
    }

    public static String getStepData(JSONObject object){
        return EntontechGas.getStepData(
                object.getString("hascode"),
                Models.createNonceString(),
                WebMeterInfo.getString("versionStr"),
                Integer.parseInt(object.getString("step")),
                Double.parseDouble(object.getString("amountLadder1")),
                Double.parseDouble(object.getString("price1")),
                Double.parseDouble(object.getString("amountLadder2")),
                Double.parseDouble(object.getString("price2")),
                Double.parseDouble(object.getString("amountLadder3")),
                Double.parseDouble(object.getString("price3")),
                Double.parseDouble(object.getString("amountLadder4")),
                Double.parseDouble(object.getString("price4"))
        );
    }

    public static String getValveControlData(JSONObject object){
        return EntontechGas.getValveControlData(
                WebMeterInfo.getString("versionStr"),
                object.getString("hascode"),
                Models.createNonceString(),
                object.getString("valvefun")
        );
    }

    public static JSONObject decode(String hexStr) throws Exception {
        JSONObject result;
        //控制码
        String code = hexStr.substring(12,14);
        log.debug("解析控制码：" + code);
        switch (code){
            case "A0" :
                result = new JSONObject(AnalysisResult.getConnectAnalysis(hexStr));
                break;
            case "A2" :
                result = new JSONObject(AnalysisResult.MeterReadReback(hexStr));
                break;
            case "A5" :
                result = new JSONObject(AnalysisResult.getValveAnalysis(hexStr));
                break;
            case "A6" :
                result = new JSONObject(AnalysisResult.getBindPermissionAnalysis(hexStr));
                break;
            case "E0" :
                result = new JSONObject(AnalysisResult.HeartReback(hexStr));
                break;
            default:
                result = new JSONObject(AnalysisResult.getStepDataAnalysis(hexStr));
        }
        result.put("code",code);
        return result;
    }

    public static void main(String[] args) {
        try {
            JSONObject object = decode("EE003A000000A200010A09120072027995070000040000000000000000000000584D0000000000000000000057005700570004003F1A300A000000000000000200D2DD");
            System.out.println(object);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
