//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.aote.webmeter.module.main.yintongtcp;

import java.security.SecureRandom;
import java.util.Random;

public class Models {
    public Models() {
    }

    public static String StringGroup(int Way, String noncestr, String code, String data) {
        StringBuilder sb = new StringBuilder();
        sb.append("EE");
        sb.append("0").append(Way);
        int leng = data.length() / 2;
        String lenstr = Integer.toHexString(leng);
        String lenhex = createFrameLen(lenstr);
        sb.append(lenhex);
        sb.append(noncestr.substring(2));
        sb.append(noncestr, 0, 2);
        sb.append(code);
        sb.append(data);
        String hexsum = HexSumToCheck(sb.substring(2));
        sb.append(hexsum);
        sb.append("DD");
        return sb.toString().toUpperCase();
    }

    public static String HexSumToCheck(String sumstr) {
        int num = 0;
        int count = sumstr.length() / 2;

        int mod;
        for(mod = 0; mod < count; ++mod) {
            num += Integer.parseInt(sumstr.substring(mod * 2, mod * 2 + 2), 16);
        }

        mod = num % 256;
        return Integer.toHexString(mod);
    }

    public static String GenerateNonceStr(int count) {
        String SYMBOLS = "0123456789abcdef";
        Random RANDOM = new SecureRandom();
        char[] nonceChars = new char[count];

        for(int index = 0; index < nonceChars.length; ++index) {
            nonceChars[index] = SYMBOLS.charAt(RANDOM.nextInt(SYMBOLS.length()));
        }

        return new String(nonceChars);
    }

    public static String AnalysisPublic(String source) throws Exception {
        source = source.toUpperCase();
        if (source.startsWith("EE") && source.endsWith("DD")) {
            return source.substring(14, source.length() - 4);
        } else {
            throw new Exception("数据格式不正确");
        }
    }

    public static String createVersion(String versionstr) {
        if (versionstr.length() < 4) {
            int len = 4 - versionstr.length();

            StringBuilder versionstrBuilder = new StringBuilder(versionstr);
            for(int j = 0; j < len; ++j) {
                versionstrBuilder.insert(0, "0");
            }
            versionstr = versionstrBuilder.toString();
        }

        return versionstr;
    }

    public static String createNonceStr(String Hex) {
        int len = Hex.length();
        String result;
        switch(len) {
        case 1:
            result = "0" + Hex + "00";
            break;
        case 2:
            result = Hex + "00";
            break;
        case 3:
            result = "0" + Hex;
            break;
        case 4:
            result = Hex.substring(2, 4) + Hex.substring(0, 2);
            break;
        default:
            result = Hex.substring(Hex.length() - 4);
            result = result.subSequence(2, 4) + result.substring(0, 2);
        }

        return result;
    }

    public static String createNonceStr(int nonce) {
        String Hex = Integer.toHexString(nonce);
        int len = Hex.length();
        String result;
        switch(len) {
        case 1:
            result = "0" + Hex + "00";
            break;
        case 2:
            result = Hex + "00";
            break;
        case 3:
            result = "0" + Hex;
            break;
        case 4:
            result = Hex.substring(2, 4) + Hex.substring(0, 2);
            break;
        default:
            result = Hex.substring(Hex.length() - 4);
            result = result.subSequence(2, 4) + result.substring(0, 2);
        }

        return result;
    }

    public static String createNonceString() {
        return GenerateNonceStr(4);
    }

    public static String createFrameLen(String HexLen) {
        int len = HexLen.length();
        String hex = null;
        switch(len) {
        case 0:
            hex = "0000";
            break;
        case 1:
            hex = "0" + HexLen + "00";
            break;
        case 2:
            hex = HexLen + "00";
            break;
        case 3:
            hex = HexLen.substring(1) + "0" + HexLen.charAt(0);
            break;
        case 4:
            hex = HexLen.substring(2) + HexLen.substring(0, 2);
        }

        return hex;
    }

    public static String createDeposit(String depositHex, int money) {
        System.out.println("数据源：" + depositHex);
        int leng = (int)Math.ceil((double)depositHex.length() / 2.0D);
        StringBuilder sBuilder = new StringBuilder();

        for(int i = leng; i > 0; --i) {
            if (depositHex.length() == leng * 2) {
                sBuilder.append(depositHex.substring(i * 2 - 2, i * 2));
            } else if (i * 2 - 3 < 0) {
                sBuilder.append("0").append(depositHex.substring(0, i * 2 - 1));
            } else {
                sBuilder.append(depositHex.substring(i * 2 - 3, i * 2 - 1));
            }
        }

        String result = sBuilder.toString();
        if (result.length() < 16) {
            int minlen = 16 - result.length();
            int i;
            if (money < 0) {
                for(i = 0; i < minlen; ++i) {
                    sBuilder.append("f");
                }
            } else {
                for(i = 0; i < minlen; ++i) {
                    sBuilder.append("0");
                }
            }
        }

        return sBuilder.toString();
    }

    public static String createPrice(int price) {
        String hex = Integer.toHexString(price);
        int len = hex.length();
        String result;
        switch(len) {
        case 1:
            result = "0" + hex + "00";
            break;
        case 2:
            result = hex + "00";
            break;
        case 3:
            result = hex.substring(1) + "0" + hex.charAt(0);
            break;
        case 4:
            result = hex.substring(2) + hex.substring(0, 2);
            break;
        default:
            result = hex.substring(hex.length() - 4);
        }

        return result;
    }

    public static String createTwoByte(int twoNumber) {
        String hex = Integer.toHexString(twoNumber);
        int len = hex.length();
        String result;
        switch(len) {
        case 1:
            result = "0" + hex + "00";
            break;
        case 2:
            result = hex + "00";
            break;
        case 3:
            result = hex.substring(1) + "0" + hex.charAt(0);
            break;
        case 4:
            result = hex.substring(2) + hex.substring(0, 2);
            break;
        default:
            result = hex.substring(hex.length() - 4);
        }

        return result;
    }

    public static String createFourByte(int fourNumber, int numberofbytes) {
        String hex = Integer.toHexString(fourNumber);
        int len = hex.length();
        if (len % 2 != 0) {
            hex = "0" + hex;
        }

        StringBuilder result = new StringBuilder();
        String[] temparr = StringUtils.SubSplit(hex, 2);

        int gap;
        for(gap = 0; gap < temparr.length; ++gap) {
            result.insert(0, temparr[gap]);
        }

        gap = numberofbytes * 2 - result.length();

        for(int i = 0; i < gap; ++i) {
            result.append("0");
        }

        return result.toString();
    }

    public static String CreateOneByte(int sbyte) {
        String hex = Integer.toHexString(sbyte);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }

        return hex;
    }
}
