//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.aote.webmeter.module.main.yintongtcp;

public class EntontechGas {
    public EntontechGas() {
    }

    public static String getRequestConnect(String version, String noncestr, String datetime) {
        String ver = Models.createVersion(version);
        String data = ver + datetime;
        String nonce = Models.createNonceStr(noncestr);
        return Models.StringGroup(1, nonce, "A1", data).toUpperCase();
    }

    public static String getMeterReading(String version, String noncestr) {
        String ver = Models.createVersion(version);
        String nonce = Models.createNonceStr(noncestr);
        return Models.StringGroup(1, nonce, "A2", ver);
    }

    public static String getDepositedAmountCmd(String hascode, String noncestr, String versionstr, int money) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String ver = Models.createVersion(versionstr);
            String nonce = Models.createNonceStr(noncestr);
            String deposit = Integer.toHexString(money);
            String MoneyHex = Models.createDeposit(deposit, money);
            String data = ver + "0" + hascode + MoneyHex;
            return Models.StringGroup(1, nonce, "A3", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getStepData(String hascode, String noncestr, String versionstr, int step, double amountLadder1, double price1, double amountLadder2, double price2, double amountLadder3, double price3, double amountLadder4, double price4) {
        if (!StringUtils.IsBit(step)) {
            return "阶梯方式 只能是0或者1：0 代表月度 ，1 代表年度";
        } else {
            String pattern = "^[A-F]{1}[0-9]{14}$";
            if (hascode.matches(pattern)) {
                String nonce = Models.createNonceStr(noncestr);
                String ver = Models.createVersion(versionstr);
                String stepHex = "0" + step;
                String amountLadder1Hex = Models.createFourByte((int)amountLadder1 * 10000, 4);
                String priceHex1 = Models.createTwoByte((int)price1 * 100);
                String amountLadder2Hex = Models.createFourByte((int)amountLadder2 * 10000, 4);
                String priceHex2 = Models.createTwoByte((int)price2 * 100);
                String amountLadder3Hex = Models.createFourByte((int)amountLadder3 * 10000, 4);
                String priceHex3 = Models.createTwoByte((int)price3 * 100);
                String amountLadder4Hex = Models.createFourByte((int)amountLadder4 * 10000, 4);
                String priceHex4 = Models.createTwoByte((int)price4 * 100);
                String data = ver + "0" + hascode + stepHex + amountLadder1Hex + priceHex1 + amountLadder2Hex + priceHex2 + amountLadder3Hex + priceHex3 + amountLadder4Hex + priceHex4;
                return Models.StringGroup(1, nonce, "A4", data);
            } else {
                return "15位表号输入不正确";
            }
        }
    }

    public static String getValveControlData(String versionstr, String hascode, String noncestr, String valvefun) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String ver = Models.createVersion(versionstr);
            String data = ver + "0" + hascode + valvefun;
            String nonce = Models.createNonceStr(noncestr);
            return Models.StringGroup(1, nonce, "A5", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getBindPermission(String hascode, int money, int nonce, int price) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String noncestr = Models.createNonceStr(nonce);
            String deposit = Integer.toHexString(money);
            String MoneyHex = Models.createDeposit(deposit, money);
            String pricehex = Models.createPrice(price);
            String data = "00010" + hascode + MoneyHex + pricehex;
            return Models.StringGroup(1, noncestr, "A6", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getBindPermission(String hascode, int money, String noncestr, int price) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String nonce = Models.createNonceStr(noncestr);
            String deposit = Integer.toHexString(money);
            String MoneyHex = Models.createDeposit(deposit, money);
            String pricehex = Models.createPrice(price);
            String data = "00010" + hascode + MoneyHex + pricehex;
            return Models.StringGroup(1, nonce, "A6", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getHeartbeatPacket(String version, String noncestr) {
        String ver = Models.createVersion(version);
        String nonce = Models.createNonceStr(noncestr);
        return Models.StringGroup(1, nonce, "E1", ver);
    }
}
