//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.aote.webmeter.module.main.yintongtcp;

class Back {
    Back() {
    }

    public static String getAnalysisConnectReback(String SourceHex) {
        try {
            SourceHex = Models.AnalysisPublic(SourceHex);
            String v1 = SourceHex.substring(0, 4);
            int ver = Integer.parseInt(v1, 16);
            String version = Integer.toString(ver);
            String str = SourceHex.substring(4);
            StringBuilder sb = new StringBuilder();
            sb.append("20" + str.substring(0, 2) + "-");
            sb.append(str.substring(2, 4) + "-");
            sb.append(str.substring(4, 6) + " ");
            sb.append(str.substring(6, 8) + ":");
            sb.append(str.substring(8, 10) + ":");
            sb.append(str.substring(10, 12));
            return "{\"version\":\"" + version + "\",\"datetime\":\"" + sb.toString() + "\"}";
        } catch (Exception var6) {
            return null;
        }
    }

    public static String HeartReback(String SourceHex) throws Exception {
        try {
            SourceHex = Models.AnalysisPublic(SourceHex);
            if (SourceHex.length() == 4) {
                int i = Integer.parseInt(SourceHex);
                return "{\"version\":\"" + Integer.toString(i) + "\"}";
            } else {
                return "{\"version\":\"\"}";
            }
        } catch (Exception var2) {
            throw var2;
        }
    }

    public static String getConnectHexCode(String version, String noncestr, String hascode) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String ver = Models.createVersion(version);
            String data = ver + "0" + hascode;
            String nonce = Models.createNonceStr(noncestr);
            return Models.StringGroup(0, nonce, "A0", data).toUpperCase();
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getConnectHexCode(String hascode, String noncestr) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String data = "00010" + hascode;
            String nonce = Models.createNonceStr(noncestr);
            return Models.StringGroup(0, nonce, "A0", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getDeposited(String hascode, String noncestr, int version, int money) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String versionstr = Integer.toHexString(version);
            String ver = Models.createVersion(versionstr);
            String nonce = Models.createNonceStr(noncestr);
            String deposit = Integer.toHexString(money);
            String MoneyHex = Models.createDeposit(deposit, money);
            String data = ver + "0" + hascode + MoneyHex;
            return Models.StringGroup(1, nonce, "A3", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getOpenValve(String hascode, String noncestr) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String data = "00010" + hascode + "02";
            String nonce = Models.createNonceStr(noncestr);
            return Models.StringGroup(1, nonce, "A5", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getOpenValve(String versionstr, String hascode, String noncestr) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String ver = Models.createVersion(versionstr);
            String data = ver + "0" + hascode + "02";
            String nonce = Models.createNonceStr(noncestr);
            return Models.StringGroup(1, nonce, "A5", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getCloseValve(String hascode, String noncestr) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String data = "00010" + hascode + "01";
            String nonce = Models.createNonceStr(noncestr);
            return Models.StringGroup(1, nonce, "A5", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getCloseValve(String versionstr, String hascode, String noncestr) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String ver = Models.createVersion(versionstr);
            String data = ver + "0" + hascode + "01";
            String nonce = Models.createNonceStr(noncestr);
            return Models.StringGroup(1, nonce, "A5", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getWarnCloseValve(String hascode, String noncestr) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String data = "00010" + hascode + "03";
            String nonce = Models.createNonceStr(noncestr);
            return Models.StringGroup(1, nonce, "A5", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getWarnCloseValve(String versionstr, String hascode, String noncestr) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String ver = Models.createVersion(versionstr);
            String data = ver + "0" + hascode + "03";
            String nonce = Models.createNonceStr(noncestr);
            return Models.StringGroup(1, nonce, "A5", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getValve(String versionstr, String hascode, String noncestr) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String ver = Models.createVersion(versionstr);
            String data = ver + "0" + hascode + "03";
            String nonce = Models.createNonceStr(noncestr);
            return Models.StringGroup(1, nonce, "A5", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getheartbeat(String versionstr, String noncestr, String voltage) {
        String ver = Models.createVersion(versionstr);
        String data = ver + voltage;
        String nonce = Models.createNonceStr(noncestr);
        return Models.StringGroup(0, nonce, "E0", data);
    }

    public static String getheartbeat(String noncestr, String voltage) {
        String data = "0001" + voltage;
        String nonce = Models.createNonceStr(noncestr);
        return Models.StringGroup(0, nonce, "E0", data);
    }

    public static String getDeposited(String hascode, int nonce, int version, int money) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String versionstr = Integer.toHexString(version);
            String ver = Models.createVersion(versionstr);
            String noncestr = Models.createNonceStr(nonce);
            String deposit = Integer.toHexString(money);
            String MoneyHex = Models.createDeposit(deposit, money);
            String data = ver + "0" + hascode + MoneyHex;
            return Models.StringGroup(1, noncestr, "A3", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getDeposited(String hascode, int nonce, int money) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String noncestr = Models.createNonceStr(nonce);
            String deposit = Integer.toHexString(money);
            String MoneyHex = Models.createDeposit(deposit, money);
            String data = "00010" + hascode + MoneyHex;
            return Models.StringGroup(1, noncestr, "A3", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getBindPermission(String hascode, int money, int nonce, int price) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String noncestr = Models.createNonceStr(nonce);
            String deposit = Integer.toHexString(money);
            String MoneyHex = Models.createDeposit(deposit, money);
            String pricehex = Models.createPrice(price);
            String data = "00010" + hascode + MoneyHex + pricehex;
            return Models.StringGroup(1, noncestr, "A6", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getBindPermission(String hascode, int money, String noncestr, int price) {
        String pattern = "^[A-F]{1}[0-9]{14}$";
        if (hascode.matches(pattern)) {
            String nonce = Models.createNonceStr(noncestr);
            String deposit = Integer.toHexString(money);
            String MoneyHex = Models.createDeposit(deposit, money);
            String pricehex = Models.createPrice(price);
            String data = "00010" + hascode + MoneyHex + pricehex;
            return Models.StringGroup(1, nonce, "A6", data);
        } else {
            return "15位表号输入不正确";
        }
    }

    public static String getModifyConfig(int way, String hascode, String noncestr, int dayover, int monover, int warnclosingvalve, int Mandatoryclosingvalve, int FlowSwitch, int warnreport, int mandareport, int daymax, int monmax, int temperature, int communication, int usegas, int alarm1, int alarm4, int flow, int reportset, int angleset) {
        if (temperature < 55) {
            return "触发温度设定值不能低于 55";
        } else if (communication < 7) {
            return "未通信天数设定值不能小于 7";
        } else if (usegas < 7) {
            return "未用气天数设定值不能小于 7";
        } else if (reportset >= 7 && reportset <= 24) {
            if (angleset < 10) {
                return "触发角度设定值,不能低于 10";
            } else if (!StringUtils.IsBit(way)) {
                return "路径只有0与1，请重新填写，1为服务器至表，0为表至服务器";
            } else if (StringUtils.IsBit(dayover) && StringUtils.IsBit(monover) && StringUtils.IsBit(warnclosingvalve) && StringUtils.IsBit(Mandatoryclosingvalve) && StringUtils.IsBit(FlowSwitch) && StringUtils.IsBit(warnreport) && StringUtils.IsBit(mandareport)) {
                String bstr = String.valueOf(dayover) + monover + warnclosingvalve + Mandatoryclosingvalve + FlowSwitch + "0" + warnreport + mandareport;
                int bit = Integer.parseInt(bstr, 2);
                String hex1 = Integer.toHexString(bit);
                String pattern = "^[A-F]{1}[0-9]{14}$";
                if (hascode.matches(pattern)) {
                    String nonce = Models.createNonceStr(noncestr);
                    String daymaxHex = Models.createTwoByte(daymax);
                    String monmaxHex = Models.createFourByte(monmax, 4);
                    String temperHex = Integer.toHexString(temperature);
                    String communicationHex = Integer.toHexString(communication);
                    if (communicationHex.length() == 1) {
                        communicationHex = "0" + communicationHex;
                    }

                    String usegasHex = Integer.toHexString(usegas);
                    if (usegasHex.length() == 1) {
                        usegasHex = "0" + usegasHex;
                    }

                    String getalarmHex1 = Models.createFourByte(alarm1, 4);
                    String getalarmHex4 = Models.createFourByte(alarm4, 4);
                    String flowHex = Models.CreateOneByte(flow);
                    String reportHex = Models.CreateOneByte(reportset);
                    String angleHex = Models.CreateOneByte(angleset);
                    String data = "00010" + hascode + hex1 + daymaxHex + monmaxHex + temperHex + communicationHex + usegasHex + getalarmHex1 + getalarmHex4 + flowHex + reportHex + angleHex;
                    return Models.StringGroup(way, nonce, "A7", data);
                } else {
                    return "15位表号输入不正确";
                }
            } else {
                return "bit 值只能是0与1";
            }
        } else {
            return "上报周期 1小时为单位设定值不能小于 1 或大于 24";
        }
    }

    public static String getModifyConfig(int way, String hascode, String noncestr, int version, int dayover, int monover, int warnclosingvalve, int Mandatoryclosingvalve, int FlowSwitch, int warnreport, int mandareport, int daymax, int monmax, int temperature, int communication, int usegas, int alarm1, int alarm4, int flow, int reportset, int angleset) {
        if (temperature < 55) {
            return "触发温度设定值不能低于 55";
        } else if (communication < 7) {
            return "未通信天数设定值不能小于 7";
        } else if (usegas < 7) {
            return "未用气天数设定值不能小于 7";
        } else if (reportset >= 7 && reportset <= 24) {
            if (angleset < 10) {
                return "触发角度设定值,不能低于 10";
            } else if (!StringUtils.IsBit(way)) {
                return "路径只有0与1，请重新填写，1为服务器至表，0为表至服务器";
            } else if (StringUtils.IsBit(dayover) && StringUtils.IsBit(monover) && StringUtils.IsBit(warnclosingvalve) && StringUtils.IsBit(Mandatoryclosingvalve) && StringUtils.IsBit(FlowSwitch) && StringUtils.IsBit(warnreport) && StringUtils.IsBit(mandareport)) {
                String bstr = String.valueOf(dayover) + monover + warnclosingvalve + Mandatoryclosingvalve + FlowSwitch + "0" + warnreport + mandareport;
                int bit = Integer.parseInt(bstr, 2);
                String hex1 = Integer.toHexString(bit);
                String pattern = "^[A-F]{1}[0-9]{14}$";
                if (hascode.matches(pattern)) {
                    String versionstr = Integer.toHexString(version);
                    String ver = Models.createVersion(versionstr);
                    String nonce = Models.createNonceStr(noncestr);
                    String daymaxHex = Models.createTwoByte(daymax);
                    String monmaxHex = Models.createFourByte(monmax, 4);
                    String temperHex = Integer.toHexString(temperature);
                    String communicationHex = Integer.toHexString(communication);
                    if (communicationHex.length() == 1) {
                        communicationHex = "0" + communicationHex;
                    }

                    String usegasHex = Integer.toHexString(usegas);
                    if (usegasHex.length() == 1) {
                        usegasHex = "0" + usegasHex;
                    }

                    String getalarmHex1 = Models.createFourByte(alarm1, 4);
                    String getalarmHex4 = Models.createFourByte(alarm4, 4);
                    String flowHex = Models.CreateOneByte(flow);
                    String reportHex = Models.CreateOneByte(reportset);
                    String angleHex = Models.CreateOneByte(angleset);
                    String data = ver + "0" + hascode + hex1 + daymaxHex + monmaxHex + temperHex + communicationHex + usegasHex + getalarmHex1 + getalarmHex4 + flowHex + reportHex + angleHex;
                    return Models.StringGroup(way, nonce, "A7", data);
                } else {
                    return "15位表号输入不正确";
                }
            } else {
                return "bit 值只能是0与1";
            }
        } else {
            return "上报周期 1小时为单位设定值不能小于 1 或大于 24";
        }
    }

    public static String getChangeConfiguration(int way, String hascode, String noncestr, String valve) {
        if (!StringUtils.IsBit(way)) {
            return "路径只有0与1，请重新填写，1为服务器至表，0为表至服务器";
        } else {
            String pattern = "^[A-F]{1}[0-9]{14}$";
            if (hascode.matches(pattern)) {
                String nonce = Models.createNonceStr(noncestr);
                String data = "00010" + hascode + valve;
                return Models.StringGroup(way, nonce, "A8", data);
            } else {
                return "15位表号输入不正确";
            }
        }
    }

    public static String getChangeConfiguration(int way, String hascode, String noncestr, int version, String valve) {
        if (!StringUtils.IsBit(way)) {
            return "路径只有0与1，请重新填写，1为服务器至表，0为表至服务器";
        } else {
            String pattern = "^[A-F]{1}[0-9]{14}$";
            if (hascode.matches(pattern)) {
                String nonce = Models.createNonceStr(noncestr);
                String versionstr = Integer.toHexString(version);
                String ver = Models.createVersion(versionstr);
                String data = ver + "0" + hascode + valve;
                return Models.StringGroup(way, nonce, "A8", data);
            } else {
                return "15位表号输入不正确";
            }
        }
    }
}
