//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.aote.webmeter.module.main.yintongtcp;

import java.math.BigInteger;
import java.text.DecimalFormat;

public class AnalysisResult {
    public AnalysisResult() {
    }

    public static String getConnectAnalysis(String SourceHex) throws Exception {
        try {
            SourceHex = Models.AnalysisPublic(SourceHex);
            String v1 = SourceHex.substring(0, 4);
            int ver = Integer.parseInt(v1, 16);
            String version = Integer.toString(ver);
            String str = SourceHex.substring(4);
            return "{\"version\":\"" + version + "\",\"meterNumber\":\"" + str.substring(1) + "\"}";
        } catch (Exception var5) {
            throw var5;
        }
    }

    public static String MeterReadReback(String SourceHex) throws Exception {
        String pattern = "\\bEE[0-9A-F]{130}?DD\\b";
        DecimalFormat df = new DecimalFormat("#.00");
        boolean b = SourceHex.toUpperCase().matches(pattern);
        if (!b) {
            return "数据格式不正确";
        } else {
            SourceHex = Models.AnalysisPublic(SourceHex);
            System.out.println("SourceHex=" + SourceHex + "** SourceHex.leng=" + SourceHex.length());
            StringBuilder sb = new StringBuilder();
            String version = SourceHex.substring(0, 4);
            int i = Integer.parseInt(version, 16);
            sb.append("{");
            sb.append("\"version\":\"" + i + "\",");
            String hascode = SourceHex.substring(5, 20);
            sb.append("\"meterNumber\":\"" + hascode + "\",");
            sb.append("\"softwareVersion\":\"" + Integer.parseInt(SourceHex.substring(20, 22), 16) + "\",");
            String rnum = SourceHex.substring(24, 26) + SourceHex.substring(22, 24);
            int da = Integer.parseInt(rnum, 16);
            sb.append("\"useGasByDay\":\"" + (double)da / 100.0D + "\",");
            int sum = Integer.parseInt(SourceHex.substring(32, 34) + SourceHex.substring(30, 32) + SourceHex.substring(28, 30) + SourceHex.substring(26, 28), 16);
            sb.append("\"tableBase\":\"" + (double)sum / 100.0D + "\",");
            int mon = Integer.parseInt(SourceHex.substring(40, 42) + SourceHex.substring(38, 40) + SourceHex.substring(36, 38) + SourceHex.substring(34, 36), 16);
            sb.append("\"useGasByThisMonth\":\"" + (double)mon / 100.0D + "\",");
            int later = Integer.parseInt(SourceHex.substring(48, 50) + SourceHex.substring(46, 48) + SourceHex.substring(44, 46) + SourceHex.substring(42, 44), 16);
            sb.append("\"useGasByLastMonth\":\"" + (double)later / 100.0D + "\",");
            String amountmoney = "";
            int no = 66;

            int money;
            for(money = 0; money < 8; ++money) {
                amountmoney = amountmoney + SourceHex.substring(no - 2, no);
                no -= 2;
            }

            money = (new BigInteger(amountmoney, 16)).intValue();
            sb.append("\"money\":\"" + (double)money / 10000.0D + "\",");
            long year = Long.parseLong(SourceHex.substring(72, 74) + SourceHex.substring(70, 72) + SourceHex.substring(68, 70) + SourceHex.substring(66, 68), 16);
            sb.append("\"useGasByYear\":\"" + (double)year / 100.0D + "\",");
            int jiao = Integer.parseInt(SourceHex.substring(76, 78) + SourceHex.substring(74, 76), 16);
            sb.append("\"angleX\":\"" + jiao + "\",");
            sb.append("\"angleY\":\"" + Integer.parseInt(SourceHex.substring(80, 82) + SourceHex.substring(78, 80), 16) + "\",");
            sb.append("\"angleZ\":\"" + Integer.parseInt(SourceHex.substring(84, 86) + SourceHex.substring(82, 84), 16) + "\",");
            sb.append("\"flowmeterTemperature\":\"" + Integer.parseInt(SourceHex.substring(88, 90) + SourceHex.substring(86, 88), 16) + "\",");
            String hv = SourceHex.substring(90, 92);
            int hvDouble = Integer.parseInt(hv, 16);
            sb.append("\"batteryLevel\":\"" + df.format((double)hvDouble / 10.0D) + "\",");
            sb.append("\"signal\":\"" + Integer.parseInt(SourceHex.substring(92, 94), 16) + "\",");
            int ld = Integer.parseInt(SourceHex.substring(94, 96), 16);
            String ss = df.format((double)ld / 13.0D);
            System.out.println("ss=" + ss);
            sb.append("\"batteryLevel2\":\"" + ss + "\",");
            String binString = SourceHex.substring(96, 98);
            int binaryOne = Integer.parseInt(binString, 16);
            String binary = Integer.toString(binaryOne, 2);
            int binlen = binary.length();
            int binlengsum = 8 - binlen;
            StringBuilder binstringcode = new StringBuilder();

            for(int j = 0; j < binlengsum; ++j) {
                binstringcode.append("0");
            }

            binstringcode.append(binary);
            String valvestr = binstringcode.substring(7, 8);
            switch(valvestr.hashCode()) {
            case 48:
                if (valvestr.equals("0")) {
                    sb.append("\"valveControl\":0,");
                }
                break;
            case 49:
                if (valvestr.equals("1")) {
                    sb.append("\"valveControl\":1,");
                }
            }

            valvestr = binstringcode.substring(6, 7);
            switch(valvestr.hashCode()) {
            case 48:
                if (valvestr.equals("0")) {
                    sb.append("\"开盖状态标志\":\"开盖\",");
                }
                break;
            case 49:
                if (valvestr.equals("1")) {
                    sb.append("\"开盖状态标志\":\"关盖\",");
                }
            }

            valvestr = binstringcode.substring(4, 5);
            switch(valvestr.hashCode()) {
            case 48:
                if (valvestr.equals("0")) {
                    sb.append("\"干电状态标志\":\"碱缺\",");
                }
                break;
            case 49:
                if (valvestr.equals("1")) {
                    sb.append("\"干电状态标志\":\"存在\",");
                }
            }

            sb.append("\"noUseGasDay\":\"" + Integer.parseInt(SourceHex.substring(100, 102), 16) + "\",");
            sb.append("\"noSignalDay\":\"" + Integer.parseInt(SourceHex.substring(102, 104), 16) + "\",");
            sb.append("\"valveNoActionDay\":\"" + Integer.parseInt(SourceHex.substring(114, 116), 16) + "\"");
            sb.append("}");
            return sb.toString();
        }
    }

    public static String getDepositedRebackAnalysis(String SourceHex) throws Exception {
        try {
            SourceHex = Models.AnalysisPublic(SourceHex);
            StringBuilder sb = new StringBuilder();
            String version = SourceHex.substring(0, 4);
            int i = Integer.parseInt(version, 16);
            sb.append("{");
            sb.append("\"格式版本\":\"").append(i).append("\",");
            String hascode = SourceHex.substring(5, 20);
            sb.append("\"meterNumber\":\"").append(hascode).append("\",");
            sb.append("\"表端固件版本号\":\"").append(Integer.parseInt(SourceHex.substring(20, 22), 16)).append("\",");
            String rnum = SourceHex.substring(24, 26) + SourceHex.substring(22, 24);
            System.out.println("rnum=" + Integer.parseInt(rnum, 16));
            int da = Integer.parseInt(rnum, 16);
            sb.append("\"日用量\":\"").append((double) da / 100.0D).append("\",");
            int sum = Integer.parseInt(SourceHex.substring(32, 34) + SourceHex.substring(30, 32) + SourceHex.substring(28, 30) + SourceHex.substring(26, 28), 16);
            sb.append("\"累计量\":\"").append((double) sum / 100.0D).append("\",");
            int mon = Integer.parseInt(SourceHex.substring(40, 42) + SourceHex.substring(38, 40) + SourceHex.substring(36, 38) + SourceHex.substring(34, 36), 16);
            sb.append("\"本月用量\":\"").append((double) mon / 100.0D).append("\",");
            int later = Integer.parseInt(SourceHex.substring(48, 50) + SourceHex.substring(46, 48) + SourceHex.substring(44, 46) + SourceHex.substring(42, 44), 16);
            sb.append("\"上月用量\":\"").append((double) later / 100.0D).append("\",");
            StringBuilder amountmoney = new StringBuilder();
            int no = 66;

            int money;
            for(money = 0; money < 8; ++money) {
                amountmoney.append(SourceHex, no - 2, no);
                no -= 2;
            }

            System.out.println("amountmoney=" + amountmoney);
            money = (new BigInteger(amountmoney.toString(), 16)).intValue();
            sb.append("\"预存金额\":\"").append((double) money / 10000.0D).append("\",");
            long year = Long.parseLong(SourceHex.substring(72, 74) + SourceHex.substring(70, 72) + SourceHex.substring(68, 70) + SourceHex.substring(66, 68), 16);
            sb.append("\"年用量\":\"").append((double) year / 100.0D).append("\",");
            int ladder = Integer.parseInt(SourceHex.substring(74, 76), 16);
            sb.append("\"阶梯方式\":").append(ladder).append(",");
            int ladder1 = Integer.parseInt(SourceHex.substring(82, 84) + SourceHex.substring(80, 82) + SourceHex.substring(78, 80) + SourceHex.substring(76, 78), 16);
            sb.append("\"一阶梯量\":").append(ladder1).append(",");
            int price1 = Integer.parseInt(SourceHex.substring(86, 88) + SourceHex.substring(84, 86), 16);
            sb.append("\"一阶梯价格\":").append(price1).append(",");
            int ladder2 = Integer.parseInt(SourceHex.substring(94, 96) + SourceHex.substring(92, 94) + SourceHex.substring(90, 92) + SourceHex.substring(88, 90), 16);
            sb.append("\"二阶梯量\":").append(ladder2).append(",");
            int price2 = Integer.parseInt(SourceHex.substring(98, 100) + SourceHex.substring(96, 98), 16);
            sb.append("\"二阶梯价格\":").append(price2).append(",");
            int ladder3 = Integer.parseInt(SourceHex.substring(106, 108) + SourceHex.substring(104, 106) + SourceHex.substring(102, 104) + SourceHex.substring(100, 102), 16);
            sb.append("\"三阶梯量\":").append(ladder3).append(",");
            int price3 = Integer.parseInt(SourceHex.substring(110, 112) + SourceHex.substring(108, 110), 16);
            sb.append("\"三阶梯价格\":").append(price3).append(",");
            int ladder4 = Integer.parseInt(SourceHex.substring(118, 120) + SourceHex.substring(116, 118) + SourceHex.substring(114, 116) + SourceHex.substring(112, 114), 16);
            sb.append("\"四阶梯量\":").append(ladder4).append(",");
            int price4 = Integer.parseInt(SourceHex.substring(122, 124) + SourceHex.substring(120, 122), 16);
            sb.append("\"四阶梯价格\":").append(price4).append(",");
            return sb.toString();
        } catch (Exception var24) {
            throw var24;
        }
    }

    public static String getStepDataAnalysis(String SourceHex) throws Exception {
        try {
            SourceHex = Models.AnalysisPublic(SourceHex);
            StringBuilder sb = new StringBuilder();
            String version = SourceHex.substring(0, 4);
            int i = Integer.parseInt(version, 16);
            sb.append("{");
            sb.append("\"格式版本\":\"").append(i).append("\",");
            String hascode = SourceHex.substring(5, 20);
            sb.append("\"meterNumber\":\"" + hascode + "\",");
            sb.append("\"表端固件版本号\":\"").append(Integer.parseInt(SourceHex.substring(20, 22), 16)).append("\",");
            String rnum = SourceHex.substring(24, 26) + SourceHex.substring(22, 24);
            System.out.println("rnum=" + Integer.parseInt(rnum, 16));
            int da = Integer.parseInt(rnum, 16);
            sb.append("\"日用量\":\"").append((double) da / 100.0D).append("\",");
            int sum = Integer.parseInt(SourceHex.substring(32, 34) + SourceHex.substring(30, 32) + SourceHex.substring(28, 30) + SourceHex.substring(26, 28), 16);
            sb.append("\"累计量\":\"").append((double) sum / 100.0D).append("\",");
            int mon = Integer.parseInt(SourceHex.substring(40, 42) + SourceHex.substring(38, 40) + SourceHex.substring(36, 38) + SourceHex.substring(34, 36), 16);
            sb.append("\"本月用量\":\"").append((double) mon / 100.0D).append("\",");
            int later = Integer.parseInt(SourceHex.substring(48, 50) + SourceHex.substring(46, 48) + SourceHex.substring(44, 46) + SourceHex.substring(42, 44), 16);
            sb.append("\"上月用量\":\"").append((double) later / 100.0D).append("\",");
            String amountmoney = "";
            int no = 66;

            int money;
            for(money = 0; money < 8; ++money) {
                amountmoney = amountmoney + SourceHex.substring(no - 2, no);
                no -= 2;
            }

            System.out.println("amountmoney=" + amountmoney);
            money = (new BigInteger(amountmoney, 16)).intValue();
            sb.append("\"预存金额\":\"").append((double) money / 10000.0D).append("\",");
            long year = Long.parseLong(SourceHex.substring(72, 74) + SourceHex.substring(70, 72) + SourceHex.substring(68, 70) + SourceHex.substring(66, 68), 16);
            sb.append("\"年用量\":\"").append((double) year / 100.0D).append("\",");
            int ladder = Integer.parseInt(SourceHex.substring(74, 76), 16);
            sb.append("\"阶梯方式\":").append(ladder).append(",");
            int ladder1 = Integer.parseInt(SourceHex.substring(82, 84) + SourceHex.substring(80, 82) + SourceHex.substring(78, 80) + SourceHex.substring(76, 78), 16);
            sb.append("\"一阶梯量\":").append(ladder1).append(",");
            int price1 = Integer.parseInt(SourceHex.substring(86, 88) + SourceHex.substring(84, 86), 16);
            sb.append("\"一阶梯价格\":").append(price1).append(",");
            int ladder2 = Integer.parseInt(SourceHex.substring(94, 96) + SourceHex.substring(92, 94) + SourceHex.substring(90, 92) + SourceHex.substring(88, 90), 16);
            sb.append("\"二阶梯量\":").append(ladder2).append(",");
            int price2 = Integer.parseInt(SourceHex.substring(98, 100) + SourceHex.substring(96, 98), 16);
            sb.append("\"二阶梯价格\":").append(price2).append(",");
            int ladder3 = Integer.parseInt(SourceHex.substring(106, 108) + SourceHex.substring(104, 106) + SourceHex.substring(102, 104) + SourceHex.substring(100, 102), 16);
            sb.append("\"三阶梯量\":").append(ladder3).append(",");
            int price3 = Integer.parseInt(SourceHex.substring(110, 112) + SourceHex.substring(108, 110), 16);
            sb.append("\"三阶梯价格\":").append(price3).append(",");
            int ladder4 = Integer.parseInt(SourceHex.substring(118, 120) + SourceHex.substring(116, 118) + SourceHex.substring(114, 116) + SourceHex.substring(112, 114), 16);
            sb.append("\"四阶梯量\":").append(ladder4).append(",");
            int price4 = Integer.parseInt(SourceHex.substring(122, 124) + SourceHex.substring(120, 122), 16);
            sb.append("\"四阶梯价格\":").append(price4).append(",");
            return sb.toString();
        } catch (Exception var24) {
            throw var24;
        }
    }

    public static String getValveAnalysis(String SourceHex) throws Exception {
        try {
            SourceHex = Models.AnalysisPublic(SourceHex);
            StringBuilder sb = new StringBuilder();
            String version = SourceHex.substring(0, 4);
            int i = Integer.parseInt(version, 16);
            sb.append("{");
            sb.append("\"格式版本\":\"").append(i).append("\",");
            String hascode = SourceHex.substring(5, 20);
            sb.append("\"meterNumber\":\"").append(hascode).append("\",");
            sb.append("\"表端固件版本号\":\"").append(Integer.parseInt(SourceHex.substring(20, 22), 16)).append("\",");
            sb.append("\"state\":{");
            String valString = SourceHex.substring(22, 23);
            int valOne = Integer.parseInt(valString, 16);
            String binary = Integer.toString(valOne, 2);
            int bitlen = 8 - binary.length();
            StringBuilder bitsbBuilder = new StringBuilder();

            for(int j = 0; j < bitlen; ++j) {
                bitsbBuilder.append("0");
            }

            bitsbBuilder.append(binary);
            System.out.println("bitsbBuilder=" + bitsbBuilder.toString());
            String bitvals = bitsbBuilder.substring(7, 8);
            switch(bitvals.hashCode()) {
            case 48:
                if (bitvals.equals("0")) {
                    sb.append("\"阀门状态标志\":\"已开\",");
                }
                break;
            case 49:
                if (bitvals.equals("1")) {
                    sb.append("\"阀门状态标志\":\"已关\",");
                }
            }

            bitvals = bitsbBuilder.substring(6, 7);
            switch(bitvals.hashCode()) {
                case 48:
                    if (bitvals.equals("0")) {
                        sb.append("\"开盖状态标志\":\"开盖\",");
                    }
                    break;
                case 49:
                    if (bitvals.equals("1")) {
                        sb.append("\"开盖状态标志\":\"关盖\",");
                    }
            }

            bitvals = bitsbBuilder.substring(4, 5);
            switch(bitvals.hashCode()) {
                case 48:
                    if (bitvals.equals("0")) {
                        sb.append("\"干电状态标志\":\"碱缺\",");
                    }
                    break;
                case 49:
                    if (bitvals.equals("1")) {
                        sb.append("\"干电状态标志\":\"存在\",");
                    }
            }

            sb.append("\"未用气天数\":\"").append(Integer.parseInt(SourceHex.substring(30, 31), 16)).append("\",");
            sb.append("\"未通信天数\":\"").append(Integer.parseInt(SourceHex.substring(31, 32), 16)).append("\",");
            int report = Integer.parseInt(SourceHex.substring(40, 41), 16);
            switch(report) {
            case 1:
                sb.append("\"主动上报原因\":\"设定周期上报\",");
                break;
            case 2:
                sb.append("\"主动上报原因\":\"强按键上报\",");
                break;
            case 3:
                sb.append("\"主动上报原因\":\"按开的警告性关阀上报\",");
                break;
            case 4:
                sb.append("\"主动上报原因\":\"不可按开的关阀上报\",");
                break;
            case 5:
                sb.append("\"主动上报原因\":\"通讯失败\"");
                break;
            case 6:
                sb.append("\"主动上报原因\":\"按键开阀上报\",");
            }

            sb.append("\"阀门未动作天数\":\"").append(Integer.parseInt(SourceHex.substring(41, 42), 16)).append("\"");
            sb.append("}");
            sb.append("}");
            return sb.toString();
        } catch (Exception var15) {
            throw var15;
        }
    }

    public static String getBindPermissionAnalysis(String SourceHex) throws Exception {
        try {
            SourceHex = Models.AnalysisPublic(SourceHex);
            StringBuilder sb = new StringBuilder();
            String version = SourceHex.substring(0, 4);
            int i = Integer.parseInt(version, 16);
            double ii = (double)i * 1.0D;
            sb.append("{");
            sb.append("\"格式版本\":").append(ii).append(",");
            String hascode = SourceHex.substring(5, 20);
            sb.append("\"meterNumber\":\"").append(hascode).append("\",");
            sb.append("\"表端固件版本号\":").append(Integer.parseInt(SourceHex.substring(20, 22), 16)).append(",");
            String rnum = SourceHex.substring(24, 26) + SourceHex.substring(22, 24);
            System.out.println("rnum=" + Integer.parseInt(rnum, 16));
            int da = Integer.parseInt(rnum, 16);
            sb.append("\"日用量\":").append((double) da / 100.0D).append(",");
            int sum = Integer.parseInt(SourceHex.substring(32, 34) + SourceHex.substring(30, 32) + SourceHex.substring(28, 30) + SourceHex.substring(26, 28), 16);
            sb.append("\"累计量\":").append((double) sum / 100.0D).append(",");
            int mon = Integer.parseInt(SourceHex.substring(40, 42) + SourceHex.substring(38, 40) + SourceHex.substring(36, 38) + SourceHex.substring(34, 36), 16);
            sb.append("\"本月用量\":").append((double) mon / 100.0D).append(",");
            int later = Integer.parseInt(SourceHex.substring(48, 50) + SourceHex.substring(46, 48) + SourceHex.substring(44, 46) + SourceHex.substring(42, 44), 16);
            sb.append("\"上月用量\":").append((double) later / 100.0D).append(",");
            StringBuilder amountmoney = new StringBuilder();
            int no = 66;

            int money;
            for(money = 0; money < 8; ++money) {
                amountmoney.append(SourceHex, no - 2, no);
                no -= 2;
            }

            System.out.println("amountmoney=" + amountmoney);
            money = (new BigInteger(amountmoney.toString(), 16)).intValue();
            sb.append("\"预存金额\":").append((double) money / 10000.0D).append(",");
            long year = Long.parseLong(SourceHex.substring(72, 74) + SourceHex.substring(70, 72) + SourceHex.substring(68, 70) + SourceHex.substring(66, 68), 16);
            sb.append("\"年用量\":").append((double) year / 100.0D).append(",");
            int ladder = Integer.parseInt(SourceHex.substring(76, 78) + SourceHex.substring(74, 76), 16);
            double lad = (double)ladder / 100.0D;
            sb.append("\"当前单价\":").append(lad).append("}");
            return sb.toString();
        } catch (Exception var20) {
            throw var20;
        }
    }

    public static String HeartReback(String SourceHex) throws Exception {
        try {
            SourceHex = Models.AnalysisPublic(SourceHex);
            String v1 = SourceHex.substring(0, 4);
            int ver = Integer.parseInt(v1, 16);
            String version = Integer.toString(ver);
            String str = SourceHex.substring(4);
            String vo = AnalysisUtils.Hexflip(str);
            int vi = Integer.parseInt(vo, 16);
            return "{\"格式版本\":\"" + version + "\",\"电池电压\":\"" + vi + "\"}";
        } catch (Exception var7) {
            throw var7;
        }
    }
}
