package com.aote.webmeter.module.main.ximeisystem;

import cn.hutool.core.util.IdUtil;
import com.aote.webmeter.tools.WebMeterInfo;
import net.sf.json.JSONObject;
import org.json.JSONArray;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.*;

public class XiMeiUtil {
    private static final Map<String,String> EXCEPTION_MAP;

    static {
        EXCEPTION_MAP = new HashMap<>();
        EXCEPTION_MAP.put("statusRemove","拆表报警");
        EXCEPTION_MAP.put("statusValveBad","阀门故障");
        EXCEPTION_MAP.put("statusMagneticAttack","强磁干扰");
        EXCEPTION_MAP.put("statusCountError","计数器故障");
        EXCEPTION_MAP.put("statusMaxFlow","超流量报警");
        EXCEPTION_MAP.put("statusMinFlow","小流量报警");
    }

    public static JSONArray getExceptionArray(JSONObject params){
        JSONArray exceptionArray = new JSONArray();
        for(Object type : params.keySet()){
            if(params.getString((String)type).equals("1")){
                exceptionArray.put(EXCEPTION_MAP.get(type));
            }
        }
        return exceptionArray;
    }

    public static String getSignValue(String content) throws NoSuchAlgorithmException {
        String key = WebMeterInfo.getString("key");
        JSONObject jo = JSONObject.fromObject(content);
        // 去掉sign
        jo.remove("sign");
        jo.remove("signType");
        jo.remove("dataList");
        // 移除空值
        Set<String> set = new HashSet<>(jo.keySet());
        for (String s : set) {
            if (jo.get(s).equals("") || jo.get(s) == null || jo.get(s) instanceof JSONArray
                    || jo.get(s) instanceof JSONObject) {
                jo.remove(s);
            }
        }
        // 排序输出字符串
        StringBuilder sbu = new StringBuilder();
        List<String> list1 = new ArrayList<String>(jo.keySet());
        //log.debug("加密前List1" + list1);
        Collections.sort(list1);
        for (int i = 0; i < list1.size(); i++) {
            char ch = ' ';
            if (i < list1.size() - 1) {
                ch = '&';
            }
            sbu.append(list1.get(i)).append("=").append(jo.get(list1.get(i)).toString()).append(ch);
        }
        String stringSignTemp = sbu.toString().trim() + "&key=" + key;

        String md5str;
        StringBuffer sb;
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(stringSignTemp.getBytes());
        sb = new StringBuffer();
        byte[] bytes = md.digest();
        for (byte aByte : bytes) {
            String s = Integer.toHexString(0xff & aByte);
            if (s.length() == 1) {
                sb.append("0" + s);
            } else {
                sb.append(s);
            }
        }
        md5str = sb.toString();
        return md5str.toUpperCase();
    }

    public static void main(String[] args) throws NoSuchAlgorithmException {
        String jsonObject = "{\"priceVer\":1,\"priceMode\":2,\"currentMonay\":0,\"sign\":\"693ED7F657079DF97AF9AD239AAA0689\",\"totalLevelAmount\":0,\"step3Price\":1,\"prepayMode\":2,\"meterNo\":\"302939232313\",\"step2Vol\":6555,\"signType\":\"MD5\",\"totalMoney\":0,\"tradeCode\":\"3002\",\"currentAmount\":0,\"version\":\"v1\",\"runMode\":2,\"step1Price\":1,\"totalAmount\":0,\"stepFqcy\":1,\"stepStartDate\":\"20201000000000\",\"partner\":\"cqsemay_bcts\",\"stepPeriod\":\"year\",\"appid\":\"yysf\",\"notifyUrl\":\"test\",\"step3Vol\":6555,\"totalOrders\":0,\"step1Vol\":6555,\"step2Price\":1,\"taskId\":\"4563baea6c5a47c1b1fc417f6cbe6ff8\"}";
        String signValue = getSignValue(jsonObject);
        System.out.println(signValue);
    }


    public static String genUUID() {
        return IdUtil.simpleUUID();
    }


}
