package com.aote.webmeter.module.main.xianfengsystem;

import com.af.plugins.DateTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.apache.commons.codec.digest.DigestUtils;
import org.json.JSONArray;
import org.json.JSONObject;

import java.security.SecureRandom;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class XianFengSystemTools {

    static final Map<String, HashMap.SimpleEntry<String, String>> ALARM_MAP = new HashMap<>(20);

    static {
        initAlarmMap();
    }

    private static void initAlarmMap() {
        ALARM_MAP.put("1", new AbstractMap.SimpleEntry<>("死表", "表具多天不用气，阀门自动关闭，可按键打开阀门"));
        ALARM_MAP.put("3", new AbstractMap.SimpleEntry<>("外部检测到异常", "检测到表具可能发生泄漏、打开罩壳、表具倾斜，自动关闭阀门等情况"));
        ALARM_MAP.put("4", new AbstractMap.SimpleEntry<>("电池失压", "电池出现失压，需及时更换电池"));
        ALARM_MAP.put("6", new AbstractMap.SimpleEntry<>("流量超限", "表具流量超过最大设置值"));
        ALARM_MAP.put("7", new AbstractMap.SimpleEntry<>("电池欠压", "电池出现欠压，需及时更换电池"));
        ALARM_MAP.put("8", new AbstractMap.SimpleEntry<>("单管", "计量单元发生异常，无法正常记量，阀门自动关闭"));
        ALARM_MAP.put("9", new AbstractMap.SimpleEntry<>("强磁干扰", "表具检测到外部有强磁干扰，阀门自动关闭"));
        ALARM_MAP.put("10", new AbstractMap.SimpleEntry<>("断线", "计量线断开，影响电子部分记录，阀门自动关闭"));
        ALARM_MAP.put("11", new AbstractMap.SimpleEntry<>("开阀失败", "开启阀门失败"));
        ALARM_MAP.put("12", new AbstractMap.SimpleEntry<>("关阀失败", "关闭阀门失败"));
        ALARM_MAP.put("13", new AbstractMap.SimpleEntry<>("存储器异常", "表具内部存储单位异常，无法正常记录数据"));
        ALARM_MAP.put("14", new AbstractMap.SimpleEntry<>("晶振停振", "影响内部时钟精度"));
        ALARM_MAP.put("15", new AbstractMap.SimpleEntry<>("欠量", "表内剩余小于欠量报警阈值"));
        ALARM_MAP.put("16", new AbstractMap.SimpleEntry<>("开盖", "带有开盖报警功能的表具罩壳被打开"));
        ALARM_MAP.put("17", new AbstractMap.SimpleEntry<>("透支", "表内剩余少于设置的透支阈值"));
        ALARM_MAP.put("18", new AbstractMap.SimpleEntry<>("零额", "表内剩余金额小于等于零"));
        ALARM_MAP.put("19", new AbstractMap.SimpleEntry<>("小流量", "检测到过小的用气流量"));
        ALARM_MAP.put("20", new AbstractMap.SimpleEntry<>("温度异常", "流量计内部温度异常"));
        ALARM_MAP.put("21", new AbstractMap.SimpleEntry<>("压力异常", "流量计内部压力异常"));
        ALARM_MAP.put("22", new AbstractMap.SimpleEntry<>("计量异常", "计量单元发生问题"));
        ALARM_MAP.put("23", new AbstractMap.SimpleEntry<>("无阀", "表具无阀门"));
        ALARM_MAP.put("24", new AbstractMap.SimpleEntry<>("阀门异常", "阀门发生故障"));
        ALARM_MAP.put("4096", new AbstractMap.SimpleEntry<>("集中器低压", "集中器电源发生欠压或失压"));
        ALARM_MAP.put("4097", new AbstractMap.SimpleEntry<>("集中器市电掉电", "市电供电的集中器市电突然断开"));
        ALARM_MAP.put("65535", new AbstractMap.SimpleEntry<>("未知事件", "未知事件"));
    }

    public static String getTransId() {
        SecureRandom random = new SecureRandom();
        return DateTools.getNow("yyyyMMddHHmmss") + (80000000 + random.nextInt(9999999));
    }

    public static String getToken(String transId) {
        return DigestUtils.sha256Hex(WebMeterInfo.getString("key") + WebMeterInfo.getString("merchantId") + transId);
    }

    public static JSONObject parseArray(JSONArray array) {
        JSONObject result = new JSONObject();
        for (Object item : array) {
            JSONObject itemObj = (JSONObject) item;
            result.put(itemObj.getString("serviceId"), itemObj.getJSONObject("serviceData"));
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(parseArray(new JSONArray("[{\"serviceId\":\"GeneralDataInfo\",\"serviceData\":{\"deviceTime\":\"20200909030700\",\"valveState\":\"1\",\"batteryVoltage\":\"5.68\",\"meterStatus\":{\"deviceLock\":\"0\",\"superFlow\":\"0\",\"magneticInterference\":\"0\",\"pressureLack\":\"0\",\"leakAlarm\":\"0\",\"singleCount\":\"0\",\"breakLine\":\"0\",\"valveDamage\":\"0\",\"remoteCloseValve\":\"0\",\"valueLack\":\"0\",\"loseTrack\":\"0\",\"accountFlag\":\"1\"}}},{\"serviceId\":\"SignalInfo\",\"serviceData\":{\"signalCSQ\":\"25\"}},{\"serviceId\":\"MoneyMeterInfo\",\"serviceData\":{\"currentPrice\":\"2.23\",\"totalLadderValue\":\"2918\"}},{\"serviceId\":\"FrozenValueInfo\",\"serviceData\":{\"frozenRecords\":[{\"frozenType\":\"3\",\"frozenDate\":\"20200908000000\",\"frozenValue\":\"10559\",\"dayUseValue\":\"320\",\"totalBuyValue\":\"78051.0\",\"totalUseValue\":\"23546.57\",\"surplusValue\":\"54504.43\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908230000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908220000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908210000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908200000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908190000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908180000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908170000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908160000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908150000\",\"frozenValue\":\"14\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908140000\",\"frozenValue\":\"43\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908130000\",\"frozenValue\":\"42\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908120000\",\"frozenValue\":\"43\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908110000\",\"frozenValue\":\"44\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908100000\",\"frozenValue\":\"43\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908090000\",\"frozenValue\":\"43\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908080000\",\"frozenValue\":\"48\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908070000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908060000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908050000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908040000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908030000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908020000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908010000\",\"frozenValue\":\"0\"},{\"frozenType\":\"2\",\"frozenDate\":\"20200908000000\",\"frozenValue\":\"0\"}]}},{\"serviceId\":\"FlowMeterInfo\",\"serviceData\":{\"standardTotalValue\":\"10596\",\"workTotalValue\":\"10596\",\"temperatureValue\":\"24.500\",\"pressureValue\":\"99.200\",\"flowMeterStatus\":{\"totalizerConnectState\":\"0\",\"temperatureSensorState\":\"0\",\"pressureSensorState\":\"0\",\"magneticInterference\":\"0\",\"pressureLack\":\"0\",\"pressureWarn\":\"0\",\"temperatureWarn\":\"0\"}}}]")));
    }

    public static JSONObject getAlarmData(String type) {
        JSONObject result = new JSONObject();
        AbstractMap.SimpleEntry<String, String> entry = ALARM_MAP.get(type);
        if (entry == null) {
            return null;
        }
        result.put("type",entry.getKey());
        result.put("msg",entry.getValue());
        return result;
    }
}
