package com.aote.webmeter.module.main.weixintcp;

import com.af.plugins.CommonTools;
import com.af.plugins.ConvertTools;
import com.viewshine.codec.Commerce30;
import com.viewshine.codec.DecodeResult;
import com.viewshine.codec.engine.CodecDataItem;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.Map;

/**
 * 威星TCP对接兼容工具
 * @author Mrriver
 */
public class WeiXinTcpTools2 {
    private static final String[] UP_TIME_VALUES = {
            "00","06","12","18","24","30","36","42","48","45"
    };
    private static final Integer MIN_HOUR = 0;
    private static final Integer MAX_HOUR = 7;
    private static final Integer MIN_MINUTE = 1;
    private static final Integer MAX_MINUTE = 59;

    public static byte[] RestoreMeter(String meterCode, String meterType, Boolean haveNextCmd) {
        return Commerce30.RestoreMeter(meterCode,meterType,haveNextCmd);
    }

    public static byte[] SetPriceModel(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd) {
        return Commerce30.SetPriceModel(meterCode,meterType,(Map)params.toMap(),haveNextCmd);
    }

    public static byte[] ValveControl(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd) {
        return Commerce30.ValveControl(meterCode,meterType,(Map)params.toMap(),haveNextCmd);
    }

    public static byte[] Recharge(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd) {
        return Commerce30.Recharge(meterCode,meterType,(Map) params.toMap(),haveNextCmd);
    }

    public static byte[] SetCycleGasVolume(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd) {
        return Commerce30.SetCycleGasVolume(meterCode,meterType,(Map)params.toMap(),haveNextCmd);
    }

    public static byte[] balanceSync(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd){
        return Commerce30.BalanceSync(meterCode,meterType,(Map)params.toMap(),haveNextCmd);
    }

    public static byte[] setParams(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd){
        return Commerce30.SetParameter(meterCode,meterType,(Map)params.toMap(),haveNextCmd);
    }

    public static JSONObject Decode(byte[] msg, Boolean haveNextCmd) {
        DecodeResult docodeResult = Commerce30.Decode(msg,haveNextCmd);
        JSONArray array = new JSONArray();
        if (docodeResult.getDataItems() != null){
            for(CodecDataItem codecDataItem : docodeResult.getDataItems()){
                array.put(com.alibaba.fastjson.JSONObject.toJSONString(codecDataItem));
            }
        }
        JSONObject object = new JSONObject();
        object.put("isSuccess",docodeResult.isSuccess());
        object.put("errCode",docodeResult.getErrCode());
        object.put("errMsg",docodeResult.getErrMsg());
        object.put("meterCode",docodeResult.getMeterCode());
        object.put("cmdCode",docodeResult.getCmdCode());
        object.put("cmdName",docodeResult.getCmdName());
        object.put("time",docodeResult.getTime());
        object.put("meterType",docodeResult.getMeterType());
        object.put("dataItems",array);
        object.put("cmdable",docodeResult.isCmdable());
        object.put("echoData",docodeResult.getEchoData());
        return object;
    }

    public static JSONObject getParams(JSONArray params){
        JSONObject object = new JSONObject();
        for(Object obj : params){
            JSONObject jo = new JSONObject(String.valueOf(obj));
            String result = null;
            if (jo.has("value")){
                result = jo.getString("value");
            }
            object.put("param"+jo.getString("code"),result);
        }
        return object;
    }

    public static String base64Encode(byte[] bytes) {
        return ConvertTools.base64Encode(bytes);
    }

    public static String base64Encode(String result) {
        return "00";
    }

    public static String getUploadTime(String meternumber) {
        //获取时
        String hour = "0"+CommonTools.getRandomNumber(MIN_HOUR,MAX_HOUR);
        //获取分
        String minute = String.valueOf(CommonTools.getRandomNumber(MIN_MINUTE,MAX_MINUTE));
        if(minute.length() == 1) {
            minute = "0" + minute;
        }
        return "00"+hour+minute;
    }
}
