package com.aote.webmeter.module.main.weixintcp;

import com.af.plugins.CommonTools;
import com.af.plugins.ConvertTools;
import com.af.plugins.DateTools;
import com.aote.webmeter.module.main.nb.impl.MeterTools;
import com.viewshine.codec.Commerce30;
import com.viewshine.codec.utils.AESUtil;
import com.viewshine.codec.utils.ByteUtils;
import org.apache.commons.codec.DecoderException;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;

/**
 * 威星TCP对接兼容工具
 * @author Mrriver
 */
public class WeiXinNBTools {
    private static final String[] UP_TIME_VALUES = {
            "00","06","12","18","24","30","36","42","48","45"
    };

    private static  final String secretKey = "01020304050607080000000000000000";

    private static final Integer MIN_HOUR = 0;
    private static final Integer MAX_HOUR = 7;
    private static final Integer MIN_MINUTE = 1;
    private static final Integer MAX_MINUTE = 59;


    public static String openAccount(String meterCode, String runType, String meterType, JSONObject params) {


        byte runTypebyte = Byte.parseByte(runType);

        byte[] openParams = new byte[10];

        openParams[0] = 1;
        System.arraycopy(ByteUtils.getBytes(5), 0, openParams, 1, 4);
        openParams[5] = 1;

        byte[] priceModule = new byte[53];

        String price1 = (String) params.get("price1");
        String price2 = price1;
        String price3 = price1;
        String price4 = price1;
        String price5 = price1;
        String GasVolume1 = (String) params.get("gasVolume1");
        String GasVolume2 = GasVolume1;
        String GasVolume3 = GasVolume1;
        String GasVolume4 = GasVolume1;
        String GasVolume5 = "9999999";
        String chargingExecuteDate = (String) params.get("chargingExecuteDate");
        String chargingStartDate = (String) params.get("chargingStartDate");
        String priceModelSeq = (String) params.get("priceModelSeq");
        String upTime = (String) params.get("upTime");

        String mm = chargingStartDate.substring(0, 2);
        String dd = chargingStartDate.substring(2, 4);
        String bt0 = "0000000";
        String bt1 = ByteUtils.byteToBitSetStr(Byte.parseByte(mm), 4, 4, false);
        String bt2 = ByteUtils.byteToBitSetStr(Byte.parseByte(dd), 3, 5, false);
        chargingStartDate = ByteUtils.bytesToHexStr(ByteUtils.bitSetStringToBytes(bt0 + bt1 + bt2, false));

        priceModule[0] = 0x01;
        priceModule[1] = 0x01;
        priceModule[2] = 0x12;
        priceModule[3] = Byte.parseByte(chargingExecuteDate.substring(0, 2));
        priceModule[4] = Byte.parseByte(chargingExecuteDate.substring(2, 4));
        priceModule[5] = Byte.parseByte(chargingExecuteDate.substring(4, 6));
        priceModule[6] = Byte.parseByte(chargingExecuteDate.substring(6, 8));

        price1 = String.format("%.4f", Double.parseDouble(price1)).replace(".", "");
        price2 = String.format("%.4f", Double.parseDouble(price2)).replace(".", "");
        price3 = String.format("%.4f", Double.parseDouble(price3)).replace(".", "");
        price4 = String.format("%.4f", Double.parseDouble(price4)).replace(".", "");
        price5 = String.format("%.4f", Double.parseDouble(price5)).replace(".", "");
        GasVolume1 = String.format("%.2f", Double.parseDouble(GasVolume1)).replace(".", "");
        GasVolume2 = String.format("%.2f", Double.parseDouble(GasVolume2)).replace(".", "");
        GasVolume3 = String.format("%.2f", Double.parseDouble(GasVolume3)).replace(".", "");
        GasVolume4 = String.format("%.2f", Double.parseDouble(GasVolume4)).replace(".", "");
        GasVolume5 = String.format("%.2f", Double.parseDouble(GasVolume5)).replace(".", "");


        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(price1)), 0, priceModule, 7, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(GasVolume1)), 0, priceModule, 11, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(price2)), 0, priceModule, 15, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(GasVolume2)), 0, priceModule, 19, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(price3)), 0, priceModule, 23, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(GasVolume3)), 0, priceModule, 27, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(price4)), 0, priceModule, 31, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(GasVolume4)), 0, priceModule, 35, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(price5)), 0, priceModule, 39, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(GasVolume5)), 0, priceModule, 43, 4);

        System.arraycopy(ByteUtils.hexStrToBytes(chargingStartDate, true), 0, priceModule, 47, 2);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(priceModelSeq)), 0, priceModule, 47, 2);

        byte[] hand = ByteUtils.hexStrToBytes(upTime);

        byte[] handData = new byte[11];

        handData[0] = 0x00;
        handData[1] = 0x05;
        handData[2] = hand[0];
        handData[3] = hand[1];
        handData[4] = hand[2];
        handData[5] = (byte) 0xFF;
        handData[6] = (byte) 0xFF;
        handData[7] = (byte) 0xFF;
        handData[8] = (byte) 0xFF;
        handData[9] = (byte) 0xFF;
        handData[10] = (byte) 0xFF;

        byte[] closeData = new byte[3];
        closeData[0] = 0x28;


        byte[] vulveData = new byte[1];
        vulveData[0] = 0x02;

        byte[] instruct = new byte[139];
        instruct[0] = runTypebyte;

        System.arraycopy(openParams,0,instruct,10,10);
        System.arraycopy(priceModule,0,instruct,20,53);
        System.arraycopy(handData,0,instruct,73,11);
        System.arraycopy(closeData,0,instruct,84,3);
        System.arraycopy(vulveData,0,instruct,87,1);

        return getInstruct(instruct, meterCode, meterType, "048530", false);
    }

    public static String SetPriceModel(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd) {

        String price1 = (String) params.get("price1");
        String price2 = (String) params.get("price2");
        String price3 = (String) params.get("price3");
        String price4 = (String) params.get("price4");
        String price5 = (String) params.get("price5");
        String GasVolume1 = (String) params.get("GasVolume1");
        String GasVolume2 = (String) params.get("GasVolume2");
        String GasVolume3 = (String) params.get("GasVolume3");
        String GasVolume4 = (String) params.get("GasVolume4");
        String GasVolume5 = "9999999";
        String chargingExecuteDate = (String)params.get("chargingExecuteDate");
        String chargingStartDate = (String)params.get("chargingStartDate");
        String priceModelSeq = (String)params.get("priceModelSeq");



        String mm = chargingStartDate.substring(0, 2);
        String dd = chargingStartDate.substring(2, 4);
        String bt0 = "0000000";
        String bt1 = ByteUtils.byteToBitSetStr(Byte.parseByte(mm), 4, 4, false);
        String bt2 = ByteUtils.byteToBitSetStr(Byte.parseByte(dd), 3, 5, false);
        chargingStartDate = ByteUtils.bytesToHexStr(ByteUtils.bitSetStringToBytes(bt0 + bt1 + bt2, false));

        byte[] instruct = new byte[53];
        instruct[0] = 0x01;
        instruct[1] = 0x01;
        instruct[2] = 0x12;
        instruct[3] = Byte.parseByte(chargingExecuteDate.substring(0, 2));
        instruct[4] = Byte.parseByte(chargingExecuteDate.substring(2, 4));
        instruct[5] = Byte.parseByte(chargingExecuteDate.substring(4, 6));
        instruct[6] = Byte.parseByte(chargingExecuteDate.substring(6, 8));

        price1 = String.format("%.4f", Double.parseDouble(price1)).replace(".", "");
        price2 = String.format("%.4f", Double.parseDouble(price2)).replace(".", "");
        price3 = String.format("%.4f", Double.parseDouble(price3)).replace(".", "");
        price4 = String.format("%.4f", Double.parseDouble(price4)).replace(".", "");
        price5 = String.format("%.4f", Double.parseDouble(price5)).replace(".", "");
        GasVolume1 = String.format("%.2f", Double.parseDouble(GasVolume1)).replace(".", "");
        GasVolume2 = String.format("%.2f", Double.parseDouble(GasVolume2)).replace(".", "");
        GasVolume3 = String.format("%.2f", Double.parseDouble(GasVolume3)).replace(".", "");
        GasVolume4 = String.format("%.2f", Double.parseDouble(GasVolume4)).replace(".", "");
        GasVolume5 = String.format("%.2f", Double.parseDouble(GasVolume5)).replace(".", "");


        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(price1)), 0, instruct, 7, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(GasVolume1)), 0, instruct, 11, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(price2)), 0, instruct, 15, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(GasVolume2)), 0, instruct, 19, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(price3)), 0, instruct, 23, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(GasVolume3)), 0, instruct, 27, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(price4)), 0, instruct, 31, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(GasVolume4)), 0, instruct, 35, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(price5)),0,instruct,39,4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(GasVolume5)),0,instruct,43,4);

        System.arraycopy(ByteUtils.hexStrToBytes(chargingStartDate,true),0,instruct,47,2);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(priceModelSeq)),0,instruct,47,2);


        return getInstruct(instruct, meterCode, meterType, "048519", false);
    }

    public static String ValveControl(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd) {

        String valveState = (String) params.get("valveState");
        int valve = Integer.parseInt(valveState);
        byte[] instruct = new byte[1];
        if (valve == 0) {
            instruct[0] = 0x55;
        } else {
            instruct[0] = (byte) 0x99;
        }

        return getInstruct(instruct,meterCode,meterType,"048520",haveNextCmd);

    }

    //设置工程参数（商业）
    public static String syncParams(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd) {
        String porValveOpen = params.optString("porValveOpen","2");
        String heatMeterValveClose = params.optString("heatMeterValveClose","2");
        String pressurePickupValveClose = params.optString("pressurePickupValveClose","2");
        String keystokeValveOpen = params.optString("keystokeValveOpen","2");
        String acDumpValveClose = params.optString("acDumpValveClose","2");
        String idleValveClose = params.optString("idleValveClose","2");
        String lostHandValveClose = params.optString("lostHandValveClose","2");
        String rillAlarmValue = params.optString("rillAlarmValue","0");
        String overFlowAlarmValue = params.optString("overFlowAlarmValue","0");
        String idleDayValue = params.optString("idleDayValue","0");
        String offlineDayValue = params.optString("offlineDayValue","0");


        String binArray = "0000";
        String binArray2 = "0000";

        if("2".equals(lostHandValveClose)){
            binArray = binArray + "0";
            binArray2 = binArray2 + "0";
        }else{
            binArray = binArray + "1";
            binArray2 = binArray2 + lostHandValveClose;
        }

        if("2".equals(idleValveClose)){
            binArray = binArray + "0";
            binArray2 = binArray2 + "0";
        }else{
            binArray = binArray + "1";
            binArray2 = binArray2 + idleValveClose;
        }

        if("2".equals(acDumpValveClose)){
            binArray = binArray + "0";
            binArray2 = binArray2 + "0";
        }else{
            binArray = binArray + "1";
            binArray2 = binArray2 + acDumpValveClose;
        }

        if("2".equals(keystokeValveOpen)){
            binArray = binArray + "0";
            binArray2 = binArray2 + "0";
        }else{
            binArray = binArray + "1";
            binArray2 = binArray2 + keystokeValveOpen;
        }

        if("2".equals(pressurePickupValveClose)){
            binArray = binArray + "0";
            binArray2 = binArray2 + "0";
        }else{
            binArray = binArray + "1";
            binArray2 = binArray2 + pressurePickupValveClose;
        }

        if("2".equals(heatMeterValveClose)){
            binArray = binArray + "0";
            binArray2 = binArray2 + "0";
        }else{
            binArray = binArray + "1";
            binArray2 = binArray2 + heatMeterValveClose;
        }

        binArray = binArray + "0000";
        binArray2 = binArray2 + "0000";

        if("2".equals(porValveOpen)){
            binArray = "0";
            binArray2 = "0";
        }else{
            binArray = binArray + "1";
            binArray2 = binArray2 + porValveOpen;
        }
        binArray = binArray + "0";
        binArray2 = binArray2 + "0";

        String binArray3 = "0000";

        if("0".equals(offlineDayValue)){
            binArray3 = binArray3 + "0";
        }else {
            binArray3 = binArray3 + "1";
        }

        if("0".equals(idleDayValue)){
            binArray3 = binArray3 + "0";
        }else {
            binArray3 = binArray3 + "1";
        }

        if("0".equals(overFlowAlarmValue)){
            binArray3 = binArray3 + "0";
        }else {
            binArray3 = binArray3 + "1";
        }

        if("0".equals(rillAlarmValue)){
            binArray3 = binArray3 + "0";
        }else {
            binArray3 = binArray3 + "1";
        }

        byte[] instruct = new byte[37];

        System.arraycopy(ByteUtils.bitSetStringToBytes(binArray,false),0,instruct,0,2);
        System.arraycopy(ByteUtils.bitSetStringToBytes(binArray2,false),0,instruct,2,2);
        System.arraycopy(ByteUtils.bitSetStringToBytes(binArray3,false),0,instruct,4,1);

        rillAlarmValue = String.format("%.4f", Double.parseDouble(rillAlarmValue));
        overFlowAlarmValue = String.format("%.4f", Double.parseDouble(overFlowAlarmValue));



        System.arraycopy(MeterTools.shortToByte(Short.parseShort(rillAlarmValue.split("\\.")[1]),true), 0, instruct, 5, 2);
        System.arraycopy(MeterTools.shortToByte(Short.parseShort(rillAlarmValue.split("\\.")[0]),true), 0, instruct, 7, 2);
        System.arraycopy(MeterTools.shortToByte(Short.parseShort(overFlowAlarmValue.split("\\.")[1]),true), 0, instruct, 9, 2);
        System.arraycopy(MeterTools.shortToByte(Short.parseShort(overFlowAlarmValue.split("\\.")[0]),true), 0, instruct, 9, 2);
        instruct[13] = (byte)Integer.parseInt(idleDayValue);
        instruct[14] = (byte)Integer.parseInt(offlineDayValue);


        return getInstruct(instruct, meterCode, meterType, "04AA13", haveNextCmd);

    }

    //设置工程参数(民用)
    public static String syncMYParams(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd) throws DecoderException {

        byte[] instruct = new byte[37];
        // 是否更改 119 关阀功能
        String fireValveClose = params.optString("fireValveClose","2");
        // 上电开阀更改
        String porValveOpen = params.optString("porValveOpen","2");
        // 欠压关阀更改
        String uvpValveClose = params.optString("uvpValveClose","2");
        //小流关阀更改
        String rillValveClose = params.optString("rillValveClose","2");
        // 超流关阀更改
        String overFlowValveClose = params.optString("overFlowValveClose","2");
        // 反向走气关阀更改
        String vapidityValveClose = params.optString("vapidityValveClose","2");
        // 温度传感器坏关阀更改
        String heatMeterValveClose = params.optString("heatMeterValveClose","2");
        // 压力传感器坏关阀更改
        String pressurePickupValveClose = params.optString("pressurePickupValveClose","2");
        // 按键开阀更改
        String keystokeValveOpen = params.optString("keystokeValveOpen","2");
        // 掉电关阀更改
        String acDumpValveClose = params.optString("acDumpValveClose","2");
        // 闲置关阀更改
        String idleValveClose = params.optString("idleValveClose","2");
        // 失联关阀更改
        String lostHandValveClose = params.optString("lostHandValveClose","2");
        // 拆表关阀更改
        String tearValveClose = params.optString("tearValveClose","2");
        // 开盖关阀更改
        String uncapAlarm = params.optString("uncapAlarm","2");
        // 恒流关阀更改
        String constantFlow = params.optString("constantFlow","2");
        // 小流报警阈值
        String rillAlarmValue = params.optString("rillAlarmValue","0");
        // 大流报警阈值
        String overFlowAlarmValue = params.optString("overFlowAlarmValue","0");
        // 闲置天数
        String idleDayValue = params.optString("idleDayValue","0");
        // 失联天数
        String offlineDayValue = params.optString("offlineDayValue","0");
        // 空气中声速最大值
        String velocityOfSoundMaxValue = params.optString("velocityOfSoundMaxValue","0");
        // 燃气中声速最小值
        String velocityOfSoundMinValue = params.optString("velocityOfSoundMinValue","0");
        // 恒流时间值
        String constantFlowDateValue = params.optString("constantFlowDateValue","0");

        String binArray = "0";
        String binArray2 = "0";

        if("2".equals(constantFlow)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += constantFlow;
        }
        if("2".equals(uncapAlarm)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += uncapAlarm;
        }
        if("2".equals(tearValveClose)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += tearValveClose;
        }
        if("2".equals(lostHandValveClose)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += lostHandValveClose;
        }
        if("2".equals(idleValveClose)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += idleValveClose;
        }
        if("2".equals(acDumpValveClose)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += acDumpValveClose;
        }
        if("2".equals(keystokeValveOpen)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += keystokeValveOpen;
        }
        if("2".equals(pressurePickupValveClose)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += pressurePickupValveClose;
        }
        if("2".equals(heatMeterValveClose)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += heatMeterValveClose;
        }
        if("2".equals(vapidityValveClose)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += vapidityValveClose;
        }
        if("2".equals(overFlowValveClose)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += overFlowValveClose;
        }
        if("2".equals(rillValveClose)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += rillValveClose;
        }
        if("2".equals(uvpValveClose)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += uvpValveClose;
        }
        if("2".equals(porValveOpen)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += porValveOpen;
        }
        if("2".equals(fireValveClose)){
            binArray += "0";
            binArray2 += "0";
        }else {
            binArray += "1";
            binArray2 += fireValveClose;
        }

        System.arraycopy(ByteUtils.bitSetStringToBytes(binArray,false),0,instruct,0,2);
        System.arraycopy(ByteUtils.bitSetStringToBytes(binArray2,false),0,instruct,2,2);

        String binArray3 = "";

        if("0".equals(rillAlarmValue)){
            binArray3 += "0";
        }else {
            binArray3+="1";
            String[] rillAlarmValues = rillAlarmValue.split("\\.");
            System.arraycopy(MeterTools.shortToByte(Short.parseShort(rillAlarmValues[0]),false),0,instruct,5,2);
            if(rillAlarmValues.length == 2){
                System.arraycopy(MeterTools.shortToByte(Short.parseShort(rillAlarmValues[1]),false),0,instruct,7,2);
            }
        }
        if("0".equals(overFlowAlarmValue)){
            binArray3 += "0";
        }else {
            binArray3+="1";
            String[] overFlowAlarmValues = overFlowAlarmValue.split("\\.");
            System.arraycopy(MeterTools.shortToByte(Short.parseShort(overFlowAlarmValues[0]),false),0,instruct,9,2);
            if(overFlowAlarmValues.length == 2){
                System.arraycopy(MeterTools.shortToByte(Short.parseShort(overFlowAlarmValues[1]),false),0,instruct,11,2);
            }
        }
        if("0".equals(idleDayValue)){
            binArray3 += "0";
        }else {
            binArray3+="1";
            instruct[13] = (byte) Integer.parseInt(idleDayValue);
        }
        if("0".equals(offlineDayValue)){
            binArray3 += "0";
        }else {
            binArray3+="1";
            instruct[14] = (byte) Integer.parseInt(offlineDayValue);
        }

        binArray3 += 0;

        if("0".equals(velocityOfSoundMaxValue)){
            binArray3 += "0";
        }else {
            binArray3+="1";
            int velocityOfSoundMaxValues = Integer.parseInt(String.valueOf(CommonTools.mul(velocityOfSoundMaxValue,10,0)));
            System.arraycopy(MeterTools.shortToByte((short) velocityOfSoundMaxValues,false),0,instruct,16,2);
        }

        if("0".equals(velocityOfSoundMinValue)){
            binArray3 += "0";
        }else {
            binArray3+="1";
            int velocityOfSoundMinValues = Integer.parseInt(String.valueOf(CommonTools.mul(velocityOfSoundMinValue,10,0)));
            System.arraycopy(MeterTools.shortToByte((short) velocityOfSoundMinValues,false),0,instruct,18,2);
        }

        if("0".equals(constantFlowDateValue)){
            binArray3 += "0";
        }else {
            binArray3+="1";
            instruct[20] = (byte) Integer.parseInt(constantFlowDateValue);
        }

        instruct[4] = ByteUtils.BitSetStrToByte(binArray3);

        return getInstruct(instruct, meterCode, meterType, "048626", haveNextCmd);
    }

    //设置表具参数(商业)
    public static String syncSYParams(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd) throws DecoderException {
        byte[] instruct = new byte[113];
        //表具编号更改 1+6
        instruct[0] = 0x00;
        Arrays.fill(instruct, 1, 7, (byte) 0xff);
        //APN 1+50
        instruct[7] = 0x00;
        Arrays.fill(instruct, 8, 58, (byte) 0x00);
        //IP地址，端口 1+6
        String ip = params.optString("ip","0");
        int port = params.optInt("port",0);
        if(ip.equals("0") || port == 0){
            instruct[58] = 0x00;
            Arrays.fill(instruct, 59, 65, (byte) 0xff);
        } else {
            String[] ips = ip.split("\\.");
            instruct[58] = 0x01;
            instruct[59] = (byte)(Integer.parseInt(ips[0]));
            instruct[60] = (byte)(Integer.parseInt(ips[1]));
            instruct[61] = (byte)(Integer.parseInt(ips[2]));
            instruct[62] = (byte)(Integer.parseInt(ips[3]));
            System.arraycopy(MeterTools.shortToByte((short) port,false),0,instruct,63,2);
        }
        //冻结类型 1+1
        instruct[65] = 0x00;
        instruct[66] = 0x00;
        //定时上告类型 1+1
        instruct[67] = 0x00;
        instruct[68] = 0x00;
        //指定时间点1 1+3
        String upTime = params.optString("upTime","0");
        if(upTime.equals("0")){
            instruct[69] = 0x00;
            Arrays.fill(instruct, 70, 73, (byte) 0x00);
        } else {
            instruct[69] = 0x01;
            System.arraycopy(ConvertTools.hexStrToByte(upTime),0,instruct,70,3);
        }
        //指定时间点2 1+3
        instruct[73] = 0x00;
        Arrays.fill(instruct, 74, 77, (byte) 0x00);
        //指定时间点3 1+3
        instruct[77] = 0x00;
        Arrays.fill(instruct, 78, 81, (byte) 0x00);
        //少额阈值 1+4
        int jotValue = params.optInt("jotValue",-1);
        if(jotValue == -1){
            instruct[81] = 0x00;
            System.arraycopy(MeterTools.IntToByte(0,true),0,instruct,82,4);
        } else {
            String[] jotValues = Integer.toString(jotValue).split("\\.");
            instruct[81] = 0x01;
            System.arraycopy(MeterTools.IntToByte(Integer.parseInt(jotValues[0]),true),0,instruct,82,3);
            if(jotValues.length == 2){
                instruct[85] = (byte) Integer.parseInt(jotValues[1]);
            } else {
                instruct[85] = 0x00;
            }
        }
        //透支金额 1+4
        int overdraft = params.optInt("overdraft",-1);
        if(overdraft == -1){
            instruct[86] = 0x00;
            System.arraycopy(MeterTools.IntToByte(0,true),0,instruct,87,4);
        } else {
            String[] overdrafts = Integer.toString(overdraft).split("\\.");
            instruct[86] = 0x01;
            System.arraycopy(MeterTools.IntToByte(Integer.parseInt(overdrafts[0]),true),0,instruct,87,3);
            if(overdrafts.length == 2){
                instruct[90] = (byte) Integer.parseInt(overdrafts[1]);
            } else {
                instruct[90] = 0x00;
            }
        }
        //排空量 1+2
        int emptyingVolume = params.optInt("emptyingVolume",-1);
        if(emptyingVolume == -1){
            instruct[91] = 0x00;
            System.arraycopy(MeterTools.IntToByte(0,true),0,instruct,92,2);
        } else {
            String[] emptyingVolumes = Integer.toString(emptyingVolume).split("\\.");
            instruct[91] = 0x01;
            System.arraycopy(MeterTools.IntToByte(Integer.parseInt(emptyingVolumes[0]),true),0,instruct,92,2);
        }
        //功能 4+4
        Arrays.fill(instruct, 94, 102, (byte) 0x00);
        //告警类型 2=2
        String alarmSwitch = "";
        String alarmValue = "";
        String meterAbnormalAlarm = params.optString("meterAbnormalAlarm","2");
        alarmSwitch = alarmSwitch + (meterAbnormalAlarm.equals("2") ? 0 : 1);
        alarmValue = alarmValue + (meterAbnormalAlarm.equals("2") ? 0 : meterAbnormalAlarm);
        String undervoltageAlarm = params.optString("undervoltageAlarm","2");
        alarmSwitch = alarmSwitch + (undervoltageAlarm.equals("2") ? 0 : 1);
        alarmValue = alarmValue + (undervoltageAlarm.equals("2") ? 0 : undervoltageAlarm);
        alarmSwitch = alarmSwitch + "000";
        alarmValue = alarmValue + "000";
        String overdraftAlarm = params.optString("overdraftAlarm","2");
        alarmSwitch = alarmSwitch + (overdraftAlarm.equals("2") ? 0 : 1);
        alarmValue = alarmValue + (overdraftAlarm.equals("2") ? 0 : overdraftAlarm);
        String zeroAlarm = params.optString("zeroAlarm","2");
        alarmSwitch = alarmSwitch + (zeroAlarm.equals("2") ? 0 : 1);
        alarmValue = alarmValue + (zeroAlarm.equals("2") ? 0 : zeroAlarm);
        String underAlarm = params.optString("underAlarm","2");
        alarmSwitch = alarmSwitch + (underAlarm.equals("2") ? 0 : 1);
        alarmValue = alarmValue + (underAlarm.equals("2") ? 0 : underAlarm);
        String rillAlarm = params.optString("rillAlarm","2");
        alarmSwitch = alarmSwitch + (rillAlarm.equals("2") ? 0 : 1);
        alarmValue = alarmValue + (rillAlarm.equals("2") ? 0 : rillAlarm);
        String OvercurrentAlarm = params.optString("OvercurrentAlarm","2");
        alarmSwitch = alarmSwitch + (OvercurrentAlarm.equals("2") ? 0 : 1);
        alarmValue = alarmValue + (OvercurrentAlarm.equals("2") ? 0 : OvercurrentAlarm);
        String valveAbnormalAlarm = params.optString("valveAbnormalAlarm","2");
        alarmSwitch = alarmSwitch + (valveAbnormalAlarm.equals("2") ? 0 : 1);
        alarmValue = alarmValue + (valveAbnormalAlarm.equals("2") ? 0 : valveAbnormalAlarm);
        String lowVoltageAlarm = params.optString("lowVoltageAlarm","2");
        alarmSwitch = alarmSwitch + (lowVoltageAlarm.equals("2") ? 0 : 1);
        alarmValue = alarmValue + (lowVoltageAlarm.equals("2") ? 0 : lowVoltageAlarm);
        String reverseAlarm = params.optString("reverseAlarm","2");
        alarmSwitch = alarmSwitch + (reverseAlarm.equals("2") ? 0 : 1);
        alarmValue = alarmValue + (reverseAlarm.equals("2") ? 0 : reverseAlarm);
        String airLeakageAlarm = params.optString("airLeakageAlarm","2");
        alarmSwitch = alarmSwitch + (airLeakageAlarm.equals("2") ? 0 : 1);
        alarmValue = alarmValue + (airLeakageAlarm.equals("2") ? 0 : airLeakageAlarm);
        alarmSwitch = alarmSwitch + "00";
        alarmValue = alarmValue + "00";
        System.arraycopy(ByteUtils.bitSetStringToBytes(alarmSwitch,false),0,instruct,102,2);
        System.arraycopy(ByteUtils.bitSetStringToBytes(alarmValue,false),0,instruct,104,2);
        //关阀类型 2+2
        String closeValveSwitch = "";
        String closeValveClose = "";
        String gaugeAbnormalValveClose = params.optString("gaugeAbnormalValveClose","2");
        closeValveSwitch = closeValveSwitch + (gaugeAbnormalValveClose.equals("2") ? 0 : 1);
        closeValveClose = closeValveClose + (gaugeAbnormalValveClose.equals("2") ? 0 : gaugeAbnormalValveClose);
        String uvpValveClose = params.optString("uvpValveClose","2");
        closeValveSwitch = closeValveSwitch + (uvpValveClose.equals("2") ? 0 : 1);
        closeValveClose = closeValveClose + (uvpValveClose.equals("2") ? 0 : uvpValveClose);
        closeValveSwitch = closeValveSwitch + "000";
        closeValveClose = closeValveClose + "000";
        String overdraftValveClose = params.optString("overdraftValveClose","2");
        closeValveSwitch = closeValveSwitch + (overdraftValveClose.equals("2") ? 0 : 1);
        closeValveClose = closeValveClose + (overdraftValveClose.equals("2") ? 0 : overdraftValveClose);
        String zeroValveClose = params.optString("zeroValveClose","2");
        closeValveSwitch = closeValveSwitch + (zeroValveClose.equals("2") ? 0 : 1);
        closeValveClose = closeValveClose + (zeroValveClose.equals("2") ? 0 : zeroValveClose);
        String lessValveClose = params.optString("lessValveClose","2");
        closeValveSwitch = closeValveSwitch + (lessValveClose.equals("2") ? 0 : 1);
        closeValveClose = closeValveClose + (lessValveClose.equals("2") ? 0 : lessValveClose);
        String rillValveClose = params.optString("rillValveClose","2");
        closeValveSwitch = closeValveSwitch + (rillValveClose.equals("2") ? 0 : 1);
        closeValveClose = closeValveClose + (rillValveClose.equals("2") ? 0 : rillValveClose);
        String overFlowValveClose = params.optString("overFlowValveClose","2");
        closeValveSwitch = closeValveSwitch + (overFlowValveClose.equals("2") ? 0 : 1);
        closeValveClose = closeValveClose + (overFlowValveClose.equals("2") ? 0 : overFlowValveClose);
        String greaterEmptyingVolumeOffValve = params.optString("greaterEmptyingVolumeOffValve","2");
        closeValveSwitch = closeValveSwitch + (greaterEmptyingVolumeOffValve.equals("2") ? 0 : 1);
        closeValveClose = closeValveClose + (greaterEmptyingVolumeOffValve.equals("2") ? 0 : greaterEmptyingVolumeOffValve);
        String lowPressureOffValve = params.optString("lowPressureOffValve","2");
        closeValveSwitch = closeValveSwitch + (lowPressureOffValve.equals("2") ? 0 : 1);
        closeValveClose = closeValveClose + (lowPressureOffValve.equals("2") ? 0 : lowPressureOffValve);
        String reverseOffValve = params.optString("reverseOffValve","2");
        closeValveSwitch = closeValveSwitch + (reverseOffValve.equals("2") ? 0 : 1);
        closeValveClose = closeValveClose + (reverseOffValve.equals("2") ? 0 : reverseOffValve);
        String leakOffValve = params.optString("leakOffValve","2");
        closeValveSwitch = closeValveSwitch + (leakOffValve.equals("2") ? 0 : 1);
        closeValveClose = closeValveClose + (leakOffValve.equals("2") ? 0 : leakOffValve);
        closeValveSwitch = closeValveSwitch + "00";
        closeValveClose = closeValveClose + "00";
        System.arraycopy(ByteUtils.bitSetStringToBytes(closeValveSwitch,false),0,instruct,106,2);
        System.arraycopy(ByteUtils.bitSetStringToBytes(closeValveClose,false),0,instruct,108,2);
        //计数方式 1+2
        instruct[110] = 0x00;
        Arrays.fill(instruct, 111, 113, (byte) 0xff);

        return getInstruct(instruct, meterCode, meterType, "04AA02", haveNextCmd);
    }

    public static String Recharge(String meterCode, String meterType, JSONObject params) {

        String rechargeAmount = (String) params.get("rechargeAmount");
        String sequence = (String) params.get("sequence");
        String serialNo = (String) params.get("serialNo");

        byte[] instruct = new byte[10];

        rechargeAmount = String.format("%.2f", Double.parseDouble(rechargeAmount)).replace(".", "");

        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(rechargeAmount)), 0, instruct, 6, 4);
        System.arraycopy(ByteUtils.getBytes(Short.parseShort(sequence)),0,instruct,4,2);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(serialNo)),0,instruct,6,4);

        return getInstruct(instruct, meterCode, meterType, "048518", false);

    }

    public static byte[] SetCycleGasVolume(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd) {
        return Commerce30.SetCycleGasVolume(meterCode,meterType,(Map)params.toMap(),haveNextCmd);
    }


    public static byte[] setParams(String meterCode, String meterType, JSONObject params, Boolean haveNextCmd) {
        return Commerce30.SetParameter(meterCode,meterType,(Map)params.toMap(),haveNextCmd);
    }

    public static String endData(String meterCode, String meterType) {
        byte[] instruct = new byte[1];

        return getInstruct(instruct, meterCode, meterType, "05A555", true);
    }

    public static String balanceSync(String meterCode, String meterType, JSONObject params) {


        String balance = (String) params.get("balance");
        String cycleGasVolume = (String) params.get("cycleGasVolume");
        String price = (String) params.get("price");


        cycleGasVolume = String.format("%.2f", Double.parseDouble(cycleGasVolume)).replace(".", "");
        balance = String.format("%.2f", Double.parseDouble(balance)).replace(".", "");
        price = String.format("%.4f", Double.parseDouble(price)).replace(".", "");

        byte[] instruct = new byte[40];

        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(cycleGasVolume)), 0, instruct, 0, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(balance)), 0, instruct, 4, 4);
        System.arraycopy(ByteUtils.getBytes(Integer.parseInt(price)), 0, instruct, 12, 4);
        System.arraycopy(ByteUtils.getBytes(Short.parseShort("0000000010000100", 2)), 0, instruct, 28, 2);

        return getInstruct(instruct, meterCode, meterType, "04A520", false);
    }

    //组合各个指令的HEX字符串
    private static String getInstruct(byte[] instruct, String meterCode, String meterType, String cmdCode, boolean isEnd) {
        byte[] result = new byte[300];

        int dataLen = instruct.length;
        byte deviceType = ByteUtils.hexStrToByte(meterType);

        if (deviceType == 0x0b) {
            byte[] bytes = new byte[]{(byte)(dataLen % 256), (byte) (dataLen / 256)};
            instruct = ByteUtils.concatBytes(bytes, new byte[][]{instruct});
            instruct = AESUtil.encryptPKCS7(instruct, secretKey);
        }
        dataLen = instruct.length + 11;
        result[0] = 0x68;
        result[1] = 0x02;
        if (isEnd) {
            result[2] = 0x00;
        } else {
            result[2] = 0x01;
        }
        byte[] meterno = ByteUtils.hexStrToBytes(meterCode, true);

        System.arraycopy(meterno, 0, result, 5, 6);

        result[11] = 0x68;

        result[12] = ByteUtils.hexStrToByte(cmdCode.substring(0, 2));

        result[13] = (byte) (dataLen % 256);

        result[14] = (byte) (dataLen / 256);

        System.arraycopy(ByteUtils.dateToBcd(new Date(), "YYMMDDHHMISS"), 0, result, 15, 6);
        result[21] = deviceType;

        System.arraycopy(ByteUtils.hexStrToBytes(cmdCode.substring(2, 6), true), 0, result, 22, 2);
        result[24] = 1;
        result[25] = 0;

        System.arraycopy(instruct, 0, result, dataLen + 15 - instruct.length , instruct.length);

        result[dataLen + 15] = calcCs(result);
        result[dataLen + 16] = 0x16;

        byte[] results = new byte[dataLen + 17];

        System.arraycopy(result, 0, results, 0, dataLen + 17);
        return ConvertTools.byteToHexStr(results);

    }

    private static byte calcCs(byte[] bytes) {
        return calcCs(bytes, 0, bytes.length);
    }

    private static byte calcCs(byte[] bytes, int beginIndex, int len) {
        byte cs = 0;

        for(int i = beginIndex; i < beginIndex + len; ++i) {
            cs = (byte)((cs & 255) + (bytes[i] & 255));
        }

        return cs;
    }

    public static JSONObject Decode(byte[] msg) {
        //DecodeResult docodeResult = Commerce30.Decode(msg,haveNextCmd);
        JSONObject array = new JSONObject();
        JSONObject object = new JSONObject();
        boolean isValid = true;
        boolean isNB = false;
        int dataLenght = 0;
        if(msg[0] == 0x68 && msg[11] == 0x68){
            dataLenght = (int) ByteUtils.bytesToInt(msg, 13, 2, true);
            if (22 != msg[15 + dataLenght + 1]) {
                isValid = false;
            } else if (calcCs(msg, 0, 15 + dataLenght) != msg[15 + dataLenght]) {
                isValid = false;
            }
        }
        else {
            isValid = false;
        }

        if (!isValid) {

            object.put("isSuccess",isValid);
            object.put("errCode","1");
            object.put("errMsg","报文格式有误");

            return object;
        }

        String meterCode = ByteUtils.bytesToHexStr(msg, 5 ,6, true);
        String funCode = ByteUtils.byteToHexStr((byte)(msg[12] & 127));
        String time = ByteUtils.bytesToHexStr(msg, 15, 6, false);
        String meterType = ByteUtils.byteToHexStr(msg[21]);
        String cmdCode = ByteUtils.bytesToHexStr(msg, 22, 2, true);
        cmdCode = funCode + cmdCode;

        boolean isEncrypted = (msg[21] & 0xFF) == 0x0b ||  (msg[21] & 0xFF) == 0x08;

        if(!isEncrypted){
            object.put("isSuccess",isEncrypted);
            object.put("errCode","2");
            object.put("errMsg","非NB表");

            return object;
        }


        byte[] data = ByteUtils.copyBytes(msg, 26, dataLenght - 11);
        if((msg[21] & 0xFF) == 0x0b) {

            data = AESUtil.decrypt(data, secretKey);

            int plainLen = (int) ByteUtils.bytesToInt(data, 0, 2, true);

            data = ByteUtils.copyBytes(data, 2, plainLen);
        }else {
            data = ByteUtils.copyBytes(msg, 25, dataLenght - 10);
        }

        try {
            switch (cmdCode) {
                case "05A718":
                case "05A719":
                    //抄表类型 f_upload_type
                    array.put("f_upload_type", data[29]);
                    //电压 f_batteryLevel
                    array.put("f_batteryLevel", CommonTools.div(data[31], 10, 1));
                    //是否低电 f_LowLithiumBattery
                    array.put("f_LowLithiumBattery", data[32]);
                    //采样异常 f_timesException
                    array.put("f_timesException", data[34]);
                    //阀门状态 f_valveState 开 1关
                    array.put("f_valveState", data[35]);

                    //工况累计量 standardConditionTotal
                    double meterDebitAmt = Integer.parseInt(ByteUtils.bytesToHexStr(data, 36, 4, true), 16);
                    array.put("standardConditionTotal", CommonTools.div(meterDebitAmt, 100, 2));

                    //标况累计量 f_tablebase
                    double f_tablebase = Integer.parseInt(ByteUtils.bytesToHexStr(data, 40, 4, true), 16);
                    array.put("f_tablebase", CommonTools.div(f_tablebase, 100, 2));

                    //剩余金额 meterBalance
                    String balance = ByteUtils.bytesToHexStr(data, 52, 4, true);
                    String arrayAccount = ConvertTools.hexStrToBinaryStr(balance);
                    int meterBalance = Integer.parseInt("0" + arrayAccount.substring(1), 2);
                    double meterBalanceAmt = meterBalance;
                    if ("1".equals(arrayAccount.substring(0, 1))) {
                        meterBalanceAmt = -meterBalance;
                    }
                    array.put("meterBalance", CommonTools.div(meterBalanceAmt, 100, 2));

                    //温度 flowmeterTemperature
                    double flowmeterTemperature = Integer.parseInt(ByteUtils.bytesToHexStr(data, 68, 4, true), 16);
                    array.put("flowmeterTemperature", CommonTools.div(flowmeterTemperature, 10000, 4));

                    //压力 flowmeterPressure
                    double flowmeterPressure = Integer.parseInt(ByteUtils.bytesToHexStr(data, 72, 4, true), 16);
                    array.put("flowmeterPressure", CommonTools.div(flowmeterPressure, 10000, 4));

                    //信噪比 f_snr
                    int f_snr = Integer.parseInt(ByteUtils.bytesToHexStr(data, 77, 2, true), 16);
                    array.put("f_snr", (short) f_snr);

                    //信号质量 f_signal
                    int f_signal = Integer.parseInt(ByteUtils.bytesToHexStr(data, 79, 2, true), 16);
                    array.put("f_signal", (short) f_signal);

                    //软件版本号 f_software_version
                    String f_software_version = ByteUtils.bytesToHexStr(data, 102, 2, false);
                    array.put("f_software_version", f_software_version);

                    String IMEI = new String(data, 86, 15);
                    array.put("IMEI", IMEI);


                    array.put("f_hand_date", DateTools.formatDateTime(time, "yyMMddHHmmss"));
                    break;
                case "048530": {
                    boolean success = false;
                    if (data[0] == 0x00) {
                        success = true;
                    }else {
                        array.put("errCode",data[1]);
                    }
                    array.put("success", success);
                    break;
                }
                case "048518":
                case "048519": {
                    boolean success = false;
                    if (data[0] == 0x31 || data[0] == 1) {
                        success = true;
                    }
                    array.put("success", success);
                    break;
                }
                case "048520":
                    array.put("success", data[0]);
                    break;
                case "04A520":
                    array.put("success", true);
                    break;
            }
        }catch (Exception e){
            object.put("isSuccess", false);
            object.put("errCode","-4");
            object.put("errMsg","数据解析错误");
        }
        object.put("isSuccess", isValid);
        object.put("meterCode", meterCode);
        object.put("cmdCode", cmdCode);
        object.put("cmdName", "");
        object.put("time", time);
        object.put("meterType", meterType);
        object.put("dataItems", array);
        object.put("cmdable", true);
        return object;
    }

    public static JSONObject DecodeByFactory(JSONArray array) {
        JSONObject params = new JSONObject();
        //信号强度
        String signal = new JSONObject(array.getString(0)).getString("value");
        JSONObject itemObject = new JSONObject(array.getString(1));
        JSONObject realData =
                getParams(itemObject.getJSONArray("subItems").getJSONArray(0));
        String valveStateValue = realData.getString("param0218");
        //阀门状态
        String valveState;
        switch (valveStateValue) {
            case "0":
                valveState = "0";
                break;
            case "1":
                valveState = "1";
                break;
            default:
                valveState = "2";
                break;
        }
        //电压 f_batteryLevel
        params.put("f_batteryLevel", realData.getString("param0224"));
        //是否低电 f_LowLithiumBattery
        params.put("f_LowLithiumBattery", realData.getString("param0223"));
        //阀门状态 f_valveState 0开 1关
        params.put("f_valveState", valveState);
        //工况累计量 standardConditionTotal
        params.put("standardConditionTotal", realData.getString("param0227"));
        //标况累计量 f_tablebase
        params.put("f_tablebase", realData.getString("param0202"));
        //剩余金额 meterBalance
        params.put("meterBalance", realData.getString("param0203"));
        //温度 flowmeterTemperature
        params.put("flowmeterTemperature", realData.getString("param0230"));
        //压力 flowmeterPressure
        params.put("flowmeterPressure", realData.getString("param0231"));
        //信号质量 f_signal
        params.put("f_signal", signal);
        //软件版本号
        params.put("f_software_version", "0000");
        //抄表时间
        params.put("f_hand_date", DateTools.formatDateTime(realData.getString("param0201"), "yyMMddHHmmss"));
        return params;
    }

    public static JSONObject getParams(JSONArray params) {
        JSONObject object = new JSONObject();
        for (Object obj : params) {
            JSONObject jo = new JSONObject(String.valueOf(obj));
            String result = null;
            if (jo.has("value")) {
                result = jo.getString("value");
            }
            object.put("param" + jo.getString("code"), result);
        }
        return object;
    }

    public static String base64Encode(byte[] bytes) {
        return ConvertTools.base64Encode(bytes);
    }

    public static String base64Encode(String result) {
        return "00";
    }

    public static String getUploadTime(String meternumber) {
        //获取时
        String hour = "0"+CommonTools.getRandomNumber(MIN_HOUR,MAX_HOUR);
        //获取分
        String minute = String.valueOf(CommonTools.getRandomNumber(MIN_MINUTE,MAX_MINUTE));
        if(minute.length() == 1) {
            minute = "0" + minute;
        }
        return "00"+hour+minute;
    }

    public static void main(String[] args) throws DecoderException {
        String result = syncSYParams("111111111111","2",new JSONObject(),false);
        System.out.println(result);
    }

}
