package com.aote.webmeter.module.main.weisidalaidesyncnb;

import com.af.plugins.CommonTools;
import com.af.plugins.ConvertTools;
import com.protocol.WsdMakeCommand;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

public class Tools {

    private static final Map<Integer,String> ERROR_CODE_MAP = new HashMap<>(8);
    private static final Map<Integer,String> REPORT_MODE_MAP = new HashMap<>(30);
    private static final Map<Integer,String> NET_PROVIDER_MAP = new HashMap<>(3);

    static {
        //初始化错误代码Map
        ERROR_CODE_MAP.put(-1,"不是本厂家协议包");
        ERROR_CODE_MAP.put(-2,"数据异常");
        ERROR_CODE_MAP.put(-3,"条码错误");
        ERROR_CODE_MAP.put(-4,"序列号错误");
        ERROR_CODE_MAP.put(-5,"域名错误");
        ERROR_CODE_MAP.put(-6,"CRC错误");
        ERROR_CODE_MAP.put(-7,"终端无法识别的指令");
        ERROR_CODE_MAP.put(-8,"参数有误");
        //初始化上报类型Map
        REPORT_MODE_MAP.put(1,"正常上报");
        REPORT_MODE_MAP.put(2,"按键上报");
        REPORT_MODE_MAP.put(3,"上电上报");
        REPORT_MODE_MAP.put(4,"大流量上报");
        REPORT_MODE_MAP.put(5,"磁攻击上报");
        REPORT_MODE_MAP.put(6,"泄漏上报");
        REPORT_MODE_MAP.put(7,"低电上报");
        REPORT_MODE_MAP.put(8,"少额上报");
        REPORT_MODE_MAP.put(9,"欠费上报");
        REPORT_MODE_MAP.put(10,"透支上报");
        REPORT_MODE_MAP.put(11,"阀门异常上报");
        REPORT_MODE_MAP.put(12,"闲置上报");
        REPORT_MODE_MAP.put(13,"N天不通讯上报");
        REPORT_MODE_MAP.put(14,"频繁通讯上报");
        REPORT_MODE_MAP.put(15,"F卡上报");
        REPORT_MODE_MAP.put(16,"表号卡上报");
        REPORT_MODE_MAP.put(30,"掉电上报");
        REPORT_MODE_MAP.put(31,"拆盖故障上报");
        REPORT_MODE_MAP.put(32,"脉冲断线上报");
        REPORT_MODE_MAP.put(33,"干簧管异常上报");
        REPORT_MODE_MAP.put(34,"电池超压上报");
        REPORT_MODE_MAP.put(35,"ESAM故障上报");
        REPORT_MODE_MAP.put(36,"温压传感器故障上报");
        REPORT_MODE_MAP.put(37,"少额预警关阀上报");
        REPORT_MODE_MAP.put(38,"3D防拆上报");
        REPORT_MODE_MAP.put(39,"恒流异常上报");
        REPORT_MODE_MAP.put(40,"超小流异常上报");
        REPORT_MODE_MAP.put(41,"红外触发上报");
        REPORT_MODE_MAP.put(42,"蓝牙触发上报");
        REPORT_MODE_MAP.put(43,"流量计低电上报");
        //初始化运营商标识Map
        NET_PROVIDER_MAP.put(1,"中国移动");
        NET_PROVIDER_MAP.put(2,"中国联通");
        NET_PROVIDER_MAP.put(3,"中国电信");
    }

    public JSONObject getUploadData(JSONObject metaData){
        JSONObject result = new JSONObject();
        JSONObject standardData = metaData.getJSONArray("list").getJSONObject(0);
        String uploadType = REPORT_MODE_MAP.get(standardData.getInt("reportmode"));
        result.put("f_upload_type",uploadType);
        result.put("f_signal",standardData.getInt("rsrp") / 10);
        result.put("f_snr",standardData.getInt("signalnoise"));
        result.put("f_price",standardData.getDouble("price") / 10);
        result.put("f_times",standardData.getInt("wirelesspaycount"));
        result.put("f_meterBalanceAmt",standardData.getDouble("remaindergasamount"));
        result.put("f_batteryLevel", CommonTools.div(standardData.getInt("batterymillivolt"),1000,4));
        result.put("f_batteryLevel2",CommonTools.div(standardData.getInt("sparebatterymillivolt"),1000,4));
        int valveState = 0;
        //此处表端阀门状态以1-阀开，0-阀关为准
        if(standardData.getInt("isvalveclose") == 0){
            valveState = 1;
        }
        result.put("f_valveState",valveState);
        result.put("f_net_provider",NET_PROVIDER_MAP.get(standardData.getInt("yxsflag")));
        result.put("f_LowLithiumBattery",standardData.getInt("isbatterybad"));
        result.put("f_magneticInterference",standardData.getInt("ismagneticdisturbance"));
        result.put("f_gas_leakage",standardData.getInt("isrevealgas"));
        result.put("f_networkShutValve",standardData.getInt("isremoteclosevalve"));
        result.put("f_abnormal_flow",standardData.getInt("isflowexception"));
        result.put("f_valve_exception",standardData.getInt("isvalveerr"));
        result.put("f_LowLithiumBattery2",standardData.getInt("isinnerbaterr"));
        result.put("f_arrearsShutValue",standardData.getInt("arrearsclosevalue"));
        result.put("f_is_tilt",standardData.getInt("istilt"));
        result.put("f_die_meter",standardData.getInt("diemeter"));
        result.put("f_SplitAlarm",standardData.getInt("disassemble"));
        result.put("f_pulse_disconnection",standardData.getInt("pulsebreak"));
        result.put("f_reed_switch_exception",standardData.getInt("reederr"));
        result.put("soundVelocity",standardData.getDouble("soundvelocity"));
        double temperature = standardData.getDouble("temperature");
        if(temperature == 0){
            temperature = standardData.getDouble("flowtemperature");
        }
        result.put("flowmeterTemperature",temperature);
        double pressure = standardData.getDouble("pressure");
        if(pressure == 0){
            pressure = standardData.getDouble("flowpressure");
        }
        result.put("flowmeterPressure",pressure);
        double cumulunt = standardData.getDouble("cumulunt");
        if(cumulunt == 0){
            cumulunt = standardData.getDouble("flowcumulunt");
        }
        result.put("operatingModeTotal",cumulunt);
        double standardcumulunt = standardData.getDouble("standardcumulunt");
        if(standardcumulunt == 0){
            standardcumulunt = standardData.getDouble("flowstandardcumulunt");
        }
        result.put("standardConditionTotal",standardcumulunt);
        result.put("factoryCurrentSpeed",standardData.getDouble("flowcurrentspeed"));
        result.put("standardCurrentSpeed",standardData.getDouble("flowstandardcurrentspeed"));
        //取24小时用气量数据
        JSONArray useGasData = metaData.getJSONArray("list2");
        if(useGasData.length() > 0){
            StringBuilder useGasStr = new StringBuilder();
            for(int i = 0; i < useGasData.length();i++){
                JSONObject item = useGasData.getJSONObject(i);
                useGasStr.append(ConvertTools.floor(item.getDouble("usegascount"),2)).append(",");
            }
            useGasStr.deleteCharAt(useGasStr.length() - 1);
            result.put("f_nsturalgas_data",useGasStr.toString());
        }
        return result;
    }

    public static void main(String[] args) {
        JSONObject object = new Tools().getUploadData(new JSONObject("{\"finallypackage\":0,\"serial\":637534208,\"list2\":[{\"usegascount\":0,\"metertime\":\"2021-06-23 00:00:14\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 01:00:12\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 02:00:10\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 03:00:10\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 04:00:08\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 05:00:08\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 06:00:06\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 07:00:06\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 08:00:06\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 09:00:04\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 10:00:04\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 11:00:02\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 12:00:02\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 13:00:00\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 14:00:54\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 15:00:52\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 16:00:52\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 17:00:50\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 18:00:50\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 19:00:50\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 20:00:48\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 21:00:48\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 22:00:46\"},{\"usegascount\":0,\"metertime\":\"2021-06-23 23:00:46\"}],\"cmdname\":\"report\",\"isexistcmd\":0,\"list\":[{\"soundvelocity\":0,\"jtusegas\":0,\"batterymillivolt\":6075,\"rsrp\":-810,\"flowcumulunt\":0,\"flowtemperature\":0,\"reederr\":0,\"wirelesspaycount\":0,\"ecl\":\"0\",\"disassemble\":0,\"iccid\":\"89861119232009401247\",\"ljoutlimitsfailure\":0,\"isflowexception\":0,\"totaluse\":9.26,\"price\":22.5,\"state\":1,\"signalnoise\":21,\"isrevealgas\":0,\"isckqvclose\":0,\"isvalveerr\":1,\"flowpressure\":0,\"iswycgqfault\":0,\"pressure\":0,\"cardno\":\"00000000000000\",\"iscommunicationfault\":0,\"ismagneticdisturbance\":0,\"flowmeterdatastatus\":0,\"scrapfailure\":0,\"alarmclosevalue\":0,\"yxsflag\":3,\"communicationstatus\":0,\"communicationmode\":3,\"remaindergasamount\":-9.26,\"maxdailyload\":0,\"purchasegasgross\":0,\"pulsebreak\":0,\"isexternalpoweroff\":0,\"frequencypoint\":2506,\"imsi\":\"460113044070925\",\"cellid\":2097152,\"sparebatterymillivolt\":0,\"istilt\":0,\"standardcumulunt\":48.56,\"iscommunicationgz\":0,\"metertimecumulunt\":48.56,\"pci\":3,\"cumulunt\":48.56,\"temperature\":0,\"flowstandardcurrentspeed\":0,\"isbatterybad\":0,\"flowstandardcumulunt\":0,\"diemeter\":0,\"arrearsclosevalue\":1,\"isckqkf\":0,\"isvalveclose\":0,\"jfmode\":0,\"isinnerbaterr\":0,\"signalintensity\":22,\"isnoposition\":0,\"flowbatterymillivolt\":0,\"isremoteclosevalve\":0,\"metertime\":\"2021-6-24 0:0:4\",\"openaccountstatus\":1,\"imei\":\"861428043074419\",\"flowcurrentspeed\":0,\"securitycheckfailure\":0,\"reportmode\":1,\"meternowtime\":\"2021-6-24 0:0:14\"}],\"barcode\":\"822210618001\",\"cmdstatus\":0}"));

        System.out.println(object);
        System.out.println(new Tools().resolve(ConvertTools.replaceAll("680046010000002601A188000C822210618001B04D067300BDC5F2B3D357ACB873F5DB3B72FCEC4CA699EA0DD14EEB92F4CFCBD160174B963204F3BA38DB79E02764E97B9E90CDA4DAACD1B3B1DCEEC525D4CBA161CFC21EDFB134B2D45C7CD39CA9A59B9920BCFA7BF5EBDD76ADFCD5A71DCFE01F783E46B9E7195EB590561D004208A2D204F4BB98991E76B2E1BD658FA974E563A30A1A37098F6CA37E954B080968C5649366DFED3DAE09E3A85DE092DDC1446EB29778D9DA843200670692F0A2D87A6E04CDE5C841B7647A1869845EACF396DA0D7E45AD37D1B673CA1F540514EEC416B728486CEE8A273AA3D98C901DFEF67B2CA52909296E0E9F18CD2AF17E8A333973759C3971B3CA6BE944DE20282C464681B683508E2DAAB08D1EA7B121D33F0917320F6748A8887F249B07110A04AE3EF1339BF848479550BD13552FAD59474E16")));
    }

    public JSONObject resolve(String metaData){
        StringBuilder data = new StringBuilder();
        int result = WsdMakeCommand.Resolve(metaData,data);
        JSONObject info = new JSONObject();
        info.put("code",result);
        if(result == 0){
            JSONObject realData = new JSONObject(data.toString());
            if(realData.getInt("finallypackage") == 1){
                info.put("code",2);
            } else {
                info.put("data",realData);
            }
        } else {
            info.put("data",ERROR_CODE_MAP.get(result));
        }
        return info;
    }

    public JSONObject openAccount(Object id,JSONObject params){
        StringBuilder command = new StringBuilder();
        int result = WsdMakeCommand.OpenAnAccount(Integer.parseInt(id.toString()),
                params.getString("meterNumber"),
               1,Double.parseDouble(params.getString("balance")),
                0,Double.parseDouble(params.getString("unitPrice")),
                0,command);
        JSONObject info = new JSONObject();
        info.put("code",result);
        if(result == 0){
            info.put("data",command.toString());
        } else {
            info.put("data",ERROR_CODE_MAP.get(result));
        }
        return info;
    }

    public JSONObject valveControl(Object id, JSONObject params){
        StringBuilder command = new StringBuilder();
        int result;
        if(params.getInt("isOpen") == 1){
            result = WsdMakeCommand.Openvalue(Integer.parseInt(id.toString()),params.getString("meterNumber"),command);
        } else {
            result = WsdMakeCommand.CloseCommand(Integer.parseInt(id.toString()),params.getString("meterNumber"),1,command);
        }
        JSONObject info = new JSONObject();
        info.put("code",result);
        if(result == 0){
            info.put("data",command.toString());
        } else {
            info.put("data",ERROR_CODE_MAP.get(result));
        }
        return info;
    }

    public JSONObject syncBalance(Object id, JSONObject params){
        StringBuilder command = new StringBuilder();
        int valve;
        if(params.getInt("isOpen") == 1){
            valve = 0;
        } else {
            valve = 1;
        }
        int result = WsdMakeCommand.Disconnect(Integer.parseInt(id.toString()),params.getString("meterNumber"),
                valve,Double.parseDouble(params.getString("balance")),
                Double.parseDouble(params.getString("balanceGas")),
                Double.parseDouble(params.getString("unitPrice")),
                        Double.parseDouble(params.getString("lastReChargeValue")),command);
        JSONObject info = new JSONObject();
        info.put("code",result);
        if(result == 0){
            info.put("data",command.toString());
        } else {
            info.put("data",ERROR_CODE_MAP.get(result));
        }
        return info;
    }

    public JSONObject setMeterFunctionParams(Object id, JSONObject params){
        StringBuilder command = new StringBuilder();
//        int result = WsdMakeCommand.StartMeterFunction(Integer.parseInt(id.toString()),params.getString("meterNumber"),
//                //不设置 1-设置上电开阀
//                params.getInt("setPowerOnOpenValve"),
//                //0-不设置 1-设置倾斜功能
//                params.getInt("setTiltFunction"),
//                //0-不设置 1-设置震动功能
//                params.getInt("setShockFunction"),
//                //0-不设置 1-设置启用按键清不在位故障
//                params.getInt("setPressKeyClearFault"),
//                //0-不设置 1-设置轮显单价
//                params.getInt("setPollingDisplayPrice"),
//                //0-不设置 1-设置显示异常流量
//                params.getInt("setShowExceptionFlow"),
//                //0-不设置 1-设置金额气量
//                params.getInt("setMoneyOrGas"),
//                //0-不设置 1-设置死表功能
//                params.getInt("setDieMeterFunction"),
//                //0-不设置 1-设置倒扣功能
//                params.getInt("setDeductFunction"),
//                //0-不设置 1-设置泄露报警
//                params.getInt("setLeakageAlarm"),
//                //0-不设置 1-设置拆机报警
//                params.getInt("setDismantleAlarm"),
//                //0-不设置 1-设置脉冲断线功能
//                params.getInt("setPulseDisconnectionFunction"),
//                //0-不设置 1-设置异常流量
//                params.getInt("setExceptionGas"),
//                //0-不设置 1-设置实时任务
//                params.getInt("setRealTimeTask"),
//                //0-不设置 1-设置液晶常显
//                params.getInt("setLiquidCrystalDisplay"),
//                //0-不设置 1-设置欠量关阀
//                params.getInt("setUnderCloseValve"),
//                //0-不设置 1-设置开阀确认
//                params.getInt("setOpenValveConfirm"),
//                //0-不设置 1-设置随机端口
//                params.getInt("setRandomPort"),
//                //0-不设置 1-设置显示评估气量
//                params.getInt("setShowAssessmentGas"),
//                //0-不设置 1-设置后付费表端扣费
//                params.getInt("setPostpaidMeterDeduction"),
//                //0-不设置 1-设置单价 4 位小数
//                params.getInt("setFourDecimalPlacesPrice"),
//                //0-不设置 1-设置电子累计显示
//                params.getInt("setElectronicCumulativeDisplay"),
//                //0-不设置 1-设置蓝牙密钥
//                params.getInt("setBluetoothKey"),
//                //0-不设置 1-设置超小流
//                params.getInt("setUltraSmallFlow"),
//                //0-不设置 1-设置温度补偿
//                params.getInt("setTemperatureCompensation"),
//                //0-不启用 1-启用上电开阀
//                params.getInt("enablePowerOnOpenValve"),
//                //0-不启用 1-启用倾斜功能
//                params.getInt("enableTiltFunction"),
//                //0-不启用 1-启用震动功能
//                params.getInt("enableShockFunction"),
//                //0-不启用 1-启用按键清不在位故障
//                params.getInt("enablePressKeyClearFault"),
//                //0-不启用 1-启用轮显单价
//                params.getInt("enablePollingDisplayPrice"),
//                //0-不启用 1-启用显示异常流量
//                params.getInt("enableShowExceptionFlow"),
//                //0-气量结算 1-金额结算
//                params.getInt("setSettlementModes"),
//                //0-不启用 1-启用死表功能
//                params.getInt("enableDieMeterFunction"),
//                //0-不启用倒扣 1-启用倒扣功能
//                params.getInt("enableDeductFunction"),
//                //0-不启用 1-启用泄露报警
//                params.getInt("enableLeakageAlarm"),
//                //0-不启用 1-启用拆机报警
//                params.getInt("enableDismantleAlarm"),
//                //0-不启用 1-启用脉冲断线功能
//                params.getInt("enablePulseDisconnectionFunction"),
//                //0-不启用 1-启用异常流量
//                params.getInt("enableExceptionGas"),
//                //0-不启用 1-启用实时任务
//                params.getInt("enableRealTimeTask"),
//                //0-不启用 1-启用液晶常显
//                params.getInt("enableLiquidCrystalDisplay"),
//                //0-不启用 1-启用欠量关阀
//                params.getInt("enableUnderCloseValve"),
//                //0-不启用 1-启用开阀确认
//                params.getInt("enableOpenValveConfirm"),
//                //0-不启用 1-启用随机端口
//                params.getInt("enableRandomPort"),
//                //0-不启用 1-启用显示评估气量
//                params.getInt("enableShowAssessmentGas"),
//                //>0-不启用 1-启用后付费表端扣费
//                params.getInt("enablePostpaidMeterDeduction"),
//                //0-不启用 1-启用单价 4 位小数
//                params.getInt("enableFourDecimalPlacesPrice"),
//                //0-不启用 1-启用电子累计显示
//                params.getInt("enableElectronicCumulativeDisplay"),
//                //0-不启用 1-启用蓝牙密钥
//                params.getInt("enableBluetoothKey"),
//                //0-不启用 1-启用超小流
//                params.getInt("enableUltraSmallFlow"),
//                //0-不启用 1-启用温度补偿
//                params.getInt("enableTemperatureCompensation"),
//                0,0,
//                command);
        int result = -1;
        JSONObject info = new JSONObject();
        info.put("code",result);
        if(result == 0){
            info.put("data",command.toString());
        } else {
            info.put("data",ERROR_CODE_MAP.get(result));
        }
        return info;
    }
}
