package com.aote.webmeter.module.main.tianxinsynctcp;


import com.af.plugins.ConvertTools;
import org.apache.commons.codec.DecoderException;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;


public class TianXinTCPSystem {

    private final static Logger log = Logger.getLogger(TianXinTCPSystem.class);


    /**
     * 解析表具上传数据
     *
     * @param resultData 表具上传数据
     * @return 返回对应的数据   {"type" : 0 , "data":{"returnCode":"success" , "meterNumber" : "123456789012"}}
     * @throws DecoderException
     */
    public static JSONObject enCodeData(byte[] resultData) throws DecoderException {
        JSONObject jsonObject = new JSONObject();

        //表返回
        if (resultData[0] == 0x3E) {
            int type = resultData[2];
            jsonObject.put("type", type);
            JSONObject json = new JSONObject();
            if (type == 0x11) {
                json.put("returnCode", "success");
                json.put("meterNumber", byteToHexString(resultData, 3, 8));
//                json.put("meterNumber", getMeterNumber());
                /*标况读数*/
                json.put("meterBase", getDouble(resultData, 31, 8));
                /*温度*/
                json.put("flowmeterTemperature", getFloat(resultData, 55, 4));
                /*压力*/
                json.put("flowmeterPressure", getFloat(resultData, 59, 4));
            } else if (type == 0x14) {
                json.put("returnCode", "success");
            } else if (type == 0x15) {
                json.put("returnCode", "success");
            } else if (type == 0x41) {
                json.put("returnCode", "success");
            } else if (type == 0x04) {
                json.put("returnCode", "success");
            } else if (type == (byte) 0x84) {
                jsonObject.put("type", 0x04);
                json.put("returnCode", "fail");
            }
            jsonObject.put("data", json);

        } else if (resultData[0] == 0x40) {
            jsonObject.put("type", 0);
            JSONObject json = new JSONObject();

            int i = 0;

            while (resultData[i + 2] != 0x49) {
                i++;
            }
            String result = new String(resultData, 2, i, StandardCharsets.UTF_8);
            json.put("returnCode", "success");
            json.put("meterNumber", result);

            jsonObject.put("data", json);

        } else {
            jsonObject.put("type", -1);
        }
        return jsonObject;
    }

    //组合各个指令的HEX字符串
    private String getInstruct(byte[] instruct) throws DecoderException {

        int length = instruct[1] & 0xFF;
        byte[] result = new byte[length];
        result[0] = (byte) 0x3C;
        result[1] = (byte) length;

        System.arraycopy(instruct, 0, result, 0, length);

        byte[] crc16Byte = HexToByte(getCRC(result, length - 2));

        result[length - 2] = crc16Byte[1];
        result[length - 1] = crc16Byte[0];

        return ConvertTools.byteToHexStr(result);
    }

    /**
     * 修改表具ip地址
     *
     * @param IP   ip地址  127.0.0.1
     * @param port 端口号   8080
     * @return 需要发送的Hex字符串
     */

    public String changeMeterIP(String IP, int port) throws DecoderException {

        String[] ips = IP.split("\\.");

        byte[] data = new byte[11];

        data[0] = (byte) 0x3c;
        data[1] = (byte) 0x0C;
        data[2] = (byte) 0x04;

        data[3] = (byte) Integer.parseInt(ips[0]);
        data[4] = (byte) Integer.parseInt(ips[1]);
        data[5] = (byte) Integer.parseInt(ips[2]);
        data[6] = (byte) Integer.parseInt(ips[3]);

        byte[] HexPort = HexToByte(Integer.toHexString(port));

        data[7] = HexPort[1];
        data[8] = HexPort[0];

        return getInstruct(data);

    }

    /**
     * 阀门控制
     *
     * @param type 0：开阀   其他：关阀
     * @return 需要发送的byte数据
     * @throws DecoderException byte与Hex转换错误
     */
    public String ValveControl(String type) throws DecoderException {

        byte[] data = new byte[5];
        data[0] = 0x3C;
        data[1] = 0x05;
        if ("0".equals(type)) {
            data[2] = 0x14;
        } else {
            data[2] = 0x15;
        }

        return getInstruct(data);

    }

    /**
     * 发送获取当前表具数据的指令
     *
     * @return
     * @throws DecoderException
     */
    public String meterRead() throws DecoderException {
        byte[] data = new byte[5];
        data[0] = 0x3C;
        data[1] = 0x05;
        data[2] = 0x11;

        return getInstruct(data);

    }




    /**
     * 下发当前表的结算剩余金额和价格  价格两位小数
     *
     * @return
     * @throws DecoderException
     */
    public String downloadMeterData(int amout, double price) throws DecoderException {
        byte[] data = new byte[17];
        data[0] = 0x3C;
        data[1] = 0x11;
        data[2] = 0x41;

        String int2bad = long2BinaryString(amout);

        byte [] gasByte = ConvertTools.hexStrToByte(ConvertTools.binaryStrToHexStr(int2bad));

        System.arraycopy(gasByte, 0, data, 3, 8);

        String pricebcd = String.format("%.2f", price);

        byte[] bcdbytes = str2bcd(pricebcd);

        System.arraycopy(bcdbytes, 0, data, 11, 4);

        return getInstruct(data);
    }

    public String downloadMeterData(BigDecimal moneyResult, BigDecimal price) throws DecoderException {
        return downloadMeterData(moneyResult.intValue(), price.doubleValue());
    }

    public String downloadMeterData(int moneyResult, BigDecimal price) throws DecoderException {
        return downloadMeterData(moneyResult, price.doubleValue());
    }

    /***
     * 结束通信
     * @return
     * @throws DecoderException
     */
    public String endComm() throws DecoderException {
        byte[] data = new byte[5];
        data[0] = 0x3C;
        data[1] = 0x05;
        data[2] = 0x12;

        return getInstruct(data);

    }

    private static String getCRC(byte[] bytes, int length) {
        int CRC = 0x0000ffff;
        int POLYNOMIAL = 0x0000a001;

        int i, j;
        for (i = 0; i < length; i++) {
            CRC ^= ((int) bytes[i] & 0x000000ff);
            for (j = 0; j < 8; j++) {
                if ((CRC & 0x00000001) != 0) {
                    CRC >>= 1;
                    CRC ^= POLYNOMIAL;
                } else {
                    CRC >>= 1;
                }
            }
        }
        return Integer.toHexString(CRC);
    }

    private  static String long2BinaryString(long num){

        long amout = num;
        if(num < 0){
            amout = -num;
        }

        String ret = Long.toBinaryString(amout);
        while (ret.length() != 64){
            if(ret.length()== 63 && num < 0) {
                ret = "1" + ret;
            }else {
                ret = "0" + ret;
            }

        }
        return  ret;
    }

    private static byte[] HexToByte(String hex) throws DecoderException {


        if ((hex.length() & 0x01) != 0) {
            hex = "0" + hex;
        }
        return ConvertTools.hexStrToByte(hex);
    }

    private static String byteToHexString(byte[] result, int offset, int length) throws DecoderException {

        byte[] hexbyte = new byte[length];

        System.arraycopy(result, offset, hexbyte, 0, length);

        return ConvertTools.byteToHexStr(hexbyte);

    }

    private static double getDouble(byte[] result, int offset, int length) throws DecoderException {

        String hexStr = byteToHexString(result, offset, length);

        long doubleBits = Long.parseLong(hexStr, 16);

        return Double.longBitsToDouble(doubleBits);

    }

    private static Float getFloat(byte[] result, int offset, int length) throws DecoderException {

        String hexStr = byteToHexString(result, offset, length);

        int doubleBits = Integer.parseInt(hexStr, 16);

        return Float.intBitsToFloat(doubleBits);

    }

    public static byte[] str2bcd(String bcd) {

        StringBuilder bcdInteger = new StringBuilder();
        StringBuilder bcdPoint = new StringBuilder();
        bcdInteger.append(bcd.substring(0, bcd.indexOf('.')));
        while (bcdInteger.length() < 4) {
            bcdInteger.insert(0, "0");
        }

        bcdPoint.append(bcd.substring(bcd.indexOf('.') + 1));
        while (bcdPoint.length() < 4) {
            bcdPoint.append("0");
        }
        StringBuilder bcdBuilder = bcdInteger.append(bcdPoint);
        bcd = bcdBuilder.toString();
        // 获取字节数组长度
        int size = bcd.length() / 2;
        int remainder = bcd.length() % 2;

        // 存储BCD码字节
        byte[] bcdByte = new byte[size + remainder];

        // 转BCD码
        for (int i = 0; i < size; i++) {
            int high = Integer.parseInt(bcd.substring(2 * i, 2 * i + 1));
            int low = Integer.parseInt(bcd.substring(2 * i + 1, 2 * i + 2));
            bcdByte[i] = (byte) ((high << 4) | low);
        }


        // 返回BCD码字节数组
        return bcdByte;
    }


    public static void main(String[] args) throws DecoderException {
        String msg = "0300002F2AE00000000000436F6F6B69653A206D737473686173683D41646D696E697374720D0A010008";
        byte[] bytes = ConvertTools.hexStrToByte(msg);
        enCodeData(bytes);
    }

}
