package com.aote.webmeter.module.main.tianxinnb;

import com.af.plugins.ConvertTools;
import com.goldcard.ProtocolUtil;
import org.apache.commons.codec.DecoderException;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


public class TianXinNBTools {

    private final Map<String, String> temps = new ConcurrentHashMap<>();

    static String a = "a2IBJAEFAQC+ASSXAwAAGQV0YRkBhjXAp+p/LwEAAAAAnyQAEHQAAIAdLAS4CwEAQITgBQwMAQBAQg8ATwJxAYgTBwsPFwAmFw8LDxcAJlkHFAc0AEIRARkFIxBHUgUZBSMRACIFGQUjEQUnBRkFIxEQGQUZBSMRERYKGQUjERFEBRkHFhQoAA4ZBxYUUlUOGQcWFFgAASASIQEFIAEhAgYJMycAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHU=";
    static String b = "a2IAHwEFAgC+AAAAAAAAALFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAGo=";
    static String c = "a2IAHwEFAwC+ADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAAA8sXMAADyxcwAAPLFzAABGsnMAAB6ycwAAULNzAABGtHMAAAC0cwAAHrRzAAA8tHMAAFq1cwAAPLZzAAAKtnMAADy3cwAACrhzAAAKunMAAAC7cwAARr1zAAAAvXMAAFC+cwAAWr9zAABGwXMAACjCcwAAPMNzAABGxHMAAFDHcwAAHspzAN8=";
    static String d = "a2IAHwEFBAC+AB7McwAAPM5zAAA8z3MAAFrRcwAAMtNzAAAK03MAAEbUcwAAHtVzAAAU1XMAAEbVcwAAWtZzAAAK1nMAAArWcwAAHtZzAAAo1nMAADzWcwAAUNdzAAAe13MAAEbYcwAACthzAAA82XMAAADZcwAAKNlzAABa2nMAAB7acwAARtpzAABQ2nMAAFDacwAAUNtzAAAU23MAADzccwAAAN1zAAAK3nMAAArecwAARt9zAAAy4HMAADzhcwAAHuFzAMg=";
    static String e = "a2IAHwEFBQClADzicwAAAONzAAAo5XMAAADmcwAAKOdzAAA86HMAAFrpcwAAPOpzAAAA6nMAACjrcwAAAOtzAAAK63MAAEbrcwAAWutzAABa63MAAFrrcwAAWutzAABa63MAAFrrcwAAWutzAABa63MAAFrrcwAAWutzAABa63MAAFrrcwAAWutzAABa63MAAFrrcwAAWutzAABa63MAAFrrcwAAWhEABgA7FrJu9w==";

    private static final Map<Integer, String> CHARGE_STATE = new HashMap<>();
    private static final Map<Integer, String> CHANGE_PRICE_STATE = new HashMap<>();
    private static final Map<Integer, String> VALVE_STATE = new HashMap<>();

    static {
        CHARGE_STATE.put(1,"crc错误");
        CHARGE_STATE.put(2,"卡号错误");
        CHARGE_STATE.put(3,"密钥错误");
        CHARGE_STATE.put(4,"充值次数错误");
        CHARGE_STATE.put(5,"充值上限错误");
        CHARGE_STATE.put(6,"价格未设置错误");
        CHARGE_STATE.put(7,"远程充值未开户");
        VALVE_STATE.put(1,"crc错误");
        VALVE_STATE.put(2,"卡号错误");
        VALVE_STATE.put(3,"密钥错误");
        CHANGE_PRICE_STATE.put(1,"crc错误");
        CHANGE_PRICE_STATE.put(2,"卡号错误");
        CHANGE_PRICE_STATE.put(3,"密钥错误");
        CHANGE_PRICE_STATE.put(4,"调价版本错误");
        CHANGE_PRICE_STATE.put(5,"周期为0");
    }

    public static void main(String[] args) {
        String result = ConvertTools.byteToHexStr(
                ConvertTools.base64Decode(a.getBytes())
        );
        result = result.substring(18,result.length()-2);
        String result2 = ConvertTools.byteToHexStr(
                ConvertTools.base64Decode(b.getBytes())
        );
        result2 = result2.substring(18,result2.length()-2);
        String result3 = ConvertTools.byteToHexStr(
                ConvertTools.base64Decode(c.getBytes())
        );
        result3 = result3.substring(18,result3.length()-2);
        String result4 = ConvertTools.byteToHexStr(
                ConvertTools.base64Decode(d.getBytes())
        );
        result4 = result4.substring(18,result4.length()-2);
        String result5 = ConvertTools.byteToHexStr(
                ConvertTools.base64Decode(e.getBytes())
        );
        result5 = result5.substring(18,result5.length()-2);
        System.out.println(encodeData(result+result2+result3+result4+result5));
        //a2IAHwIFBQABMT4=
        try {
            System.out.println(ConvertTools.base64Encode(ConvertTools.hexStrToByte(resultData("02","05","05",1))));
        } catch (DecoderException decoderException) {
            decoderException.printStackTrace();
        }
        System.out.println(resultData("02","5","5",1));
    }

    //1.解析数据
    public static String encodeData(String data) {
        return ProtocolUtil.analysisCommand(data);
    }

    //开户指令
    public static String openAccount(JSONObject params) {
        String cardno = repliceCardNo(params.getString("cardno"));
        return ProtocolUtil.openAccountTo40(
                params.getString("meterno"),
                cardno,
                params.getString("isPacker")
        );
    }

    //阀门控制
    public static String switchOperator(JSONObject params) {
        return ProtocolUtil.switchOperatorTo40(
                params.getString("meterno"),
                Integer.parseInt(params.getString("type")),
                params.getString("isPacker")
        );
    }

    //远程充值
    public static String recharge(JSONObject params) {
        return ProtocolUtil.rechargeTo40(
                params.getString("meterno"),
                Integer.parseInt(params.getString("money")),
                Integer.parseInt(params.getString("buyNum")),
                params.getString("date"),
                params.getString("isPacker")
        );
    }

    //远程调价
    public static String adjustPrice(JSONObject params) {
        return ProtocolUtil.adjustPriceTo40(
                params.getString("meterno"),
                Integer.parseInt(params.getString("priceVersion")),
                Integer.parseInt(params.getString("period")),
                params.getString("effectiveDate"),
                params.getString("startDate"),
                Integer.parseInt(params.getString("price1")),
                Integer.parseInt(params.getString("price2")),
                Integer.parseInt(params.getString("price3")),
                Integer.parseInt(params.getString("price4")),
                Integer.parseInt(params.getString("price5")),
                Integer.parseInt(params.getString("gasLadder1")),
                Integer.parseInt(params.getString("gasLadder2")),
                Integer.parseInt(params.getString("gasLadder3")),
                Integer.parseInt(params.getString("gasLadder4")),
                params.getString("isPacker")
        );
    }

    //远程通信地址
    public static String updateGprs(JSONObject params) {
        return ProtocolUtil.updateGprsTo40(
                params.getString("meterno"),
                params.getString("ip"),
                Integer.parseInt(params.getString("port")),
                params.getString("isPacker")
        );
    }

    public static String commEndFrame(JSONObject params) {
        return ProtocolUtil.commEndFrameTo40(
                params.getString("meterno"),
                params.getString("date"),
                params.getString("isPacker")
        );
    }

    //卡号补全10位
    private static String repliceCardNo(String cardno) {
        String cardid;
        if (cardno.length() > 10) {
            cardid = cardno.substring(cardno.length() - 10);
        } else {
            StringBuilder cardidBuilder = new StringBuilder(cardno);
            for (int i = 0; i < 10 - cardno.length(); i++) {
                cardidBuilder.insert(0, "0");
            }
            cardid = cardidBuilder.toString();
        }
        return cardid;
    }

    //与华为平台帧返回数据
    public static String resultData(String type, String zhenlength, String part, Integer dataLength) {

        if(zhenlength.length() == 1){
            zhenlength = "0" + zhenlength;
        }
        if(part.length() == 1){
            part = "0" + part;
        }

        int hexInt = Integer.parseInt(type, 16)
                + Integer.parseInt(zhenlength, 16)
                + Integer.parseInt(part, 16) + dataLength
                + Integer.parseInt("31", 16);

        String hex = Integer.toHexString(hexInt);

        String dataLengthValue = Integer.toHexString(dataLength);

        if (dataLengthValue.length() == 3) {
            dataLengthValue = "0" + dataLengthValue;
        } else if (dataLengthValue.length() == 1) {
            dataLengthValue = "000" + dataLengthValue;
        } else if (dataLengthValue.length() == 2) {
            dataLengthValue = "00" + dataLengthValue;
        }

        String result = "6B62001F" + type + zhenlength + part + dataLengthValue + "31" + hex.substring(hex.length() - 2);

        return result.toUpperCase();
    }

    //获取通信结束帧

    public void put(String name, String params) {
        temps.put(name, params);
    }

    public String get(String name) {
        return temps.get(name);
    }

    public void remove(String name) {
        temps.remove(name);
    }

    public static String getChargeState(String type){
        return CHARGE_STATE.get(Integer.parseInt(type));
    }

    public static String getValveState(String type){
        return VALVE_STATE.get(Integer.parseInt(type));
    }

    public static String getChangePriceState(String type){
        return CHANGE_PRICE_STATE.get(Integer.parseInt(type));
    }
}
