package com.aote.webmeter.module.main.taipengsyncnb;

import com.af.plugins.CommonTools;
import com.af.plugins.JsonTools;
import com.aote.webmeter.tools.WebMeterInfo;
import com.cqct.MeterMsgTranslate.MeterMsg;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Util {

    public static JSONObject getContent(String cer, String rtuEcuId,JSONObject content){
        String meterNumber = content.getString("meterNumber");
        if(rtuEcuId == null){
            rtuEcuId = meterNumber;
        }
        JSONObject sendObj = new JSONObject();
        sendObj.put("factoryCode", WebMeterInfo.getString("factoryCode"));
        sendObj.put("partner", WebMeterInfo.getString("partner"));
        sendObj.put("protocolCode", WebMeterInfo.getString("protocolCode"));
        sendObj.put("ser", cer);
        sendObj.put("meterEcuId", meterNumber);
        sendObj.put("version", WebMeterInfo.getString("version"));
        sendObj.put("rtuEcuId", rtuEcuId);
        JsonTools.addJSON(sendObj, content);
        sendObj.put("sign",getSignValue(sendObj.toString(),WebMeterInfo.getString("key")));
        sendObj.put("signType", "MD5");
        return sendObj;
    }

    public static JSONObject analyzeMsg(String meterMsg){
        JSONObject sendObj = new JSONObject();
        sendObj.put("factoryCode", WebMeterInfo.getString("factoryCode"));
        sendObj.put("partner", WebMeterInfo.getString("partner"));
        sendObj.put("meterMsg", meterMsg);
        sendObj.put("version", WebMeterInfo.getString("version"));
        sendObj.put("sign",getSignValue(sendObj.toString(),WebMeterInfo.getString("key")));
        sendObj.put("signType", "MD5");
        return new JSONObject(MeterMsg.analyzeMsg(sendObj.toString()));
    }

    public static JSONObject buildMsg(JSONObject content){
        return new JSONObject(MeterMsg.buildMsg(content.toString()));
    }

    private static String getSignValue(String sJson, String key) {
        JSONObject jo = new JSONObject(sJson);
        JSONObject to = new JSONObject(sJson);
        // 移除空值
        Set<String> set = to.keySet();
        for (String s : set) {
            if ("".equals(to.get(s)) || to.get(s) == null || to.get(s) instanceof JSONArray
                    || to.get(s) instanceof JSONObject) {
                jo.remove(s);
            }
        }
        // 排序输出字符串
        StringBuilder sbu = new StringBuilder();
        List<String> list1 = new ArrayList<>(jo.keySet());
        Collections.sort(list1);
        for (int i = 0; i < list1.size(); i++) {
            char ch = ' ';
            if (i < list1.size() - 1) {
                ch = '&';
            }
            sbu.append(list1.get(i)).append("=").append(jo.get(list1.get(i)).toString()).append(ch);
        }
        String stringSignTemp = sbu.toString().trim() + "&key=" + key;
        String md5str = CommonTools.md5(stringSignTemp);
        return md5str.toUpperCase();
    }
}
