package com.aote.webmeter.module.main.qinchuansystem;

import org.json.JSONException;
import org.json.JSONObject;

public class Tools {
    public static JSONObject responseToFormat(JSONObject content, JSONObject response, String instructId) {
        JSONObject ret = new JSONObject();
        ret.put("status", 1);
        ret.put("receiveMsg", "程序内部错误：格式化请求结果失败");
        ret.put("metaData", content);
        if (instructId != null) {
            ret.put("id", instructId);
        }

        String returnCode;
        String retMessage;
        try {
            returnCode = (String) response.get("returnCode");
            retMessage = (String) response.get("returnMessage");
        } catch (JSONException e) {
            returnCode = "-1";
            retMessage = "";
        }

        if ("0000".equals(returnCode)) {
            ret.put("status", 0);
            ret.put("receiveMsg", "请求发送成功。[" + retMessage + "]");
            ret.put("metaData", content);
        } else if ("-1".equals(returnCode)) {
            ret.put("status", 1);
            ret.put("receiveMsg", "请求发送失败,失败原因：[" + retMessage + "]");
            ret.put("metaData", content);
        } else {
            ret.put("status", 1);
            ret.put("receiveMsg", "请求发送失败，失败原因：[" + retMessage + "]");
            ret.put("metaData", content);
        }
        return ret;
    }

    public static JSONObject responseToFormat(JSONObject content, JSONObject response) {
        return responseToFormat(content, response, null);
    }
}
