package com.aote.webmeter.module.main.qinchuanoldsystem;


import com.af.plugins.ConvertTools;
import com.aote.rs.LogicService;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.*;

@Component
public class Encryption {

	private static Logger logger = Logger.getLogger(Encryption.class);

	private static long date = System.currentTimeMillis();
	private static String Token = null;

	@Autowired
	private LogicService logicService;

	public static String MD5Encryption(JSONObject jo,String key ){
		StringBuilder sb = new StringBuilder();
		Set<String> keySet = jo.keySet();
		List<String> list = new ArrayList<>(keySet);
		Collections.sort(list);
		for (String string : list) {
			Object value = jo.get(string);
			if("".equals(value)){
				continue;
			}
			sb.append(string).append("=").append(value).append("&");
		}
		sb.append("key=").append(key);
		return DigestUtils.md5Hex(sb.toString()).toUpperCase();
	}

	public static String MD5Encryption(String param ){
        return DigestUtils.md5Hex(param);
	}
	public static String Base64Encryption(String param){
		return ConvertTools.base64Encode(param.getBytes(StandardCharsets.UTF_8));
	}
	public static String Base64Encryption(byte[] param){
		return ConvertTools.base64Encode(param);
	}

	public static byte[] SHA1Encryption(String param){
		try {
			MessageDigest md5 = MessageDigest.getInstance("SHA");
			md5.update(param.getBytes(StandardCharsets.UTF_8));
			return md5.digest();
		}catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	public static byte[] Base64Decryption(String param){
		return ConvertTools.base64Decode(param.getBytes(StandardCharsets.UTF_8));
	}

	public static String getUUID(){
		return UUID.randomUUID().toString().replace("-", "");
	}

	public String getToken(){
		long date2 = System.currentTimeMillis();
		if(Token == null || date2 - date > 10 * 60 * 1000){
			try {
				Token = logicService.xtSave("qcGetAuthToken", new JSONObject().toString());
				date = date2;
			}catch (Exception e){
				logger.error("获取Token失败",e);
			}
		}
		return Token;
	}

}
