package com.aote.webmeter.module.main.qianfengsystem;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;

/**
 * 前锋NB物联网表对接兼容工具
 *
 * @author Mrriver
 */
public class QianFengTools {
    public static int generatePSK(String dataStr) {
        dataStr = JSON.toJSONString(JSON.parseObject(dataStr), SerializerFeature.MapSortField);
        // 1. 解析dataStr为char数组
        char[] charArray = dataStr.toCharArray();
        int len = charArray.length;

        // 2. 处理char数组的各个元素，循环三次获取元素，分别进行&、|、^运算
        // 取出元素值，其值对应的ASCII码，依次进行运算，生成3个结果
        // 2.1 第一次循环 &运算
        int int1 = 0;
        for (int i = 1; i < len - 1; i++) {
            if (i == 1) {
                int1 = charArray[1] & charArray[2];
            } else if (i != 2) {
                int1 &= charArray[i];
            }
        }
        int int2 = 0;
        // 2.2 第二次循环 |运算
        for (int i = 0; i < len - 3; i++) {
            if (i == 0) {
                int2 = charArray[0] | charArray[1];
            } else if (i != 1) {
                int2 |= charArray[i];
            }
        }
        // 2.3 第三次循环 ^运算
        int int3 = 0;
        for (int i = 5; i < len; i++) {
            if (i == 5) {
                int3 = charArray[5] ^ charArray[6];
            } else if (i != 6) {
                int3 ^= charArray[i];
            }
        }

        // 3. 生成psk结果
        return int1 + int2 + int3;
    }
}
