package com.aote.webmeter.module.main.piaomiaofengsystem;

import com.aote.webmeter.tools.WebMeterInfo;
import org.json.JSONObject;

import java.nio.charset.StandardCharsets;

/**
 * @PackageName: com.aote.webmeter.module.main.piaomiaofengsystem
 * @ClassName: Util
 * @Author: lin
 * @Date: 2020/11/3 16:42
 * @Description:
 */
public class Util {
    /**
     * 加密
     * @author yangxiang
     * @date 2019/8/19 8:44
     * @param
     * @return 包装后的请求数据
     */
    public JSONObject encode(JSONObject instructContent,Integer excode){
        String channelId = WebMeterInfo.getString("channelId");
        String prefix = "ceb/";
        String bankPwd = (prefix+"ServerBank.pwd");//发送方私钥文件密码文件名
        String bankKey = (prefix+"ServerBank.key");//发送方私钥文件名
        String bankCer = (prefix+"ServerBank.cer");//发送方cer证书文件名

        String htPwd = (prefix+"ServerHt.pwd");//接收方私钥文件密码文件名
        String htKey = (prefix+"ServerHt.key");//接收方私钥文件名
        String htCer = (prefix+"ServerHt.cer");//接收方cer证书文件名

        byte[] bytes = instructContent.toString().getBytes(StandardCharsets.UTF_8);//请求数据明文

        //加密
        String res = OLPcrypt.sender_sign_crypt(bytes, String.valueOf(excode), bankPwd, bankKey, bankCer, htCer);//请求数据sessionKey + sessionData
        assert res != null;
        JSONObject result = new JSONObject(res);
        result.put("channelId",channelId);
        return result;
    }

    /**
     * 解密
     * @author yangxiang
     * @date 2019/8/19 8:44
     * @param
     * @return
     */
    public JSONObject decode(String response){
        String prefix = "ceb/";
        String bankPwd = (prefix+"ServerBank.pwd");//发送方私钥文件密码文件名
        String bankKey = (prefix+"ServerBank.key");//发送方私钥文件名
        String bankCer = (prefix+"ServerBank.cer");//发送方cer证书文件名


        String htPwd = (prefix+"ServerHt.pwd");//接收方私钥文件密码文件名
        String htKey = (prefix+"ServerHt.key");//接收方私钥文件名
        String htCer = (prefix+"ServerHt.cer");//接收方cer证书文件名



        //响应解密
        return OLPdecrypt.sender_decrypt_verify(response, bankPwd, bankKey, htCer);
    }

    /**
     * 解密2
     * @author yangxiang
     * @date 2019/8/19 8:44
     * @param
     * @return
     */
    public JSONObject decode2(String response){
        String prefix = "ceb/";
        String bankPwd = (prefix+"ServerBank.pwd");//发送方私钥文件密码文件名
        String bankKey = (prefix+"ServerBank.key");//发送方私钥文件名
        String bankCer = (prefix+"ServerBank.cer");//发送方cer证书文件名


        String htPwd = (prefix+"ServerHt.pwd");//接收方私钥文件密码文件名
        String htKey = (prefix+"ServerHt.key");//接收方私钥文件名
        String htCer = (prefix+"ServerHt.cer");//接收方cer证书文件名



        //响应解密
        return OLPdecrypt.receiver_decrypt_verify(response, bankPwd, bankKey, htCer);
    }

    public static void main(String[] args) {
        System.out.println(new Util().decode("{\"sessionData\":\"Q9DYYvzRdYnqTXcC1y2q0SOyBIqOpdE4ihqOv5dM48nX5B/O/RYDUgkezwnPdvGQJsMTFCt2vz+sjHf0ZnE76hH76r8F0e0Fa/t5vSVp3mLK0Am4ESoZ1Fahc522+S2b8G0Xkm0brHg6MOgzcZDlLDd55UDFUj/OMcCtwa1Wtxul2KraVtrxPreKdNEiOvgdjM+UIEA/xjQocpQdGM+5Ew+2wrp0TP5JGNuSM3CalGoML1FsqEmTGaSJnPPFkhP33/4Wcy5Tzv12YP1MiMYKeimlmhsmtfyVfpWiYweC/5zaicwvygKvmargm6B8uKJuq+jB/Ak/qCofmVjwSSPA9JuEojVITZq0/leKdOP+7P0iKbLIqAIjGAuJaez6cHkwQ76WV2klhueoZnZa26AmXYaJOG9fmlco3VZRHzLcNOfy2f5NdISByRcLEZ8F8aIxFL6dSDGLPqrJ3bMMPNHnx6RqFd3KK4kGv10D4eZxTbLBMnfocy+HoOWtjI2T05kjrvu315VDJq2sbkZPEo6hUoAlzG2a2NG93Maf2Nn8YSM8Tt5OPuo4CggeGO/0rb7KwEwPb1OIeGW1ewcLPdzjL/EEXIf04B8xpTUOujkpqyp0T+yozuKZkFDbJ16LLtbTUjkn53zagU5eY1wfGqVTAP59QbDazPEseFHAQm9a+i2Xyye3bZMBe1sxLuzKgc+z+L7eSQBqKa+RTvUOQqyJf89GaeVV5FsNVVDa7pu2iUCl/787a1QgtjDJK766XfjLAsbdyLPUM+mFkSoR+BdTQQ2HPI6zjV5mermALHMeurBOlNpGWuuj9TBV6VTYF39lMBI+5ERThcrAIA6suX128ZFRuZ8uLdxKqsMeeeeBeyGrMYKZdeKFOd0PtJBHKxSgfcVbKxm6Ixi9NyRhFO8wHxxX4DRIpHkVC8lfLvcEjOmxhSld3XMkugRStErTnQQVGbMpJMPqlLb2PFkESHj+6B3otR7G38v056xlE0+akr2ujHN7QQb80mUAsMCF3svW7KvzzJ9cS0NEBGdUh9EZ+gBfw6zmBmCgk0o537rUK5Cv/RbKdtIi+bqQuCVT1e14k5BoDWnXP/uYMmgmsuoKEhLnjh8pV6Dmrvy3fC12Wo0Koolhww29rcnLYCbSc3TdksOpnOVCgCOpEOPqyk+ON5SMASeHDf9xJoXOcigxZdfVvZ6CQOUlKw8qAHMzuXaybKigccUNDebId4X1dvQMIhWfnK6kS46aqO9vRKNfxZ80LVyqWbCxJrEqsS+t2Wk85mnMfKwXtIpSustm3UStF1+wPLwmFVIW35S22KykN+dkMK+6juFil/Jvr7VC1bhN+Z14k7DxaOGcD6jvGAYFxe7YF9zOFWwYMopfT3AOTIeIIKEs4WPB8SU9bnBw8vI3pDR/DLLgjox6x4tY58AUDsHNRISwRN9r2ko+7YRsLbpcj6R4oyYteII89/NbI3ak7OXiSejVGeKmAojmk3JKcA==\",\"sessionKey\":\"JDN4Qouy3oTGg4N2tdBs2HTUJEAy2FFIFf43Kg32HN2dg4VHkh1UXF6nttVPdleNNgnpEkKQhhX/4pouUDUnUxodzA/vvgPQQ1MOKZcTAcIoZ7ryLIOoMFehvJbzgx2MNPoK1GJEX6e23CGW3X9pkEIU2g/FDV6aoTHuxdw7eYV3WT8K42NzR+frCmsxqYatLagSiUDA94TbttoR2uLfyQ70R00IZv5t0ncrhHVy6WEd7cR2H4tP3THUGvqbLOWr4JlZtiRMBZl6CuMCQ61UcxtKZY5GwV3+TMSIglUAOo2Gg6kthPd3xczzjowxCzLw+lew0j3TifbC4Z7EbxpOlA==\"}"));
    }
}
