package com.aote.webmeter.module.main.piaomiaofengsystem;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

/**
 * @author 顾法华
 * @since 2017-02-20
 *
 */
public class ResourcesTool {
	static private Logger logger = LoggerFactory.getLogger(ResourcesTool.class);
	
	static public final char[] getResourceAsCharArray(String path) {
		try {
			byte[] buf = getResource(path);
			if (null != buf && buf.length>0) {
				return getChars(buf);
			}
		} catch (Exception e) {
			logger.warn("读取资源出错："+e.getMessage(),e);
		}
		return null;
	}

	static private char[] getChars(byte[] bytes) {
		Charset cs = Charset.forName("UTF-8");
		ByteBuffer bb = ByteBuffer.allocate(bytes.length);
		bb.put(bytes);
		bb.flip();
		CharBuffer cb = cs.decode(bb);
		return cb.array();
	}

	static private byte[] getBytes(char[] chars) {
		Charset cs = Charset.forName("UTF-8");
		CharBuffer cb = CharBuffer.allocate(chars.length);
		cb.put(chars);
		cb.flip();
		ByteBuffer bb = cs.encode(cb);
		return bb.array();
	}

	static public final byte[] getResource(String path) throws Exception {
		InputStream is = null;
		try {
			logger.debug("path:"+path);
			File file = new File(path);
			if(file.exists()){				
				is = new FileInputStream(new File(path));
			}else{
			    is = ResourcesTool.class.getResourceAsStream(path);
			}
			int exceptLen = is.available();
			byte[] buf = new byte[exceptLen];
			int actualReadedLen = is.read(buf);
			if (exceptLen == actualReadedLen) {
//				logger.debug("提取资源{}，{}字节",path,actualReadedLen);
				return buf;
			}
			throw new Exception("读取资源文件长度不正确（expect=" + exceptLen + "，actual=" + actualReadedLen	+ "）");
		} catch (Exception e) {
			logger.warn("读取资源文件出错："+e.getMessage(),e);
			if (null != is) {
				try {
					is.close();
				} catch (Exception e1) {
				}
				is = null;
			}
		}

		return null;
	}

}
