package com.aote.webmeter.module.main.piaomiaofengsystem;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.aote.webmeter.module.main.piaomiaofengsystem.entity.ThirdCommonDecryptResEntity;
import com.aote.webmeter.module.main.piaomiaofengsystem.entity.ThirdCommonReqEntity;
import com.lsy.baselib.crypto.algorithm.DESede;
import com.lsy.baselib.crypto.algorithm.RSA;
import com.lsy.baselib.crypto.util.Base64;
import com.lsy.baselib.crypto.util.CryptUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Arrays;

/**
 * 请求或回应解密并验证签名及文件解密类
 */
public class OLPdecrypt {

    private static final Logger log = LoggerFactory.getLogger(OLPdecrypt.class);

    /**
     * B方接收 请求解密
     *
     * @param bytePlain           接收的报文头和密文报文体 sessionKey+sessionData
     * @param receiverPwdFileName 接收方私钥文件密码文件名
     * @param receiverKeyFileName 接收方私钥文件名
     * @param senderCerFileName   发送方cer证书文件名
     * @return 得到A方随机会话密钥明文
     */
    public static org.json.JSONObject receiver_decrypt_verify(String bytePlain, String receiverPwdFileName, String receiverKeyFileName, String senderCerFileName) {

        byte[] mw = null;
        byte[] dataBytes = null;
        try {
            long beginTime = System.currentTimeMillis();
            log.info("======receiver_decrypt_verify请求参数1bytePlain：{}，2receiverPwdFileName：{}，3receiverKeyFileName：{}，4senderCerFileName：{}", bytePlain, receiverPwdFileName, receiverKeyFileName, senderCerFileName);
            ThirdCommonReqEntity thirdCommonReqEntity = JSONObject.parseObject(bytePlain, ThirdCommonReqEntity.class, Feature.OrderedField);
            if (thirdCommonReqEntity == null) {
                log.info("======bankEncpReqEntity为null");
                return null;
            }

            String sessionKey = thirdCommonReqEntity.getSessionKey();
            log.info("receiver_decrypt_verify======sessionKey：{}", sessionKey);
            String sessionData = thirdCommonReqEntity.getSessionData();
            log.info("receiver_decrypt_verify======sessionData：{}", sessionData);


            char[] recverPrivKeyPass = ResourcesTool.getResourceAsCharArray(receiverPwdFileName);
            byte[] base64EncodedPrivatekey = ResourcesTool.getResource(receiverKeyFileName);
            PrivateKey recverPrivKey = CryptUtil.decryptPrivateKey(Base64.decode(base64EncodedPrivatekey), recverPrivKeyPass); //获得B方证书私钥
            byte[] encoded = recverPrivKey.getEncoded();
            log.info("receiver_decrypt_verify解密======获取B方证书私钥：{}", Arrays.toString(encoded));

            /**
             * *********************第1步
             * 解析得到Base64编码A方产生的随机密钥密文，使用B方的证书私钥解密，得到A方会话密钥明文
             */


            byte[] bytes = sessionKey.getBytes(StandardCharsets.UTF_8);
            String s1 = Arrays.toString(bytes);
            log.info("receiver_decrypt_verify解密*****会话密钥密文：{}", s1);
            byte[] sessionKeyBytes = Base64.decode(bytes);//得到Base64解码之后的A方的随机会话秘钥密文
            String s2 = Arrays.toString(sessionKeyBytes);
            log.info("receiver_decrypt_verify解密*****Base64之后的会话秘钥密文：{}", s2);
            byte[] byteSessionkey = RSA.decrypt(sessionKeyBytes, encoded);//得到A方随机会话密钥明文
            mw = byteSessionkey;
            log.info("receiver_decrypt_verify解密======获取A方随机会话秘钥明文：{}", Arrays.toString(byteSessionkey));

            /**
             * *********************第2步
             * 使用Base64解码后，使用A方的会话密钥明文，对sessionData进行3DES ede解密，得到明文：signature+交易代码+明文请求数据
             */
            byte[] iv = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
            byte[] sessionDataBytes = DESede.decrypt(Base64.decode(sessionData.getBytes(StandardCharsets.UTF_8)), byteSessionkey, iv);//获得signature+交易代码+明文请求数据
            String sessionDatas = new String(sessionDataBytes,StandardCharsets.UTF_8);
            log.debug(sessionDatas);
            org.json.JSONObject data = new org.json.JSONObject(sessionDatas);
            log.info("receiver_decrypt_verify返回数据======：{}", data);
            return data;//返回 A方随机会话密钥明文 + 请求数据明文
        } catch (Exception e) {
            log.error("receiver_decrypt_verify解密失败：{}", e.getMessage());
            String str = null;
            ThirdCommonDecryptResEntity thirdCommonDecryptResEntity = new ThirdCommonDecryptResEntity();
            try {
                str = new String(mw, "ISO8859-1");
                log.info("======ISO8859-1：{}", str);
                thirdCommonDecryptResEntity.setPrivateKeyMw(str);
                thirdCommonDecryptResEntity.setRes("02");
                String sessionDatas = new String(dataBytes, "UTF-8");
                log.debug(sessionDatas);
                org.json.JSONObject data = new org.json.JSONObject(sessionDatas);
                log.info("receiver_decrypt_verify返回数据======：{}", data);
                return data;
            } catch (Exception e1) {
                log.error("receiver_decrypt_verify异常：{}", e);
                return null;
            }
        }
    }

    /**
     * 请求方A接收 响应解密
     *
     * @param bytePlain              接收的响应报文头和密文报文体 sessionKey+sessionData
     * @param senderPwdFileName      发送方私钥文件密码文件名
     * @param senderKeyFileName      发送方私钥文件名
     * @param receiverKeyCerFileName 接收方cer证书文件名
     * @return 验证签名结果是否一致
     */
    public static org.json.JSONObject sender_decrypt_verify(String bytePlain, String senderPwdFileName, String senderKeyFileName, String receiverKeyCerFileName) {
        try {
            long beginTime = System.currentTimeMillis();

            log.info("======sender_decrypt_verify请求参数1bytePlain：{}，2senderPwdFileName：{}，3senderKeyFileName：{}，4receiverKeyCerFileName：{}", bytePlain, senderPwdFileName, senderKeyFileName, receiverKeyCerFileName);
            ThirdCommonReqEntity thirdCommonReqEntity = JSONObject.parseObject(bytePlain, ThirdCommonReqEntity.class);
            if (thirdCommonReqEntity == null) {
                return null;
            }

            String sessionKey = thirdCommonReqEntity.getSessionKey();
            log.info("sender_decrypt_verify======sessionKey：{}", sessionKey);
            String sessionData = thirdCommonReqEntity.getSessionData();
            log.info("sender_decrypt_verify======sessionData：{}", sessionData);

            char[] recverPrivKeyPass = ResourcesTool.getResourceAsCharArray(senderPwdFileName);
            byte[] base64EncodedPrivatekey = ResourcesTool.getResource(senderKeyFileName);
            PrivateKey recverPrivKey = CryptUtil.decryptPrivateKey(Base64.decode(base64EncodedPrivatekey), recverPrivKeyPass); //获得A方证书私钥


            /**
             * *********************第1步
             * 解析得到Base64编码A方产生的随机密钥密文，使用A方的证书私钥解密，得到A方会话密钥明文
             */
            byte[] sessionKeyBytes = Base64.decode(sessionKey.getBytes());//得到Base64解码之后的A方的随机会话秘钥密文
            byte[] byteSessionkey = RSA.decrypt(sessionKeyBytes, recverPrivKey.getEncoded());//得到A方随机会话密钥明文


			/**
			 * *********************第2步
			 * 使用Base64解码后，使用A方的会话密钥明文，对sessionData进行3DES ede解密，得到明文：signature+交易代码+明文请求数据
			 */
			byte[] iv = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
			byte[] sessionDataBytes = DESede.decrypt(Base64.decode(sessionData.getBytes(StandardCharsets.UTF_8)), byteSessionkey, iv);//获得signature+交易代码+明文请求数据


            /**
             * *********************第3步
             * 使用请求方A的证书公钥，验证请求报文明文signature的签名是否无误
             */

            long endTime = System.currentTimeMillis();
            log.info("sender_decrypt_verify======解密处理耗时: " + (endTime - beginTime) + " ms");

            String sessionDatas = new String(sessionDataBytes,StandardCharsets.UTF_8);
            org.json.JSONObject data = new org.json.JSONObject(sessionDatas);
            log.info("sender_decrypt_verify返回数据======：{}", data);
            return data.getJSONObject("data");
        } catch (Exception e) {
            log.error("sender_decrypt_verify解密失败：{}", e.getMessage());
            return null;
        }
    }

}
