package com.aote.webmeter.module.main.piaomiaofengsystem;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.aote.webmeter.module.main.piaomiaofengsystem.entity.ThirdCommonReqEntity;
import com.aote.webmeter.module.main.piaomiaofengsystem.entity.ThirdCommonSessionDataEntity;
import com.lsy.baselib.crypto.algorithm.DESede;
import com.lsy.baselib.crypto.algorithm.RSA;
import com.lsy.baselib.crypto.protocol.PKCS7Signature;
import com.lsy.baselib.crypto.util.Base64;
import com.lsy.baselib.crypto.util.CryptUtil;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;

/**
 * 请求或回应报文加密/加签名及文件加密类
 *
 */
public class OLPcrypt {

	private static final Logger log = LoggerFactory.getLogger(OLPcrypt.class);

	/**
     * 发送请求加密  A方
     * @param bytePlain 请求数据明文
	 * @param excode 交易代码
     * @param senderPwdFileName 发送方私钥加密密码文件名
     * @param senderKeyFileName 发送方私钥文件名
     * @param senderCerFileName 发送方cer证书文件名
     * @param receiverCerFileName 接收方cer证书文件名
     * @return 加密后的报文
     */
	public static String sender_sign_crypt(byte[] bytePlain, String excode,String senderPwdFileName, String senderKeyFileName, String senderCerFileName, String receiverCerFileName) {
		try {
			log.info("======sender_sign_crypt请求参数：1bytePlain{},2excode：{},3senderPwdFileName：{},4senderKeyFileName：{},5senderCerFileName：{},6receiverCerFileName：{}",bytePlain,excode,senderPwdFileName,senderKeyFileName,senderCerFileName,receiverCerFileName);

			char[] keyPassword = ResourcesTool.getResourceAsCharArray(senderPwdFileName) ;
			byte[] base64EncodedPrivatekey = ResourcesTool.getResource(senderKeyFileName);
			PrivateKey signerPrivatekey = CryptUtil.decryptPrivateKey(Base64.decode(base64EncodedPrivatekey), keyPassword);//获得A方私钥


			byte[] base64EncodedCert = ResourcesTool.getResource(senderCerFileName);//读取A方cer证书
			X509Certificate signerCertificate = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedCert));//获得A方的证书


			/**
			 * *****************第1步
			 * 请求方A产生随机会话密钥，再用接收方B的证书公钥加密，结果使用Base64编码：
			 * 得到sessionKey：Base64编码随机密钥密文
			 */

			byte[] sessionKey = DESede.createKey(DESede.DESEDE_KEY_112_BIT); //产生A方 随机会话密钥明文
			log.info("加密======产生A方随机会话密钥明文：{}",Arrays.toString(sessionKey));

			byte[] base64EncodedCert2 = ResourcesTool.getResource(receiverCerFileName);//读取B方证书
			X509Certificate cert2 = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedCert2));//获得B方的证书
			PublicKey pubKey2 = cert2.getPublicKey();//获取B方证书公钥
			byte[] pubKey2Encoded = pubKey2.getEncoded();
			 log.info("加密======获取B方证书公钥：{}",Arrays.toString(pubKey2Encoded));

			byte[] sessionKeyCipher = RSA.encrypt(sessionKey,pubKey2Encoded );//使用A方随机会话密钥明文 +  使用B方证书公钥 --》进行加密 产生随机密码密文
			String s1 = Arrays.toString(sessionKeyCipher);
			log.info("加密######会话密钥密文：{}",s1);
			byte[] encode = Base64.encode(sessionKeyCipher);//使用Base64编码随机密码密文 得到sessionKey
			String s2 = Arrays.toString(encode);
			log.info("加密######Base64之后的会话秘钥密文：{}",s2);

			/**
			 * *****************第2步
			 * 请求方A对请求报文明文，使用A方证书私钥进行签名，结果使用Base64编码：
			 * signature：Base64
			 */

			byte[] signature = PKCS7Signature.sign(bytePlain, signerPrivatekey, signerCertificate, null, false); //A方请求明文 +  A方证书私钥 --》生成签名
			String b64StrSignature = new String(Base64.encode(signature), StandardCharsets.UTF_8);//对签名进行Base64编码


			/**
			 * *****************第3步
			 * 使用第1步的随机会话密钥明文，对（signature+交易代码+明文请求数据），进行3DES ede加密，结果使用Base64编码
			 * sessionData：Base64
			 */


			ThirdCommonSessionDataEntity thirdCommonSessionDataEntity = new ThirdCommonSessionDataEntity();
			thirdCommonSessionDataEntity.setSignature(b64StrSignature);
			thirdCommonSessionDataEntity.setExcode(excode);
			thirdCommonSessionDataEntity.setData(new String(bytePlain,StandardCharsets.UTF_8));

			String jsonString1 = JSONObject.toJSONString(thirdCommonSessionDataEntity, SerializerFeature.WriteNullStringAsEmpty);
			jsonString1 = StringEscapeUtils.unescapeJavaScript(jsonString1);
			jsonString1 = jsonString1.replaceAll("\"\\{","{");
			jsonString1 = jsonString1.replaceAll("\\}\"","}");
			log.info("【第三方通用】加密数据明文data:{}",jsonString1);
			byte[] bytes = jsonString1.getBytes(StandardCharsets.UTF_8);


			byte[] iv = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
			byte[] cryptMsg = Base64.encode(DESede.encrypt(bytes, sessionKey, iv));//使用A方随机会话密钥明文，进行3DES ede加密，最后使用Base64编码


			/**
			 * *****************第4步
			 * 组成待发送请求数据
			 * json格式的字符串：sessionKey + sessionData【第3步的结果】
			 */


			ThirdCommonReqEntity thirdCommonReqEntity = new ThirdCommonReqEntity();
			String sessionKeyStr = new String(encode);
			log.info("======sessionKeyStr======{}",sessionKeyStr);
			thirdCommonReqEntity.setSessionKey(sessionKeyStr);

			String sessionDataStr = new String(cryptMsg, StandardCharsets.UTF_8);
			log.info("======sessionDataStr======{}",sessionDataStr);
			thirdCommonReqEntity.setSessionData(sessionDataStr);

			String jsonString = JSONObject.toJSONString(thirdCommonReqEntity, SerializerFeature.WriteNullStringAsEmpty);
			log.info("sender_sign_crypt返回报文：{}",jsonString);
			long endTime = System.currentTimeMillis();
			return jsonString;
		} catch (Exception e) {
			log.error("sender_sign_crypt报文加密失败：{}",e.getMessage());
			return null;
		}
	}


	/**
	 * 响应结果加密 B方
	 * @param byteSessionkey A方随机会话密钥明文
	 * @param bytePlain 响应明文
	 * @param excode 交易代码
	 * @param receiverPwdFileName 接收方私钥加密密码文件名
	 * @param receiverKeyFileName 接收方私钥文件名
	 * @param receiverCerFileName 接收方cer证书文件名
	 * @param senderCerFileName  发送方cer证书文件名
	 */
	public static String receiver_sign_crypt(byte[] byteSessionkey,byte[] bytePlain, String excode,String receiverPwdFileName, String receiverKeyFileName, String receiverCerFileName, String senderCerFileName) {
		try {
			long beginTime = System.currentTimeMillis();
			log.info("======receiver_sign_crypt请求参数：0byteSessionkey：{},1bytePlain：{},2excode：{},3receiverPwdFileName：{},4receiverKeyFileName：{},5receiverCerFileName：{},6senderCerFileName：{}",byteSessionkey,bytePlain,excode,receiverPwdFileName,receiverKeyFileName,senderCerFileName,receiverCerFileName);

			/**
			 * *****************第1步
			 *接收方B使用上述A方请求数据中的随机会话密钥明文，再用请求方A的证书公钥加密，结果使用Base64编码
			 *sessionKey：Base64编码密钥密文
			 */

			byte[] base64EncodedCert = ResourcesTool.getResource(senderCerFileName);//读取A方cer证书
			X509Certificate signerCertificate = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedCert));//获得A方的证书

			PublicKey senderPubKey = signerCertificate.getPublicKey();//获取A方的公钥
			byte[] encoded = senderPubKey.getEncoded();

			log.info("======receiver_sign_crypt获取A方公钥：{}",Arrays.toString(encoded));

			byte[] sessionKeyCipher = RSA.encrypt(byteSessionkey,encoded);//使用A方随机会话密钥明文 +  使用A方证书公钥 --》进行加密 产生随机密码密文
			log.info("======receiver_sign_crypt产生随机密码密文：{}",Arrays.toString(sessionKeyCipher));
			byte[] sessionKey = Base64.encode(sessionKeyCipher);//使用Base64编码随机密码密文 得到sessionKey
			log.info("======receiver_sign_crypt====Base64编码随机密码密文：{}",Arrays.toString(sessionKey));


			/**
			 * *****************第2步
			 * 接收方B对明文回应报文使用B方证书私钥进行签名，结果使用Base64编码，用标签括起：
			 *signature：Base64编码签名值
			 */

			char[] keyPassword = ResourcesTool.getResourceAsCharArray(receiverPwdFileName) ;
			byte[] base64EncodedPrivatekey = ResourcesTool.getResource(receiverKeyFileName);
			PrivateKey signerPrivatekey = CryptUtil.decryptPrivateKey(Base64.decode(base64EncodedPrivatekey), keyPassword);//获得B方证书私钥

			byte[] receiverCer = ResourcesTool.getResource(receiverCerFileName);
			X509Certificate receiverCert = CryptUtil.generateX509Certificate(Base64.decode(receiverCer));//获得B方证书

			byte[] signature = PKCS7Signature.sign(bytePlain, signerPrivatekey, receiverCert, null, false); //B方响应明文 +  B方证书私钥 + B方证书 --》生成签名
			log.info("receiver_sign_crypt====signature：{}",Arrays.toString(signature));
			String b64StrSignature = new String(Base64.encode(signature));//对签名进行Base64编码
			log.info("receiver_sign_crypt====b64StrSignature：{}",b64StrSignature);


			/**
			 * *****************第3步
			 * 使用第1步的会话密钥对（signature+交易代码+明文回应数据）进行3DES ede加密，结果使用Base64编码
			 * sessionData：Base64编码
			 */

			ThirdCommonSessionDataEntity thirdCommonSessionDataEntity = new ThirdCommonSessionDataEntity();
			thirdCommonSessionDataEntity.setSignature(b64StrSignature);
			thirdCommonSessionDataEntity.setExcode(excode);
			String data = new String(bytePlain);
			log.info("响应数据data:{}",data);
			thirdCommonSessionDataEntity.setData(data);

			String jsonString1 = JSONObject.toJSONString(thirdCommonSessionDataEntity, SerializerFeature.WriteNullStringAsEmpty);
			log.info("响应给银行明文：{}",jsonString1);
			jsonString1 = StringEscapeUtils.unescapeJavaScript(jsonString1);
			log.info("响应给银行明文去除反斜杠：{}",jsonString1);
			int len = jsonString1.indexOf(data);
			int lenEnd = len + data.length();
			jsonString1 = jsonString1.substring(0,len-1) + data + jsonString1.substring(lenEnd+1);
			log.info("响应给银行明文去data两边除双引号：{}",jsonString1);
			byte[] bytes = jsonString1.getBytes("UTF-8");


			byte[] iv = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
			byte[] cryptMsg = Base64.encode(DESede.encrypt(bytes, byteSessionkey, iv));//使用A方的会话密钥明文，进行3DES ede加密，最后使用Base64编码
			log.info("receiver_sign_crypt======cryptMsg：{}",Arrays.toString(cryptMsg));

			/**
			 * *****************第4步
			 * 组成待发送请求数据
			 * json格式的字符串：sessionKey + sessionData【第3步的结果】
			 */

			ThirdCommonReqEntity thirdCommonReqEntity = new ThirdCommonReqEntity();
			String sessionKeyStr = new String(sessionKey);
			log.info("receiver_sign_crypt响应加密======sessionKeyStr======{}",sessionKeyStr);
			thirdCommonReqEntity.setSessionKey(sessionKeyStr);

			String sessionDataStr = new String(cryptMsg);
			log.info("receiver_sign_crypt响应加密======sessionDataStr======{}",sessionDataStr);
			thirdCommonReqEntity.setSessionData(sessionDataStr);

			String jsonString = JSONObject.toJSONString(thirdCommonReqEntity, SerializerFeature.WriteNullStringAsEmpty);
			log.info("receiver_sign_crypt返回报文：{}",jsonString);
			long endTime = System.currentTimeMillis();
			return jsonString;
		} catch (Exception e) {
			log.error("receiver_sign_crypt报文加密失败：{}",e.getMessage());
			return null;
		}
	}

	/**
	 * 发送请求加密  A方
	 * @param bytePlain 请求数据明文
	 * @param excode 交易代码
	 * @param senderPwdFileName 发送方私钥加密密码文件名
	 * @param senderKeyFileName 发送方私钥文件名
	 * @param senderCerFileName 发送方cer证书文件名
	 * @param receiverCerFileName 接收方cer证书文件名
	 * @return 加密后的报文
	 */
	public static String sender_sign_cryptNew(byte[] bytePlain, String excode,String senderPwdFileName, String senderKeyFileName, String senderCerFileName, String receiverCerFileName) {
		try {
			long beginTime = System.currentTimeMillis();
			log.info("======sender_sign_crypt请求参数：1bytePlain{},2excode：{},3senderPwdFileName：{},4senderKeyFileName：{},5senderCerFileName：{},6receiverCerFileName：{}",bytePlain,excode,senderPwdFileName,senderKeyFileName,senderCerFileName,receiverCerFileName);

			char[] keyPassword = ResourcesTool.getResourceAsCharArray(senderPwdFileName) ;
			byte[] base64EncodedPrivatekey = ResourcesTool.getResource(senderKeyFileName);
			PrivateKey signerPrivatekey = CryptUtil.decryptPrivateKey(Base64.decode(base64EncodedPrivatekey), keyPassword);//获得A方私钥


			byte[] base64EncodedCert = ResourcesTool.getResource(senderCerFileName);//读取A方cer证书
			X509Certificate signerCertificate = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedCert));//获得A方的证书


			/**
			 * *****************第1步
			 * 请求方A产生随机会话密钥，再用接收方B的证书公钥加密，结果使用Base64编码：
			 * 得到sessionKey：Base64编码随机密钥密文
			 */

			byte[] sessionKey = DESede.createKey(DESede.DESEDE_KEY_112_BIT); //产生A方 随机会话密钥明文
			log.info("加密======产生A方随机会话密钥明文：{}",Arrays.toString(sessionKey));

			byte[] base64EncodedCert2 = ResourcesTool.getResource(receiverCerFileName);//读取B方证书
			X509Certificate cert2 = CryptUtil.generateX509Certificate(Base64.decode(base64EncodedCert2));//获得B方的证书
			PublicKey pubKey2 = cert2.getPublicKey();//获取B方证书公钥
			byte[] pubKey2Encoded = pubKey2.getEncoded();
			log.info("加密======获取B方证书公钥：{}",Arrays.toString(pubKey2Encoded));

			byte[] sessionKeyCipher = RSA.encrypt(sessionKey,pubKey2Encoded );//使用A方随机会话密钥明文 +  使用B方证书公钥 --》进行加密 产生随机密码密文
			String s1 = Arrays.toString(sessionKeyCipher);
			log.info("加密######会话密钥密文：{}",s1);
			byte[] encode = Base64.encode(sessionKeyCipher);//使用Base64编码随机密码密文 得到sessionKey
			String s2 = Arrays.toString(encode);
			log.info("加密######Base64之后的会话秘钥密文：{}",s2);

			/**
			 * *****************第2步
			 * 请求方A对请求报文明文，使用A方证书私钥进行签名，结果使用Base64编码：
			 * signature：Base64
			 */

			byte[] signature = PKCS7Signature.sign(bytePlain, signerPrivatekey, signerCertificate, null, false); //A方请求明文 +  A方证书私钥 --》生成签名
			String b64StrSignature = new String(Base64.encode(signature));//对签名进行Base64编码


			/**
			 * *****************第3步
			 * 使用第1步的随机会话密钥明文，对（signature+交易代码+明文请求数据），进行3DES ede加密，结果使用Base64编码
			 * sessionData：Base64
			 */


			ThirdCommonSessionDataEntity thirdCommonSessionDataEntity = new ThirdCommonSessionDataEntity();
			thirdCommonSessionDataEntity.setSignature(b64StrSignature);
			thirdCommonSessionDataEntity.setExcode(excode);
			thirdCommonSessionDataEntity.setData(new String(bytePlain));

			String jsonString1 = JSONObject.toJSONString(thirdCommonSessionDataEntity, SerializerFeature.WriteNullStringAsEmpty);
			byte[] bytes = jsonString1.getBytes("UTF-8");


			byte[] iv = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
			byte[] cryptMsg = Base64.encode(DESede.encrypt(bytes, sessionKey, iv));//使用A方随机会话密钥明文，进行3DES ede加密，最后使用Base64编码


			/**
			 * *****************第4步
			 * 组成待发送请求数据
			 * json格式的字符串：sessionKey + sessionData【第3步的结果】
			 */


			ThirdCommonReqEntity thirdCommonReqEntity = new ThirdCommonReqEntity();
			String sessionKeyStr = new String(encode);
			log.info("======sessionKeyStr======{}",sessionKeyStr);
			thirdCommonReqEntity.setSessionKey(sessionKeyStr);

			String sessionDataStr = new String(cryptMsg,"UTF-8");
			log.info("======sessionDataStr======{}",sessionDataStr);
			thirdCommonReqEntity.setSessionData(sessionDataStr);

			String jsonString = JSONObject.toJSONString(thirdCommonReqEntity, SerializerFeature.WriteNullStringAsEmpty);
			log.info("sender_sign_crypt返回报文：{}",jsonString);
			long endTime = System.currentTimeMillis();
			return jsonString;
		} catch (Exception e) {
			log.error("sender_sign_crypt报文加密失败：{}",e.getMessage());
			return null;
		}
	}
}
