package com.aote.webmeter.module.main.nb.impl.songchuan;

import com.af.plugins.CommonTools;
import com.af.plugins.ConvertTools;
import com.af.plugins.DateTools;
import com.aote.webmeter.module.main.nb.impl.MeterTools;
import org.json.JSONObject;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;


/**
 * 松川NB-IOT封装
 */
public class SongChuanNBTools extends MeterTools {

    private static final String hexKey = "11213141516171811222324252627282";
    private static Map<String,String> randoms = new ConcurrentHashMap<>();

    @Override
    public String openAccount(JSONObject jsonObject) throws Exception {
        //消息序号
        String count = jsonObject.get("instructCount").toString();
        //注册帧获取的随机数
        String meterNumber = jsonObject.getString("meternumber");
       // String random = randoms.get(meterNumber);
        String random = jsonObject.getString("random");
        byte[] randomByte = ConvertTools.hexStrToByte(random);

        byte[] data = new byte[8];
        byte[] dateByte = date2bcd(DateTools.getNow("yyMMddHHmmss"),false);
        System.arraycopy(dateByte,0,data,2,6);

        int control = Integer.parseInt("10000001",2);

        return getInstruct("3001",control,Integer.parseInt(count),data,randomByte,false,true);
    }

    @Override
    public String charge(JSONObject jsonObject) throws Exception {
        return null;
    }

    @Override
    public String changePrice(JSONObject jsonObject) throws Exception {
        return null;
    }

    @Override
    public String changeValve(JSONObject jsonObject) throws Exception {
        //消息序号
        String count = jsonObject.get("instructCount").toString();
        //注册帧获取的随机数
        String random = jsonObject.getString("random");
        byte[] randomByte = ConvertTools.hexStrToByte(random);

        String value = jsonObject.get("ValveState").toString();
        byte values = (byte) (1 - Byte.parseByte(value));

        byte[] data = {values};
        // 05H 写数据
        int control =Integer.parseInt("10000101",2);

        return getInstruct("0001",control,Integer.parseInt(count),data,randomByte,true,true);
    }

    @Override
    public String syncAmount(JSONObject jsonObject) throws Exception {
        return null;
    }

    @Override
    public String endPoint(JSONObject jsonObject) throws Exception {
        //消息序号
        String count = jsonObject.get("instructCount").toString();
        int counts = Integer.parseInt(count);
        //注册帧获取的随机数
        String random = jsonObject.getString("random");
        byte[] randomByte = ConvertTools.hexStrToByte(random);
        // 0 气量 1 金额
        int type =  Integer.parseInt(jsonObject.get("type").toString());
        // 下发需要参数
        //余额
        String amount = jsonObject.get("amount").toString();
        //单价
        String price = jsonObject.get("price").toString();
        //总购
        String totalgas = jsonObject.get("totalgas").toString();

        byte[] data = new byte[26];

        byte[] dateByte = date2bcd(DateTools.getNow("yyMMddHHmmss"),false);
        System.arraycopy(dateByte,0,data,2,6);

        byte tzzt = 0;
        byte ylzt = 0;
        if(type == 0){
            int gas = CommonTools.mul(amount,1000,0).intValue();
            System.arraycopy(Int2bcd(gas,false),0,data,8,4);
            if(gas < 0) tzzt = 1;
            if(gas < 5) ylzt =1;
        }else if(type == 1){
            int money = CommonTools.mul(amount,100,0).intValue();
            System.arraycopy(IntToByte(money,false),0,data,18,4);
            if(money < 0) tzzt = 1;
            if(money < 5) ylzt =1;
        }
        data[12] = tzzt;
        data[13] = ylzt;

        int prices =  CommonTools.mul(price,10000,0).intValue();
        System.arraycopy(IntToByte(prices,false),0,data,14,4);
        int totalgas2 =  CommonTools.mul(totalgas,100,0).intValue();//原本为1000，表厂说改成100
        if(type == 0){
            System.arraycopy(Int2bcd(totalgas2,false),0,data,22,4);
        }else if(type == 1){
            System.arraycopy(IntToByte(totalgas2,false),0,data,22,4);
        }
        // 02H 数据下发
        int control =Integer.parseInt("10000010",2);
        randoms.remove(jsonObject.get("meternumber").toString());
        return getInstruct("3002",control,counts,data,randomByte,true,true);

    }

    /**
     *  读取随机数
     * @param jsonObject
     * @return
     * @throws Exception
     */
    @Override
    public String syncParam(JSONObject jsonObject) throws Exception {
        //消息序号
        String count = jsonObject.get("instructCount").toString();
        //注册帧获取的随机数
        String random = jsonObject.getString("random");
        byte[] randomByte = ConvertTools.hexStrToByte(random);

        // 04H
        int control =Integer.parseInt("10000101",2);

        byte[] data = new byte[]{0x01};

        return  getInstruct("000E",control,Integer.parseInt(count),data,randomByte,true,true);

    }

    public String syncIdleValveClosing(JSONObject jsonObject) throws Exception {
        //消息序号
        String count = jsonObject.get("instructCount").toString();
        String days = jsonObject.get("closingDays").toString();
        //注册帧获取的随机数
        String random = jsonObject.getString("random");
        byte[] randomByte = ConvertTools.hexStrToByte(random);

        // 04H
        int control =Integer.parseInt("10000101",2);

        byte[] data = new byte[]{(byte) Integer.parseInt(days)};

        return  getInstruct("2010",control,Integer.parseInt(count),data,randomByte,true,true);
    }


    public JSONObject encode(String data,String meterNumber) throws Exception {
        byte[] code = ConvertTools.hexStrToByte(data);
        return encode(code,meterNumber);
    }

    public JSONObject encode(byte[] code,String meterNumber) throws Exception {
        JSONObject jsonObject = new JSONObject();

        if((code[0] & 0xFF) != 0x68 && (code[code.length-1] & 0xFF) != 0x16){
            jsonObject.put("isSuccess", false);
            jsonObject.put("errCode",1);
            jsonObject.put("errMsg","报文格式有误");
            return jsonObject;
        }

        String midcrs = toHexString(shortToByte(CRC16(code, 5, code.length-3),false),0,2,false);
        String mid = toHexString(code, code.length - 3, 2,false);
        if (!midcrs.equals(mid)) {
            jsonObject.put("isSuccess", false);
            jsonObject.put("errCode", 2);
            jsonObject.put("errorMsg", "数据校验码错误");
            return jsonObject;
        }
        int length = Integer.parseInt(toHexString(code,3,2,false),16);
        int count = code[5];
        jsonObject.put("count",count);
        String mdmCode = toHexString(code,7,2,false);
        jsonObject.put("mdmCode",mdmCode);
        byte[] data = new byte[length - 12];
        System.arraycopy(code,9,data,0,length-12);

        switch (mdmCode){
            case "2010":
            case "000E":
            case "0001": {
                boolean success = data[0] == 0x00 && data[1] == 0x00;
                jsonObject.put("success", success);
                jsonObject.put("random", randoms.get(meterNumber));
                break;
            }
            case "3001": {
                //表上时间
                String meterDate = toHexString(data, 0, 6, false);
                jsonObject.put("meterDate", meterDate);

                int openState = data[54];
                jsonObject.put("openState", openState);
                //表号
                byte len= data[10];

                String meternumber = new String(data, 11, len, StandardCharsets.UTF_8);
                jsonObject.put("meternumber", meternumber);

                //通信随机码
                String random = toHexString(data, 61, 16,false);
                jsonObject.put("random", random);
                randoms.put(meternumber,random);
                String IMEI = new String(data, 90, 15,StandardCharsets.UTF_8);
                jsonObject.put("IMEI", IMEI);

                break;
            }
            case "3003": {
                byte[] resultDate = decrypt_by_aes(data,ConvertTools.hexStrToByte(hexKey));
                //表上时间
                String meterDate = toHexString(resultDate, 0, 6, false);
                jsonObject.put("meterDate", meterDate);
                //当前累计气量
                int useGas = Integer.parseInt(toHexString(resultDate,6,4,false),16);
                double totalUseGas =  CommonTools.div(useGas,1000,3).doubleValue();
                jsonObject.put("meterBrand", totalUseGas);
                jsonObject.put("random", randoms.get(meterNumber));

                switch (resultDate[150]){
                    case 0:
                    case 1: {
                        jsonObject.put("upType",0);
                        break;
                    }
                    case 2:{
                        jsonObject.put("upType",1);
                        break;
                    }
                }

                byte[] errorByte0 = ConvertTools.binaryStrToBinaryArray(MeterTools.toBinArrayString(resultDate[10] & 0xFF,true).substring(0,8));
                byte[] errorByte1 = ConvertTools.binaryStrToBinaryArray(MeterTools.toBinArrayString(resultDate[11] & 0xFF,true).substring(0,8));

                JSONObject json = new JSONObject();
                // 阀门状态 阀门状态（0：关；1：开）
                json.put("valveState", errorByte0[0]);
                // 表具被强制命令关阀（0：否；1：是）
                json.put("valveMustState", errorByte0[1]);
                // 主电电量低（0：否；1：是）
                json.put("Battery1Status", errorByte0[2]);
                // 备电电量不足（0：否；1：是）
                json.put("Battery2Status", errorByte0[3]);
                // 无备电，系统不能正常工作（0：否；1：是）
                json.put("SystemState", errorByte0[4]);
                // 过流（0：否；1：是）
                json.put("OverCurrent",errorByte0[5]);
                // 阀门直通（0：否；1：是）
                json.put("ValveStraightThrough", errorByte0[6]);
                // 外部报警触发（0：否；1：是）
                json.put("OutAlarm", errorByte0[7]);
                // 计量模块异常（0：否；1：是）
                json.put("MeteringModule",errorByte1[0]);
                // 多少天不用气导致阀门关闭（0：否；1：是）
                json.put("IdleValveClosing",errorByte1[1]);
                // 曾出现多天没有远传数据上发成功而导致阀门关闭（0：否；1：是）
                json.put("LossValveClosing", errorByte1[2]);
                // 电磁干扰（0：否；1：是）
                json.put("EMI",errorByte1[3]);
                // 外壳拆卸告警（0：否；1：是）
                json.put("ShellAlarm",errorByte1[4]);

                jsonObject.put("meterStatus",json);

                break;
            }
        }

        jsonObject.put("isSuccess", true);
        jsonObject.put("errCode", 0);
        jsonObject.put("errorMsg", "解析成功");

        return jsonObject;
    }



    private String getInstruct(String meterCode, int HEXControl ,int count ,byte[] data ,byte[] random, boolean hasEncode ,boolean hasMac ) throws Exception {
        byte[] instruct = new byte[500];
        instruct[0] = 0x68;
        instruct[1] = 0x00;
        instruct[2] = 0x00;
        instruct[5] = (byte)count;
        instruct[6] = (byte)HEXControl;
        System.arraycopy(ConvertTools.hexStrToByte(meterCode),0,instruct,7,2);
        int length = 0;
        byte[] encoding;
        if(data != null) {

            if (hasEncode) {
                encoding = encrypt_by_aes(data, ConvertTools.hexStrToByte(hexKey));
            } else {
                encoding = data;
            }

            System.arraycopy(encoding, 0, instruct, 9, encoding.length);
            length = encoding.length;

            if(hasMac){
                byte[] macMid = new byte[random.length + length];
                System.arraycopy(random,0,macMid,0,random.length);
                System.arraycopy(encoding,0,macMid,random.length,length);
                byte[] MacKey =  new byte[16];
                System.arraycopy(encrypt_by_aes(random,ConvertTools.hexStrToByte(hexKey)),0,MacKey,0,16);
                byte[] MAC = HMACSHA256(macMid,MacKey);
                System.arraycopy(MAC,0,instruct,9 + encoding.length,MAC.length);
                length = 9 + encoding.length + MAC.length;
            }else {
                length += 9;
            }

        }else {
            length = 9 ;
        }

        System.arraycopy(shortToByte((short) (length + 3),false),0,instruct,3,2);
        short crc16 = CRC16(instruct,5,length);
        System.arraycopy(shortToByte(crc16,false),0,instruct,length,2);

        instruct[length + 2] = 0x16;
        return toHexString(instruct, 0, length+3, false);
    }

}
