package com.aote.webmeter.module.main.nb.impl.qinchuan;

import com.af.plugins.CommonTools;
import com.af.plugins.ConvertTools;
import com.af.plugins.DateTools;

import com.af.plugins.RestTools;
import com.aote.webmeter.module.main.nb.impl.MeterTools;
import org.apache.log4j.Logger;
import org.json.JSONObject;


public class QinChuanNBTools extends MeterTools {

    private static Logger logger = Logger.getLogger(QinChuanNBTools.class.getName());

    // 传输秘钥
    private final String userCSKey0 = "01301051646353";

    // 维护秘钥
    private final String userWHKey0 = "013010516463531";

    private final String ModuleUrl = "http://127.0.0.1:8004/MACCode";

    // 传输秘钥
    private final String userCSKey1 = "2547246818369445541";

    // 维护秘钥
    private final String userWHKey1 = "5140166053543679562";

    private byte protocolVer = 0x20;
    /**
     *
     * 开户
     * @param jsonObject
     * @return
     * @throws Exception
     */
    @Override
    public String openAccount(JSONObject jsonObject) throws Exception {
        // 指令流水号 1-255
        int instructTime = Integer.parseInt(jsonObject.optString("instructTimes"));
        byte instructTimes = (byte) (instructTime % 255 == 0 ? 255 : instructTime % 255);
        //
        String meternumber = jsonObject.optString("meternumber");

        int meter = Integer.parseInt(meternumber);

        byte[] meterCode = ConvertTools.hexStrToByte(addZone(meternumber, 8));
        // 气价起始时间
        int startMoth = DateTools.getMonth(jsonObject.optString("startDate"))-1;
        // 用气类型
        int priceType = Integer.parseInt(jsonObject.get("priceType").toString());
        // 一阶单价
        double price1 = Double.parseDouble(jsonObject.get("price1").toString());
        // 充值金额
        double amount = Double.parseDouble(jsonObject.get("amount").toString());
        // 报警门限
        int alarm = Integer.parseInt(jsonObject.get("alarm").toString());
        byte[] instruct = new byte[20];
        instruct[0] = 57;
        instruct[1] = Byte.parseByte("00000010",2);
        instruct[2] = (byte) priceType;
        instruct[3] = (byte) startMoth;
        System.arraycopy(shortToByte((short) (8888),true),0,instruct,4,2);
        System.arraycopy(shortToByte((short) (price1 * 100),true),0,instruct,6,2);
        System.arraycopy(meterCode, 0, instruct, 8, 4);
        System.arraycopy(IntToByte((int) (amount*100),true),0,instruct,12,4);
        System.arraycopy(shortToByte((short) (alarm),true),0,instruct,16,2);
        instruct[19] = (byte) (Math.random() * 100);

        return getInstruct(instruct,meternumber,instructTimes,1,0);
    }


    /**
     *
     * 清零
     * @param jsonObject
     * @return
     * @throws Exception
     */
    public String cleanMeter(JSONObject jsonObject) throws Exception {
        // 指令流水号 1-255
        int instructTime = Integer.parseInt(jsonObject.optString("instructTimes"));
        byte instructTimes = (byte) (instructTime % 255 == 0 ? 255 : instructTime % 255);

        String meternumber = jsonObject.optString("meternumber");
        byte[] instruct = new byte[4];
        instruct[0] = 53;
        instruct[1] = (byte) (Math.random() * 100);
        instruct[2] = (byte) (Math.random() * 100);
        instruct[3] = (byte) (Math.random() * 100);
        return getInstruct(instruct,meternumber,instructTimes,1,1);
    }

    /**
     * 缴费
     * @param jsonObject
     * @return
     * @throws Exception
     */
    @Override
    public String charge(JSONObject jsonObject) throws Exception {
        // 指令流水号 1-255
        int instructTime = Integer.parseInt(jsonObject.optString("instructTimes"));
        byte instructTimes = (byte) (instructTime % 255 == 0 ? 255 : instructTime % 255);

        String meternumber = jsonObject.optString("meternumber");
        int times = Integer.parseInt(jsonObject.optString("times"));
        // 上次购气金额
        double lastAmount = Double.parseDouble(jsonObject.optString("lastAmount"));
        // 上上次购气金额
        double lastAmount2 = Double.parseDouble(jsonObject.optString("lastAmount2"));
        // 购气金额
        double amount = Double.parseDouble(jsonObject.optString("amount"));
        // 报警门限
        int alarm = Integer.parseInt(jsonObject.optString("alarm"));

        byte[] instruct = new byte[20];
        instruct[0] = 58;
        instruct[1] = (byte) (Math.random() * 100);
        System.arraycopy(shortToByte((short) times,true),0,instruct,2,2);
        System.arraycopy(IntToByte((int) (lastAmount2 * 100),true),0,instruct,4,4);
        System.arraycopy(IntToByte((int) (lastAmount * 100),true),0,instruct,8,4);
        System.arraycopy(IntToByte((int) (amount * 100),true),0,instruct,12,4);
        System.arraycopy(shortToByte((short) alarm,true),0,instruct,16,2);
        instruct[18] = (byte) (Math.random() * 100);
        instruct[19] = (byte) (Math.random() * 100);

        return getInstruct(instruct,meternumber,instructTimes,1,1);
    }

    /**
     * 阶梯方案信息同步
     * @param jsonObject
     * @return
     * @throws Exception
     */
    @Override
    public String changePrice(JSONObject jsonObject) throws Exception {

        // 指令流水号 1-255
        int instructTime = Integer.parseInt(jsonObject.optString("instructTimes"));
        byte instructTimes = (byte) (instructTime % 255 == 0 ? 255 : instructTime % 255);

        String meternumber = jsonObject.optString("meternumber");
        // 调价时间
        String changeDate = jsonObject.optString("changeDate");
        // 价格开始时间
        String beginDate = jsonObject.optString("beginDate");
        // 是否清除周期累计用气量  0：不清除 1：清除
        String isClear = jsonObject.optString("isClear");
        // 是否立即调价 0：指定时间调价 1：立即调价
        String changeType = jsonObject.optString("changeType");
        // 调价次数 1-255
        int changeTime = Integer.parseInt(jsonObject.optString("changeTimes"));
        byte changeTimes = (byte) (changeTime % 255 == 0 ? 255 : changeTime % 255);
        // 阶梯气价
        double price1 = Double.parseDouble(jsonObject.optString("price1"));
        double price2 = Double.parseDouble(jsonObject.optString("price2"));
        double price3 = Double.parseDouble(jsonObject.optString("price3"));
        // 阶梯气量
        double gas1 = Double.parseDouble(jsonObject.optString("gas1"));
        double gas2 = Double.parseDouble(jsonObject.optString("gas2"));

        // 新用气类型
        int newPriceType = Integer.parseInt(jsonObject.optString("newPriceType"));
        // 旧用气类型
        int oldPriceType = Integer.parseInt(jsonObject.optString("oldPriceType",String.valueOf(newPriceType)));
        byte[] instruct = new byte[20];
        instruct[0] = 61;
        //调价年
        String dateYearBin = Integer.toBinaryString(Integer.parseInt(DateTools.getNowYear()) % 100);
        instruct[1] = Byte.parseByte("0" + addZone(dateYearBin, 7), 2);
        //调价月
        String dateMonthBin = Integer.toBinaryString(DateTools.getMonth(changeDate) - 1);
        //开始月
        String beginMonthBin = Integer.toBinaryString(DateTools.getMonth(beginDate) - 1);
        instruct[2] = Byte.parseByte(addZone(beginMonthBin, 4) + addZone(dateMonthBin, 4), 2);
        //调价日
        String dateDayBin = Integer.toBinaryString(Integer.parseInt(beginDate.substring(6, 8)) - 1);
        instruct[3] = Byte.parseByte("0" + isClear + changeType + addZone(dateDayBin, 5), 2);
        //
        instruct[4] = changeTimes;
        //
        instruct[5] = Byte.parseByte("000" + addZone(dateDayBin, 5), 2);
        //
        System.arraycopy(shortToByte((short) (gas1), true), 0, instruct, 6, 2);
        System.arraycopy(shortToByte((short) (price1 * 100), true), 0, instruct, 8, 2);
        System.arraycopy(shortToByte((short) (gas2), true), 0, instruct, 10, 2);
        System.arraycopy(shortToByte((short) (price2 * 100), true), 0, instruct, 12, 2);
        System.arraycopy(shortToByte((short) 65535, true), 0, instruct, 14, 2);
        System.arraycopy(shortToByte((short) (price3 * 100), true), 0, instruct, 16, 2);


        instruct[18] = (byte) oldPriceType;
        instruct[19] = (byte) newPriceType;


        return getInstruct(instruct, meternumber, instructTimes,1,1);
    }


    public String updatePassword(JSONObject jsonObject) throws Exception {
        int instructTime = Integer.parseInt(jsonObject.optString("instructTimes"));
        byte instructTimes = (byte) (instructTime % 255 == 0 ? 255 : instructTime % 255);

        String meternumber = jsonObject.optString("meternumber");
        byte[] instruct = new byte[20];

        instruct[0] = 56;
        instruct[1] = 1;
        byte[] csKey = ConvertTools.hexStrToByte("0000012EECB8A191");
        byte[] whKey = ConvertTools.hexStrToByte("00000BD53F364FAB");


        System.arraycopy(csKey,0,instruct,2,8);
        System.arraycopy(whKey,0,instruct,10,8);

        instruct[18] = 1;
        instruct[19] = (byte) (Math.random() * 100);

        return getInstruct(instruct, meternumber, instructTimes,2,0);

    }

    @Override
    public String changeValve(JSONObject jsonObject) throws Exception {
        // 指令流水号 1-255
        int instructTime = Integer.parseInt(jsonObject.optString("instructTimes"));
        byte instructTimes = (byte) (instructTime % 255 == 0 ? 255 : instructTime % 255);

        String meternumber = jsonObject.optString("meternumber");

        int value = Integer.parseInt(jsonObject.optString("value"));

        byte[] instruct = new byte[4];


        if(value == 1){
            instruct[0] = 59;
        }else {
            instruct[0] = 60;
        }
        instruct[1] = (byte) (Math.random() * 100);
        instruct[2] = (byte) (Math.random() * 100);
        instruct[3] = (byte) (Math.random() * 100);
        return getInstruct(instruct,meternumber,instructTimes,1,1);
    }

    @Override
    public String syncAmount(JSONObject jsonObject) throws Exception {
        return null;
    }

    @Override
    public String endPoint(JSONObject jsonObject) throws Exception {
        return null;
    }

    @Override
    public String syncParam(JSONObject jsonObject) throws Exception {
        return null;
    }

    public JSONObject encode(String code) throws Exception {
        return encode(ConvertTools.hexStrToByte(code));
    }



    public JSONObject encode(byte[] code) throws Exception {
        JSONObject jsonObject = new JSONObject();

        int length = code[0] & 0xFF;

        int midcscs = CRC16(code,0,length+1);

        if (midcscs != 0) {
            jsonObject.put("isSuccess", false);
            jsonObject.put("errCode", 2);
            jsonObject.put("errorMsg", "数据校验码错误");
            return jsonObject;
        }

        int meternumber =  Integer.parseInt(toHexString(code,2,4,true),16);

        protocolVer = code[6];
        int cmdCode = code[7];
        // 密块类型
        String binArray = addZone(Integer.toBinaryString((code[9] & 0xFF)),8);
        //
        int serKey = Integer.parseInt(binArray.substring(0,4),2);
        int serLen = Integer.parseInt(binArray.substring(4),2);

        byte[] data = new byte[length-18];
        System.arraycopy(code,13,data,0,length-18);

        String serKeyStr = "";

        if(code[12] ==  0) {
            if (serKey == 1 || serKey == 3) {
                serKeyStr = userCSKey1;
            } else {
                serKeyStr = userWHKey1;
            }

        }else if(code[12] == 1){
            if (serKey == 1 || serKey == 3) {
                serKeyStr = userCSKey0;
            } else {
                serKeyStr = userWHKey0;
            }
        }

        byte[] macdata = new byte[8];
        macdata[0] = code[2];
        System.arraycopy(code, 6, macdata, 1, 7);

        String result = setData(data,serKeyStr,macdata,1);

        System.out.println(result);
        JSONObject jsonObject1 = new JSONObject(result);
        System.out.println("jsonObject1 " + jsonObject1);
        if(jsonObject1.getInt("result") != 1){
            jsonObject.put("isSuccess", false);
            jsonObject.put("errCode", 3);
            jsonObject.put("errorMsg", "数据解析错误");
            return jsonObject;
        }

        String resCode = jsonObject1.optString("resultData");
        String MACData = jsonObject1.optString("macData");

        byte[] reCode = ConvertTools.hexStrToByte(resCode);

        System.out.println("recode : " +ConvertTools.byteToHexStr(reCode));

        System.out.println("macdata : " +MACData);

        String MacData = toHexString(code,length-5,4,false);

        if(!MACData.substring(0,8).equals((MacData))){
            jsonObject.put("isSuccess", false);
            jsonObject.put("errCode", 4);
            jsonObject.put("errorMsg", "MAC校验错误");
            return jsonObject;
        }

        jsonObject.put("cmdCode",cmdCode);
        jsonObject.put("instructTimes",(code[8]&0xFF));
        jsonObject.put("meternumber",meternumber);

        switch (cmdCode){
            case 63: {
                int part = reCode[5];
                if (part == 0) {
                    // 表上剩余金额
                    String value = toHexString(reCode, 8, 3, true) + toHexString(reCode, 11, 1, false);
                    double reAmount = CommonTools.div(Integer.parseInt(value, 16), 10000, 4).doubleValue();
                    jsonObject.put("jval", reAmount);
                    // 表上周期用量
                    String cycleGasHex = toHexString(reCode, 12, 4, true);
                    double cycleGas = CommonTools.div(Integer.parseInt(cycleGasHex, 16), 100, 4).doubleValue();
                    jsonObject.put("cycleGas", cycleGas);
                    // 表上累计用气量
                    String useGasHex = toHexString(reCode, 16, 4, true);
                    double useGas = CommonTools.div(Integer.parseInt(useGasHex, 16), 100, 4).doubleValue();
                    jsonObject.put("useGas", useGas);
                    //
                } else if (part == 1) {
                    // 调价次数
                    jsonObject.put("changeTimes", reCode[7] & 0xFF);
                    // 用气类型
                    jsonObject.put("userType", reCode[8] & 0xFF);
                    //  充值次数
                    jsonObject.put("times", Integer.parseInt(toHexString(reCode, 15, 2, false), 16));
                    // 累计充值量
                    jsonObject.put("totalMoney", CommonTools.div(Integer.parseInt(toHexString(reCode, 17, 4, false), 16), 100, 2));
                    // 当前单价
                    jsonObject.put("price", CommonTools.div(Integer.parseInt(toHexString(reCode, 21, 2, false), 16), 100, 2));
                }
                jsonObject.put("part", part);
                break;
            }
            default:{
                boolean success = false;
                if (reCode[5] == 0 || reCode[5] == 1|| reCode[5] == 2){
                    success = true;
                }
                jsonObject.put("success",success);
                logger.debug("返回结果" + reCode[5]);
                break;
            }
        }

        jsonObject.put("isSuccess", true);
        jsonObject.put("errCode", 0);
        jsonObject.put("errorMsg", "解析成功");

        return jsonObject;
    }


    private  String getInstruct(byte[] instruct,String meternumber,byte instructTime,int keyType,int keyNum) throws Exception {
        byte[] result = new byte[23 + instruct.length];
        result[0] = (byte) (result.length - 1);
        result[1] = (byte) Integer.parseInt("00100110", 2);
        // 表号
        int meter = Integer.parseInt(meternumber);
        byte[] meterCode = HexToBytes(addZone(Integer.toHexString(meter), 8), true);
        System.out.println("meterCode:" + ConvertTools.byteToHexStr(meterCode));
        System.arraycopy(meterCode, 0, result, 2, 4);
        // 协议版本
        // int protocolVer = 11;
        result[6] = protocolVer;
        //
        result[7] = 0x05;
        //
        result[8] = instructTime;
        //
        result[9] = Byte.parseByte(addZone(Integer.toBinaryString(keyType), 4) + addZone(Integer.toBinaryString(instruct.length + 4 >> 3), 4), 2);
        //
        System.arraycopy(shortToByte((short) (8888),true),0,result,10,2);
        // 版本号
        result[12] = (byte) keyNum;


        //
        System.arraycopy(meterCode, 0, result, 13, 4);
        //
        System.arraycopy(instruct, 0, result, 17, instruct.length);

        byte[] cmdData = new byte[instruct.length + 4];
        System.arraycopy(result, 13, cmdData, 0, instruct.length + 4);

        String serKeyStr = "";

        if(keyNum ==  0) {
            if (keyType == 1 || keyType == 3) {
                serKeyStr = userCSKey1;
            } else {
                serKeyStr = userWHKey1;
            }

        }else if(keyNum == 1){
            if (keyType == 1 || keyType == 3) {
                serKeyStr = userCSKey0;
            } else {
                serKeyStr = userWHKey0;
            }
        }

        // 进行加密
        byte[] macdata = new byte[8];
        macdata[0] = result[2];
        System.arraycopy(result, 6, macdata, 1, 7);

        String returnData = setData(cmdData,serKeyStr,macdata,0);

        System.out.println(returnData);
        JSONObject jsonObject1 = new JSONObject(returnData);
        System.out.println("jsonObject1 " + jsonObject1);

        String resCode = jsonObject1.optString("resultData").replace("\u0000","");
        String MACData = jsonObject1.optString("macData").replace("\u0000","");

        byte[] reCode = ConvertTools.hexStrToByte(resCode);

        byte[] MacData = ConvertTools.hexStrToByte(MACData);

        System.out.println("recode : " + resCode);

        System.out.println("macdata : " + MACData);

        System.arraycopy(reCode, 0, result, 13, reCode.length);
        System.arraycopy(MacData, 0, result, 13 + reCode.length, 4);

        short clc = CRC16(result, 0, 17 + cmdData.length);

        System.arraycopy(shortToByte(clc, false), 0, result, 17 + cmdData.length, 2);

        return toHexString(result, 0, result.length, false);
    }


    public String setData(byte[] data , String serKeyStr, byte[] macdata, int type){
        JSONObject sendData = new JSONObject();
        sendData.put("code",ConvertTools.byteToHexStr(data));
        sendData.put("key",serKeyStr);
        sendData.put("keyFactor",ConvertTools.byteToHexStr(macdata));
        // 0: 加密  1：解密
        sendData.put("type",type);

        JSONObject hander = new JSONObject();
        hander.put("Content-Type","text/plain");

        String url = "http://127.0.0.1:8004/MACCode";

        return RestTools.post(url,sendData,hander);
    }

    public static void main(String[] args) throws Exception {
        QinChuanNBTools qinChuanNBTools = new QinChuanNBTools();
        JSONObject jsonObject = new JSONObject();

        jsonObject.put("instructTimes",2);
        jsonObject.put("amount",10);
        jsonObject.put("priceType",1);
        jsonObject.put("alarm",5);
        jsonObject.put("startDate","20210101");
        jsonObject.put("price1",2.35);
        jsonObject.put("meternumber","4433585");
        jsonObject.put("beginDate","20210101");
        jsonObject.put("newPriceType",9);
        jsonObject.put("oldPriceType",9);
        jsonObject.put("changeTimes",30);
        jsonObject.put("changeType",1);
        jsonObject.put("changeDate","20210101");
        jsonObject.put("gas1",65535);
        jsonObject.put("gas2",65535);
        jsonObject.put("price1",2.35);
        jsonObject.put("price2",2.35);
        jsonObject.put("price3",2.35);
        jsonObject.put("isClear",0);

        String open = qinChuanNBTools.changePrice(jsonObject);
        System.out.println("open :" + open);

//        String updatePassword = qinChuanNBTools.updatePassword(jsonObject);
//        System.out.println("updatePassword :" + updatePassword);
//
//        String changePrice = qinChuanNBTools.changePrice(jsonObject);
//        System.out.println("changePrice :" + changePrice);
//
//        JSONObject _1 = qinChuanNBTools.encode("2A03B1A64300203F121300000085D3E18A0653A0B7151BE8939B95B538F531599BBCCAD0F6D30F484F27BFD03839383631313138323839303030343438363531");
//
//        JSONObject encode = qinChuanNBTools.encode("2A07B1A64300203FFD1300000085D3E18A0653A0B7151BE8939B95B538F531599BBCCAD0F6DC75DD20BFBCD0");
//
//        System.out.println(_1);
//        System.out.println(encode);


//        int midcscs = CRC16(ConvertTools.hexStrToByte("2A07B1A64300203FFD1300000085D3E18A0653A0B7151BE8939B95B538F531599BBCCAD0F6DC75DD20"),0,0x2A-1);
//        System.out.println("midcscs :" + ConvertTools.byteToHexStr(shortToByte((short) midcscs,false)));

    }

}
